/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.rim.blackberry.api.browser.Browser;
import net.rim.blackberry.api.browser.BrowserSession;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.io.Base64OutputStream;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.util.DataBuffer;
import org.logicprobe.LogicMail.message.ImageContent;
import org.logicprobe.LogicMail.message.MessageContent;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.TextContent;
import org.logicprobe.LogicMail.message.TextPart;

public class MessageFieldFactory {
    private static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");

    public static Field createMessageField(MessageContent content) {
        Field field = content instanceof TextContent ? MessageFieldFactory.createTextMessageField((TextContent)content) : (content instanceof ImageContent ? MessageFieldFactory.createImageMessageField((ImageContent)content) : MessageFieldFactory.createUnsupportedMessageField(content));
        return field;
    }

    private static Field createTextMessageField(TextContent content) {
        TextPart part = (TextPart)content.getMessagePart();
        if (part.getMimeSubtype().equalsIgnoreCase("html")) {
            ButtonField browserButtonField = new ButtonField("Open HTML in browser...", 0x300000000L);
            browserButtonField.setChangeListener((FieldChangeListener)new MessageFieldChangeListener(content){

                public void fieldChanged(Field field, int context) {
                    TextContent content = this.getContent();
                    try {
                        DataBuffer buffer = new DataBuffer();
                        buffer.write(content.getText().getBytes());
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        Base64OutputStream boutput = new Base64OutputStream((OutputStream)output);
                        output.write("data:text/html;base64,".getBytes());
                        boutput.write(buffer.getArray());
                        boutput.flush();
                        boutput.close();
                        output.flush();
                        output.close();
                        BrowserSession browserSession = Browser.getDefaultSession();
                        browserSession.displayPage(output.toString());
                    }
                    catch (Throwable t) {
                        EventLogger.logEvent((long)7765914274915215232L, (byte[])("Error launching browser: " + t.toString()).getBytes(), (int)2);
                        Dialog.alert((String)"Unable to display the HTML message in the browser.");
                    }
                }
            });
            VerticalFieldManager browserButtonFieldManager = new VerticalFieldManager(0x1000000000000000L);
            browserButtonFieldManager.add((Field)new LabelField());
            browserButtonFieldManager.add((Field)browserButtonField);
            browserButtonFieldManager.add((Field)new LabelField());
            return browserButtonFieldManager;
        }
        return new RichTextField(content.getText());
    }

    private static Field createImageMessageField(ImageContent content) {
        return new BitmapField(content.getImage().getBitmap());
    }

    private static Field createUnsupportedMessageField(MessageContent content) {
        MessagePart part = content.getMessagePart();
        return new RichTextField(resources.getString(84) + ' ' + part.getMimeType() + '/' + part.getMimeSubtype());
    }

    private static abstract class MessageFieldChangeListener
    implements FieldChangeListener {
        private TextContent content;

        public MessageFieldChangeListener(TextContent content) {
            this.content = content;
        }

        protected TextContent getContent() {
            return this.content;
        }

        public abstract /* synthetic */ void fieldChanged(Field var1, int var2);
    }
}

