/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Vector;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.NullField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.VerticalFieldManager;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.message.MessageContent;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartTransformer;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.Address;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.BorderedFieldManager;
import org.logicprobe.LogicMail.ui.MailboxSelectionDialog;
import org.logicprobe.LogicMail.ui.MessageFieldFactory;
import org.logicprobe.LogicMail.ui.MessagePropertiesScreen;
import org.logicprobe.LogicMail.ui.NavigationController;
import org.logicprobe.LogicMail.ui.ThrobberField;

public class MessageScreen
extends BaseScreen {
    private BorderedFieldManager addressFieldManager;
    private BorderedFieldManager subjectFieldManager;
    private VerticalFieldManager messageFieldManager;
    private AccountConfig accountConfig;
    private MessageNode messageNode;
    private boolean isSentFolder;
    private boolean messageRendered;
    private ThrobberField throbberField;
    private MessageNodeListener messageNodeListener = new MessageNodeListener(){

        public void messageStatusChanged(MessageNodeEvent e) {
            MessageScreen.this.messageNode_MessageStatusChanged(e);
        }
    };
    private MenuItem propsItem = new MenuItem(BaseScreen.resources, 70, 100, 10){

        public void run() {
            MessagePropertiesScreen screen = new MessagePropertiesScreen(MessageScreen.this.messageNode);
            UiApplication.getUiApplication().pushScreen((Screen)screen);
        }
    };
    private MenuItem replyItem = new MenuItem(BaseScreen.resources, 85, 110, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                MessageScreen.this.getNavigationController().displayCompositionReply(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, false);
            }
        }
    };
    private MenuItem replyAllItem = new MenuItem(BaseScreen.resources, 86, 115, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                MessageScreen.this.getNavigationController().displayCompositionReply(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, true);
            }
        }
    };
    private MenuItem forwardItem = new MenuItem(BaseScreen.resources, 87, 120, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                MessageScreen.this.getNavigationController().displayCompositionForward(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode);
            }
        }
    };
    private MenuItem copyToItem = new MenuItem(BaseScreen.resources, 92, 125, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
                MailboxSelectionDialog dialog = new MailboxSelectionDialog(BaseScreen.resources.getString(94), accountNodes);
                dialog.setSelectedMailboxNode(MessageScreen.this.messageNode.getParent());
                dialog.addUnselectableNode(MessageScreen.this.messageNode.getParent());
                dialog.doModal();
                MailboxNode selectedMailbox = dialog.getSelectedMailboxNode();
                if (selectedMailbox != null && selectedMailbox != MessageScreen.this.messageNode.getParent()) {
                    selectedMailbox.appendMessage(MessageScreen.this.messageNode);
                }
            }
        }
    };
    private MenuItem moveToItem = new MenuItem(BaseScreen.resources, 93, 130, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
                MailboxSelectionDialog dialog = new MailboxSelectionDialog(BaseScreen.resources.getString(95), accountNodes);
                dialog.setSelectedMailboxNode(MessageScreen.this.messageNode.getParent());
                dialog.addUnselectableNode(MessageScreen.this.messageNode.getParent());
                dialog.doModal();
                MailboxNode selectedMailbox = dialog.getSelectedMailboxNode();
                if (selectedMailbox != null && selectedMailbox != MessageScreen.this.messageNode.getParent()) {
                    selectedMailbox.appendMessage(MessageScreen.this.messageNode);
                }
            }
        }
    };
    private MenuItem compositionItem = new MenuItem(BaseScreen.resources, 73, 150, 10){

        public void run() {
            MessageScreen.this.getNavigationController().displayComposition(MessageScreen.this.messageNode.getParent().getParentAccount());
        }
    };
    private MenuItem closeItem = new MenuItem(BaseScreen.resources, 3, 200000, 10){

        public void run() {
            MessageScreen.this.onClose();
        }
    };

    public MessageScreen(NavigationController navigationController, MessageNode messageNode) {
        super(navigationController, 0x100000000000L);
        String subject;
        this.messageNode = messageNode;
        this.accountConfig = messageNode.getParent().getParentAccount().getAccountConfig();
        int mailboxType = messageNode.getParent().getType();
        this.isSentFolder = mailboxType == 4 || mailboxType == 2;
        this.addressFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_NONE);
        this.subjectFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_LINE);
        this.messageFieldManager = new VerticalFieldManager();
        if (this.isSentFolder) {
            Address[] to = messageNode.getTo();
            if (to != null && to.length > 0) {
                this.addressFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(80) + " " + to[0]));
                if (to.length > 1) {
                    for (int i = 1; i < to.length; ++i) {
                        if (to[i] == null) continue;
                        this.addressFieldManager.add((Field)new RichTextField("    " + to[i]));
                    }
                }
            }
        } else {
            Address[] from = messageNode.getFrom();
            if (from != null && from.length > 0) {
                this.addressFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(78) + " " + from[0]));
                if (from.length > 1) {
                    for (int i = 1; i < from.length; ++i) {
                        if (from[i] == null) continue;
                        this.addressFieldManager.add((Field)new RichTextField("      " + from[i]));
                    }
                }
            }
        }
        if ((subject = messageNode.getSubject()) != null) {
            this.subjectFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(76) + " " + subject));
        }
        this.add((Field)this.addressFieldManager);
        this.add((Field)this.subjectFieldManager);
        this.add((Field)this.messageFieldManager);
    }

    protected void onDisplay() {
        super.onDisplay();
        this.messageNode.addMessageNodeListener(this.messageNodeListener);
        if (!this.messageNode.hasMessageContent()) {
            this.throbberField = new ThrobberField(this.getWidth() / 4, 0x300000000L);
            this.add(this.throbberField);
            this.messageNode.refreshMessage();
        } else if (!this.messageRendered) {
            this.renderMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUndisplay() {
        this.messageNode.removeMessageNodeListener(this.messageNodeListener);
        Object object = Application.getEventLock();
        synchronized (object) {
            if (this.throbberField != null) {
                this.delete(this.throbberField);
                this.throbberField = null;
            }
        }
        super.onUndisplay();
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.add(this.propsItem);
        menu.addSeparator();
        if (this.accountConfig != null && this.accountConfig.getOutgoingConfig() != null) {
            menu.add(this.replyItem);
            if (this.accountConfig.getIdentityConfig() != null) {
                menu.add(this.replyAllItem);
            }
            menu.add(this.forwardItem);
            menu.add(this.compositionItem);
        }
        menu.add(this.copyToItem);
        menu.add(this.moveToItem);
        menu.addSeparator();
        menu.add(this.closeItem);
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': 
            case ' ': {
                if (status == 0) {
                    this.scroll(512);
                    retval = true;
                    break;
                }
                if (status != 1) break;
                this.scroll(256);
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageNode_MessageStatusChanged(MessageNodeEvent e) {
        if (e.getType() == 1) {
            Object object = Application.getEventLock();
            synchronized (object) {
                if (this.throbberField != null) {
                    this.delete(this.throbberField);
                    this.throbberField = null;
                }
            }
            this.renderMessage();
        }
    }

    private void renderMessage() {
        MessagePart[] displayableParts = MessagePartTransformer.getDisplayableParts(this.messageNode.getMessageStructure());
        Vector<Object> messageFields = new Vector<Object>();
        for (int i = 0; i < displayableParts.length; ++i) {
            MessageContent content = this.messageNode.getMessageContent(displayableParts[i]);
            if (content == null) continue;
            Field field = MessageFieldFactory.createMessageField(content);
            messageFields.addElement(field);
        }
        if (messageFields.size() == 0) {
            messageFields.addElement(new RichTextField(BaseScreen.resources.getString(88)));
        }
        this.drawMessageFields(messageFields);
        this.messageRendered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMessageFields(Vector messageFields) {
        if (messageFields == null) {
            return;
        }
        Object object = Application.getEventLock();
        synchronized (object) {
            int size = messageFields.size();
            for (int i = 0; i < size; ++i) {
                if (messageFields.elementAt(i) != null) {
                    this.messageFieldManager.add((Field)messageFields.elementAt(i));
                }
                if (i == size - 1) continue;
                this.messageFieldManager.add((Field)new SeparatorField());
            }
            this.messageFieldManager.add((Field)new NullField(0x40000000000000L));
        }
    }
}

