/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.blackberry.api.homescreen.HomeScreen;
import net.rim.device.api.notification.NotificationsManager;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.HolsterListener;
import net.rim.device.api.system.RuntimeStore;
import org.logicprobe.LogicMail.AppInfo;
import org.logicprobe.LogicMail.LogicMailEventSource;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.AccountNodeEvent;
import org.logicprobe.LogicMail.model.AccountNodeListener;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailManagerEvent;
import org.logicprobe.LogicMail.model.MailManagerListener;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MailboxNodeEvent;
import org.logicprobe.LogicMail.model.MailboxNodeListener;
import org.logicprobe.LogicMail.model.MessageNode;

public class NotificationHandler {
    private static NotificationHandler instance = null;
    private Hashtable accountMap;
    private boolean isEnabled;
    private AccountNodeListener accountNodeListener = new AccountNodeListener(){

        public void accountStatusChanged(AccountNodeEvent e) {
            if (e.getType() == 1) {
                NotificationHandler.this.updateAccountMap((AccountNode)e.getSource());
            }
        }
    };
    private HolsterListener holsterListener = new HolsterListener(){

        public void inHolster() {
        }

        public void outOfHolster() {
        }
    };
    private MailboxNodeListener mailboxNodeListener = new MailboxNodeListener(){

        public void mailboxStatusChanged(MailboxNodeEvent e) {
            NotificationHandler.this.mailboxNodeListener_mailboxStatusChanged(e);
        }
    };

    private NotificationHandler() {
        this.accountMap = new Hashtable();
        Application.getApplication().addHolsterListener(this.holsterListener);
        MailManager.getInstance().addMailManagerListener(new MailManagerListener(){

            public void mailConfigurationChanged(MailManagerEvent e) {
                NotificationHandler.this.MailManager_mailConfigurationChanged(e);
            }
        });
        this.updateAccountSubscriptions();
    }

    public static synchronized NotificationHandler getInstance() {
        if (instance == null) {
            instance = new NotificationHandler();
        }
        return instance;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void shutdown() {
        this.cancelNotification();
        this.isEnabled = false;
        Application.getApplication().removeHolsterListener(this.holsterListener);
    }

    private void MailManager_mailConfigurationChanged(MailManagerEvent e) {
        this.updateAccountSubscriptions();
    }

    private void mailboxNodeListener_mailboxStatusChanged(MailboxNodeEvent e) {
        MailboxNode mailboxNode = (MailboxNode)e.getSource();
        if (e.getType() == 1) {
            if (this.isEnabled) {
                boolean raiseNotification = false;
                MessageNode[] messages = e.getAffectedMessages();
                for (int i = 0; i < messages.length; ++i) {
                    if ((messages[i].getFlags() & 0x20) == 0) continue;
                    raiseNotification = true;
                    break;
                }
                if (raiseNotification) {
                    this.notifyNewMessages(mailboxNode);
                }
            }
        } else if (e.getType() == 0) {
            if (mailboxNode.getUnseenMessageCount() > 0) {
                this.setAppIcon(true);
            } else {
                this.setAppIcon(false);
            }
        }
    }

    private void updateAccountSubscriptions() {
        AccountNode accountNode;
        Hashtable<Long, LogicMailEventSource> eventSourceMap = (Hashtable<Long, LogicMailEventSource>)RuntimeStore.getRuntimeStore().get(7765914274915215232L);
        if (eventSourceMap == null) {
            eventSourceMap = new Hashtable<Long, LogicMailEventSource>();
            RuntimeStore.getRuntimeStore().put(7765914274915215232L, eventSourceMap);
        }
        AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
        for (int i = 0; i < accountNodes.length; ++i) {
            if (accountNodes[i].getStatus() == 0) continue;
            this.updateAccountMap(accountNodes[i]);
            accountNodes[i].addAccountNodeListener(this.accountNodeListener);
            AccountConfig accountConfig = accountNodes[i].getAccountConfig();
            LogicMailEventSource eventSource = (LogicMailEventSource)eventSourceMap.get(new Long(accountConfig.getUniqueId()));
            if (eventSource != null && eventSource.getAccountName().equals(accountConfig.getAcctName())) continue;
            eventSource = new LogicMailEventSource(accountConfig.getAcctName(), accountConfig.getUniqueId());
            NotificationsManager.registerSource((long)eventSource.getEventSourceId(), (Object)eventSource, (int)3);
            eventSourceMap.put(new Long(accountConfig.getUniqueId()), eventSource);
        }
        Vector<AccountNode> deletedAccounts = new Vector<AccountNode>();
        Enumeration<Object> e = this.accountMap.keys();
        while (e.hasMoreElements()) {
            accountNode = (AccountNode)e.nextElement();
            boolean accountDeleted = true;
            for (int i = 0; i < accountNodes.length; ++i) {
                if (accountNodes[i] != accountNode) continue;
                accountDeleted = false;
                break;
            }
            if (!accountDeleted) continue;
            deletedAccounts.addElement(accountNode);
        }
        e = deletedAccounts.elements();
        while (e.hasMoreElements()) {
            accountNode = (AccountNode)e.nextElement();
            ((MailboxNode)this.accountMap.get(accountNode)).removeMailboxNodeListener(this.mailboxNodeListener);
            this.accountMap.remove(accountNode);
            accountNode.removeAccountNodeListener(this.accountNodeListener);
            Long eventSourceKey = new Long(accountNode.getAccountConfig().getUniqueId());
            LogicMailEventSource eventSource = (LogicMailEventSource)eventSourceMap.get(eventSourceKey);
            if (eventSource == null) continue;
            NotificationsManager.deregisterSource((long)eventSource.getEventSourceId());
            eventSourceMap.remove(eventSourceKey);
        }
    }

    private void updateAccountMap(AccountNode accountNode) {
        MailboxNode rootMailbox = accountNode.getRootMailbox();
        if (rootMailbox != null) {
            MailboxNode[] mailboxNodes = rootMailbox.getMailboxes();
            MailboxNode inboxNode = null;
            for (int j = 0; j < mailboxNodes.length; ++j) {
                if (!mailboxNodes[j].toString().equalsIgnoreCase("INBOX")) continue;
                inboxNode = mailboxNodes[j];
                break;
            }
            if (inboxNode != null) {
                if (this.accountMap.containsKey(accountNode) && this.accountMap.get(accountNode) != inboxNode) {
                    ((MailboxNode)this.accountMap.get(accountNode)).removeMailboxNodeListener(this.mailboxNodeListener);
                } else if (!this.accountMap.containsKey(accountNode)) {
                    inboxNode.addMailboxNodeListener(this.mailboxNodeListener);
                    this.accountMap.put(accountNode, inboxNode);
                }
            }
        }
    }

    private void notifyNewMessages(MailboxNode mailboxNode) {
        long sourceId = 7765914274915215232L + mailboxNode.getParentAccount().getAccountConfig().getUniqueId();
        NotificationsManager.triggerImmediateEvent((long)sourceId, (long)0L, (Object)this, null);
        this.setAppIcon(true);
    }

    public void cancelNotification() {
        Enumeration e = this.accountMap.keys();
        while (e.hasMoreElements()) {
            AccountNode accountNode = (AccountNode)e.nextElement();
            long sourceId = 7765914274915215232L + accountNode.getAccountConfig().getUniqueId();
            NotificationsManager.cancelImmediateEvent((long)sourceId, (long)0L, (Object)this, null);
        }
        this.setAppIcon(false);
    }

    private void setAppIcon(boolean newMessages) {
        if (newMessages) {
            HomeScreen.updateIcon((Bitmap)AppInfo.getNewMessagesIcon());
            HomeScreen.setRolloverIcon((Bitmap)AppInfo.getNewMessagesRolloverIcon());
        } else {
            HomeScreen.updateIcon((Bitmap)AppInfo.getIcon());
            HomeScreen.setRolloverIcon((Bitmap)AppInfo.getRolloverIcon());
        }
    }
}

