/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Hashtable;
import net.rim.device.api.io.SharedInputStream;
import net.rim.device.api.mime.MIMEInputStream;
import net.rim.device.api.mime.MIMEParsingException;
import org.logicprobe.LogicMail.AppInfo;
import org.logicprobe.LogicMail.message.MessageContentFactory;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartFactory;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.UnsupportedContentException;
import org.logicprobe.LogicMail.util.StringParser;

public class MailMessageParser {
    private static String strCRLF = "\r\n";

    private MailMessageParser() {
    }

    public static MessageEnvelope parseMessageEnvelope(String[] rawHeaders) {
        Hashtable headers = StringParser.parseMailHeaders(rawHeaders);
        MessageEnvelope env = new MessageEnvelope();
        env.subject = StringParser.parseEncodedHeader((String)headers.get("subject"));
        if (env.subject == null) {
            env.subject = "";
        }
        env.from = MailMessageParser.parseAddressList((String)headers.get("from"));
        env.sender = MailMessageParser.parseAddressList((String)headers.get("sender"));
        env.to = MailMessageParser.parseAddressList((String)headers.get("to"));
        env.cc = MailMessageParser.parseAddressList((String)headers.get("cc"));
        env.bcc = MailMessageParser.parseAddressList((String)headers.get("bcc"));
        try {
            env.date = StringParser.parseDateString((String)headers.get("date"));
        }
        catch (Exception e) {
            env.date = Calendar.getInstance().getTime();
        }
        env.replyTo = MailMessageParser.parseAddressList((String)headers.get("reply-to"));
        env.messageId = (String)headers.get("message-id");
        env.inReplyTo = (String)headers.get("in-reply-to");
        return env;
    }

    public static String generateMessageHeaders(MessageEnvelope envelope, boolean includeUserAgent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("From: ");
        buffer.append(StringParser.makeCsvString(envelope.from));
        buffer.append(strCRLF);
        buffer.append("To: ");
        buffer.append(StringParser.makeCsvString(envelope.to));
        buffer.append(strCRLF);
        if (envelope.cc != null && envelope.cc.length > 0) {
            buffer.append("Cc: ");
            buffer.append(StringParser.makeCsvString(envelope.cc));
            buffer.append(strCRLF);
        }
        if (envelope.replyTo != null && envelope.replyTo.length > 0) {
            buffer.append("Reply-To: ");
            buffer.append(StringParser.makeCsvString(envelope.replyTo));
            buffer.append(strCRLF);
        }
        buffer.append("Date: ");
        buffer.append(StringParser.createDateString(envelope.date));
        buffer.append(strCRLF);
        if (includeUserAgent) {
            buffer.append("User-Agent: ");
            buffer.append(AppInfo.getName());
            buffer.append('/');
            buffer.append(AppInfo.getVersion());
            buffer.append(strCRLF);
        }
        buffer.append("Subject: ");
        buffer.append(envelope.subject);
        buffer.append(strCRLF);
        if (envelope.inReplyTo != null) {
            buffer.append("In-Reply-To: ");
            buffer.append(envelope.inReplyTo);
            buffer.append(strCRLF);
        }
        return buffer.toString();
    }

    private static String[] parseAddressList(String text) {
        String[] addresses = StringParser.parseCsvString(text);
        for (int i = 0; i < addresses.length; ++i) {
            int p;
            addresses[i] = StringParser.parseEncodedHeader(addresses[i]);
            if (addresses[i].length() <= 0 || addresses[i].charAt(0) != '\"') continue;
            for (p = addresses[i].indexOf(60); p > 0 && addresses[i].charAt(p) != '\"'; --p) {
            }
            if (p <= 0 || p + 1 >= addresses[i].length()) continue;
            addresses[i] = addresses[i].substring(1, p) + addresses[i].substring(p + 1);
        }
        return addresses;
    }

    public static MessagePart parseRawMessage(Hashtable contentMap, InputStream inputStream) throws IOException {
        MIMEInputStream mimeInputStream = null;
        try {
            mimeInputStream = new MIMEInputStream(inputStream);
        }
        catch (MIMEParsingException e) {
            return null;
        }
        MessagePart rootPart = MailMessageParser.getMessagePart(contentMap, mimeInputStream);
        return rootPart;
    }

    private static MessagePart getMessagePart(Hashtable contentMap, MIMEInputStream mimeInputStream) throws IOException {
        String mimeType = mimeInputStream.getContentType();
        String type = mimeType.substring(0, mimeType.indexOf(47));
        String subtype = mimeType.substring(mimeType.indexOf(47) + 1);
        String encoding = mimeInputStream.getHeader("Content-Transfer-Encoding");
        String charset = mimeInputStream.getContentTypeParameter("charset");
        if (encoding == null) {
            encoding = "7bit";
        }
        if (mimeInputStream.isMultiPart() && type.equalsIgnoreCase("multipart")) {
            MessagePart part = MessagePartFactory.createMessagePart(type, subtype, null, null, -1);
            MIMEInputStream[] mimeSubparts = mimeInputStream.getParts();
            for (int i = 0; i < mimeSubparts.length; ++i) {
                MessagePart subPart = MailMessageParser.getMessagePart(contentMap, mimeSubparts[i]);
                if (subPart == null) continue;
                ((MultiPart)part).addPart(subPart);
            }
            return part;
        }
        if (encoding.equalsIgnoreCase("base64") && mimeInputStream.isPartComplete() != 0) {
            SharedInputStream sis = mimeInputStream.getRawMIMEInputStream();
            byte[] buffer = StringParser.readWholeStream((InputStream)sis);
            int offset = 0;
            while (offset + 3 < buffer.length && (buffer[offset] != 13 || buffer[offset + 1] != 10 || buffer[offset + 2] != 13 || buffer[offset + 3] != 10)) {
                ++offset;
            }
            int size = buffer.length - offset;
            String data = new String(buffer, offset, size);
            MessagePart part = MessagePartFactory.createMessagePart(type, subtype, encoding, charset, size);
            try {
                contentMap.put(part, MessageContentFactory.createContent(part, encoding, charset, data));
            }
            catch (UnsupportedContentException e) {
                System.err.println("UnsupportedContentException: " + e.getMessage());
            }
            return part;
        }
        byte[] buffer = StringParser.readWholeStream((InputStream)mimeInputStream);
        String data = new String(buffer);
        MessagePart part = MessagePartFactory.createMessagePart(type, subtype, encoding, charset, data.length());
        try {
            contentMap.put(part, MessageContentFactory.createContent(part, encoding, charset, data));
        }
        catch (UnsupportedContentException e) {
            System.err.println("UnsupportedContentException: " + e.getMessage());
        }
        return part;
    }
}

