/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.logicprobe.LogicMail.util.Serializable;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] serializeClass(Serializable input) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        try {
            output.writeUTF(input.getClass().getName());
            input.serialize(output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toByteArray();
    }

    public static void serializeClass(Serializable input, DataOutputStream output) throws IOException {
        byte[] classBytes = SerializationUtils.serializeClass(input);
        output.writeInt(classBytes.length);
        ((OutputStream)output).write(classBytes);
    }

    public static Serializable deserializeClass(byte[] data) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        Serializable result = null;
        try {
            String classType = input.readUTF();
            Object deserializedObject = Class.forName(classType).newInstance();
            if (deserializedObject instanceof Serializable) {
                result = (Serializable)deserializedObject;
                result.deserialize(input);
            }
        }
        catch (IOException ex) {
            result = null;
        }
        catch (ClassNotFoundException ex) {
            result = null;
        }
        catch (InstantiationException ex) {
            result = null;
        }
        catch (IllegalAccessException ex) {
            result = null;
        }
        return result;
    }

    public static Serializable deserializeClass(DataInputStream input) throws IOException {
        int classLength = input.readInt();
        byte[] classBytes = new byte[classLength];
        input.read(classBytes);
        Serializable result = SerializationUtils.deserializeClass(classBytes);
        return result;
    }
}

