/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import net.rim.device.api.io.Base64InputStream;
import net.rim.device.api.util.Arrays;
import net.rim.device.api.util.DateTimeUtilities;
import net.rim.device.api.util.NumberUtilities;

public class StringParser {
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;

    private StringParser() {
    }

    public static Date parseDateString(String rawDate) {
        String tz;
        int p = 0;
        int q = 0;
        int[] fields = new int[7];
        p = rawDate.indexOf(",");
        if (p != -1) {
            ++p;
            while (rawDate.charAt(p) == ' ') {
                ++p;
            }
            rawDate = rawDate.substring(p);
        }
        if (rawDate.charAt(rawDate.length() - 1) == ')') {
            rawDate = rawDate.substring(0, rawDate.lastIndexOf(32));
        }
        Calendar cal = (p = (tz = rawDate.substring(rawDate.lastIndexOf(32) + 1)).indexOf(58)) == -1 || tz.indexOf(58, p) == -1 ? Calendar.getInstance(StringParser.createTimeZone(tz)) : Calendar.getInstance(TimeZone.getDefault());
        p = 0;
        q = rawDate.indexOf(" ", p + 1);
        fields[2] = Integer.parseInt(rawDate.substring(p, q).trim());
        p = q + 1;
        String monthStr = rawDate.substring(p, q = rawDate.indexOf(" ", p + 1));
        if (monthStr.equals("Jan")) {
            fields[1] = 0;
        } else if (monthStr.equals("Feb")) {
            fields[1] = 1;
        } else if (monthStr.equals("Mar")) {
            fields[1] = 2;
        } else if (monthStr.equals("Apr")) {
            fields[1] = 3;
        } else if (monthStr.equals("May")) {
            fields[1] = 4;
        } else if (monthStr.equals("Jun")) {
            fields[1] = 5;
        } else if (monthStr.equals("Jul")) {
            fields[1] = 6;
        } else if (monthStr.equals("Aug")) {
            fields[1] = 7;
        } else if (monthStr.equals("Sep")) {
            fields[1] = 8;
        } else if (monthStr.equals("Oct")) {
            fields[1] = 9;
        } else if (monthStr.equals("Nov")) {
            fields[1] = 10;
        } else if (monthStr.equals("Dec")) {
            fields[1] = 11;
        }
        p = q + 1;
        q = rawDate.indexOf(" ", p + 1);
        fields[0] = Integer.parseInt(rawDate.substring(p, q).trim());
        if (fields[0] < 100) {
            fields[0] = fields[0] >= 50 ? fields[0] + 1900 : fields[0] + 2000;
        } else if (fields[0] >= 100 && fields[0] < 1000) {
            fields[0] = fields[0] + 2000;
        }
        p = q + 1;
        q = rawDate.indexOf(":", p + 1);
        fields[3] = Integer.parseInt(rawDate.substring(p, q).trim());
        p = q + 1;
        q = rawDate.indexOf(":", p + 1);
        if (q == -1) {
            q = rawDate.indexOf(" ", p + 1);
            fields[4] = Integer.parseInt(rawDate.substring(p, q).trim());
            fields[5] = 0;
            fields[6] = 0;
        } else {
            fields[4] = Integer.parseInt(rawDate.substring(p, q).trim());
            p = q + 1;
            if ((q = rawDate.indexOf(" ", p + 1)) == -1) {
                q = rawDate.length();
            }
            fields[5] = Integer.parseInt(rawDate.substring(p, q).trim());
            fields[6] = 0;
        }
        DateTimeUtilities.setCalendarFields((Calendar)cal, (int[])fields);
        return cal.getTime();
    }

    private static TimeZone createTimeZone(String tz) {
        TimeZone result = tz.startsWith("-") || tz.startsWith("+") ? TimeZone.getTimeZone("GMT" + tz) : (tz.indexOf(47) != -1 ? TimeZone.getTimeZone(tz) : (tz.equals("MIT") ? TimeZone.getTimeZone("GMT-11:00") : (tz.equals("HST") ? TimeZone.getTimeZone("GMT-10:00") : (tz.equals("AST") ? TimeZone.getTimeZone("GMT-9:00") : (tz.equals("PST") ? TimeZone.getTimeZone("GMT-8:00") : (tz.equals("PDT") ? TimeZone.getTimeZone("GMT-7:00") : (tz.equals("PST8PDT") ? TimeZone.getTimeZone("GMT-8:00") : (tz.equals("MST") ? TimeZone.getTimeZone("GMT-7:00") : (tz.equals("MDT") ? TimeZone.getTimeZone("GMT-6:00") : (tz.equals("MST7MDT") ? TimeZone.getTimeZone("GMT-7:00") : (tz.equals("PNT") ? TimeZone.getTimeZone("GMT-7:00") : (tz.equals("CST") ? TimeZone.getTimeZone("GMT-6:00") : (tz.equals("CDT") ? TimeZone.getTimeZone("GMT-5:00") : (tz.equals("CST6CDT") ? TimeZone.getTimeZone("GMT-6:00") : (tz.equals("EST") ? TimeZone.getTimeZone("GMT-5:00") : (tz.equals("EDT") ? TimeZone.getTimeZone("GMT-4:00") : (tz.equals("EST5EDT") ? TimeZone.getTimeZone("GMT-5:00") : (tz.equals("IET") ? TimeZone.getTimeZone("GMT-5:00") : (tz.equals("PRT") ? TimeZone.getTimeZone("GMT-4:00") : (tz.equals("CNT") ? TimeZone.getTimeZone("GMT-3:5") : (tz.equals("AGT") ? TimeZone.getTimeZone("GMT-3:00") : (tz.equals("BET") ? TimeZone.getTimeZone("GMT-3:00") : (tz.equals("UCT") ? TimeZone.getTimeZone("GMT") : (tz.equals("UTC") ? TimeZone.getTimeZone("GMT") : (tz.equals("WET") ? TimeZone.getTimeZone("GMT") : (tz.equals("CET") ? TimeZone.getTimeZone("GMT+1:00") : (tz.equals("ECT") ? TimeZone.getTimeZone("GMT+1:00") : (tz.equals("MET") ? TimeZone.getTimeZone("GMT+1:00") : (tz.equals("ART") ? TimeZone.getTimeZone("GMT+2:00") : (tz.equals("CAT") ? TimeZone.getTimeZone("GMT+2:00") : (tz.equals("EET") ? TimeZone.getTimeZone("GMT+2:00") : (tz.equals("EAT") ? TimeZone.getTimeZone("GMT+3:00") : (tz.equals("NET") ? TimeZone.getTimeZone("GMT+4:00") : (tz.equals("PLT") ? TimeZone.getTimeZone("GMT+5:00") : (tz.equals("IST") ? TimeZone.getTimeZone("GMT+5:30") : (tz.equals("BST") ? TimeZone.getTimeZone("GMT+6:00") : (tz.equals("VST") ? TimeZone.getTimeZone("GMT+7:00") : (tz.equals("CTT") ? TimeZone.getTimeZone("GMT+8:00") : (tz.equals("PRC") ? TimeZone.getTimeZone("GMT+8:00") : (tz.equals("JST") ? TimeZone.getTimeZone("GMT+9:00") : (tz.equals("ROK") ? TimeZone.getTimeZone("GMT+9:00") : (tz.equals("ACT") ? TimeZone.getTimeZone("GMT+9:30") : (tz.equals("AET") ? TimeZone.getTimeZone("GMT+10:00") : (tz.equals("SST") ? TimeZone.getTimeZone("GMT+11:00") : (tz.equals("NST") ? TimeZone.getTimeZone("GMT+12:00") : TimeZone.getTimeZone(tz))))))))))))))))))))))))))))))))))))))))))))));
        return result;
    }

    public static String createDateString(Date time) {
        return StringParser.createDateString(time, TimeZone.getDefault());
    }

    public static String createDateString(Date time, TimeZone zone) {
        Calendar cal = Calendar.getInstance(zone);
        cal.setTime(time);
        StringBuffer buf = new StringBuffer();
        switch (cal.get(7)) {
            case 1: {
                buf.append("Sun, ");
                break;
            }
            case 2: {
                buf.append("Mon, ");
                break;
            }
            case 3: {
                buf.append("Tue, ");
                break;
            }
            case 4: {
                buf.append("Wed, ");
                break;
            }
            case 5: {
                buf.append("Thu, ");
                break;
            }
            case 6: {
                buf.append("Fri, ");
                break;
            }
            case 7: {
                buf.append("Sat, ");
            }
        }
        buf.append(cal.get(5));
        buf.append(' ');
        switch (cal.get(2)) {
            case 0: {
                buf.append("Jan ");
                break;
            }
            case 1: {
                buf.append("Feb ");
                break;
            }
            case 2: {
                buf.append("Mar ");
                break;
            }
            case 3: {
                buf.append("Apr ");
                break;
            }
            case 4: {
                buf.append("May ");
                break;
            }
            case 5: {
                buf.append("Jun ");
                break;
            }
            case 6: {
                buf.append("Jul ");
                break;
            }
            case 7: {
                buf.append("Aug ");
                break;
            }
            case 8: {
                buf.append("Sep ");
                break;
            }
            case 9: {
                buf.append("Oct ");
                break;
            }
            case 10: {
                buf.append("Nov ");
                break;
            }
            case 11: {
                buf.append("Dec ");
            }
        }
        buf.append(cal.get(1));
        buf.append(' ');
        buf.append(NumberUtilities.toString((int)cal.get(11), (int)10, (int)2));
        buf.append(':');
        buf.append(NumberUtilities.toString((int)cal.get(12), (int)10, (int)2));
        buf.append(':');
        buf.append(NumberUtilities.toString((int)cal.get(13), (int)10, (int)2));
        buf.append(' ');
        int tzOffset = cal.getTimeZone().getOffset(1, cal.get(1), cal.get(2), cal.get(5), cal.get(7), (int)((long)cal.get(11) * 3600000L + (long)cal.get(12) * 60000L + (long)cal.get(13) * 1000L)) / 36000;
        if (tzOffset < 0) {
            buf.append(NumberUtilities.toString((int)tzOffset, (int)10, (int)5));
        } else {
            buf.append("+");
            buf.append(NumberUtilities.toString((int)tzOffset, (int)10, (int)4));
        }
        return buf.toString();
    }

    public static Vector nestedParenStringLexer(String rawText) {
        int p;
        Vector<Object> parsedText = new Vector<Object>();
        if (rawText.charAt(0) != '(' || rawText.charAt(rawText.length() - 1) != ')') {
            return null;
        }
        boolean inQuote = false;
        for (int q = p = 1; q < rawText.length(); ++q) {
            if (StringParser.isQuoteChar(rawText, q, p)) {
                if (!inQuote) {
                    inQuote = true;
                    p = q;
                    continue;
                }
                parsedText.addElement(rawText.substring(p + 1, q));
                p = q + 1;
                inQuote = false;
                continue;
            }
            if (rawText.charAt(q) == '{' && !inQuote) {
                p = rawText.indexOf(125, q);
                int len = Integer.parseInt(rawText.substring(q + 1, p));
                ++p;
                while (rawText.charAt(p) == '\r' || rawText.charAt(p) == '\n') {
                    ++p;
                }
                String tmpText = rawText.substring(p, p + len);
                if (tmpText.endsWith(" NIL")) {
                    len -= 4;
                } else if (tmpText.endsWith(" NI")) {
                    len -= 3;
                } else if (tmpText.endsWith(" N")) {
                    len -= 2;
                } else if (tmpText.endsWith(" ")) {
                    --len;
                }
                parsedText.addElement(rawText.substring(p, p + len));
                q = p + len;
                continue;
            }
            if (rawText.charAt(q) == ' ' && !inQuote || q == rawText.length() - 1) {
                if (q - p > 0) {
                    parsedText.addElement(rawText.substring(p, q).trim());
                    p = q;
                    continue;
                }
                ++p;
                continue;
            }
            if (rawText.charAt(q) != '(' || inQuote) continue;
            p = q;
            int level = 0;
            boolean subInQuote = false;
            for (int i = q + 1; i < rawText.length(); ++i) {
                int matchIndex;
                if (rawText.charAt(i) == '{' && !subInQuote && (matchIndex = rawText.indexOf(125, i)) > i + 1 && rawText.charAt(matchIndex + 1) != ' ') {
                    int matchLen = Integer.parseInt(rawText.substring(i + 1, matchIndex));
                    ++matchIndex;
                    while (rawText.charAt(matchIndex) == '\r' || rawText.charAt(matchIndex) == '\n') {
                        ++matchIndex;
                    }
                    i = matchIndex + matchLen;
                }
                if (StringParser.isQuoteChar(rawText, i, q + 1) && !subInQuote) {
                    subInQuote = true;
                } else if (StringParser.isQuoteChar(rawText, i, q + 1) && subInQuote) {
                    subInQuote = false;
                }
                if (rawText.charAt(i) == '(' && !subInQuote) {
                    ++level;
                    continue;
                }
                if (rawText.charAt(i) != ')' || subInQuote) continue;
                if (level == 0) {
                    q = i;
                    break;
                }
                --level;
            }
            if (q == 1 || q < p) {
                return null;
            }
            parsedText.addElement(StringParser.nestedParenStringLexer(rawText.substring(p, q + 1)));
            p = q + 1;
        }
        return parsedText;
    }

    private static boolean isQuoteChar(String rawText, int index, int startIndex) {
        if (index == startIndex) {
            return rawText.charAt(index) == '\"';
        }
        if (rawText.charAt(index) == '\"') {
            if (rawText.charAt(index - 1) == '\\') {
                return index - 2 < startIndex || rawText.charAt(index - 2) == '\\';
            }
            return true;
        }
        return false;
    }

    public static Hashtable parseMailHeaders(String[] rawLines) {
        String line = "";
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < rawLines.length; ++i) {
            if (rawLines[i].startsWith(" ") || rawLines[i].startsWith("\t")) {
                line = line + "\r\n" + rawLines[i];
            } else {
                if (line.length() != 0) {
                    table.put(line.substring(0, line.indexOf(58)).toLowerCase(), line.substring(line.indexOf(32) + 1));
                }
                line = rawLines[i];
            }
            if (i != rawLines.length - 1 || line.length() == 0) continue;
            table.put(line.substring(0, line.indexOf(58)).toLowerCase(), line.substring(line.indexOf(32) + 1));
        }
        return table;
    }

    public static String parseEncodedHeader(String text) {
        int index;
        if (text == null) {
            return null;
        }
        int size = text.length();
        if (size < 8) {
            return text;
        }
        StringBuffer buf = new StringBuffer();
        boolean flag = false;
        for (index = 0; index < size - 1; ++index) {
            flag = false;
            int qcount = 0;
            if (text.charAt(index) == '=' && text.charAt(index + 1) == '?' && index + 2 < size) {
                ++qcount;
                for (int i = index + 2; i < size - 1; ++i) {
                    if (text.charAt(i) == '?') {
                        ++qcount;
                    }
                    if (qcount != 4 || text.charAt(i) != '?' || text.charAt(i + 1) != '=') continue;
                    buf.append(StringParser.parseEncodedWord(text.substring(index, i + 2)));
                    index = i + 1;
                    flag = true;
                    break;
                }
            }
            if (flag) continue;
            buf.append(text.charAt(index));
        }
        if (!flag) {
            buf.append(text.charAt(index));
        }
        return buf.toString();
    }

    private static String parseEncodedWord(String text) {
        String result;
        String[] sections = StringParser.parseTokenString(text, "?");
        if (sections.length != 5) {
            return "";
        }
        String charset = sections[1].toUpperCase();
        String encoding = sections[2].toUpperCase();
        String encodedText = sections[3];
        if (encoding.length() != 1) {
            return "";
        }
        if (encoding.charAt(0) == 'Q') {
            try {
                result = new String(StringParser.decodeQuotedPrintable(encodedText).getBytes(), charset);
            }
            catch (UnsupportedEncodingException ex) {
                result = "";
            }
        } else if (encoding.charAt(0) == 'B') {
            try {
                result = new String(Base64InputStream.decode((String)encodedText), charset);
            }
            catch (IOException e) {
                result = "";
            }
        } else {
            result = "";
        }
        return result;
    }

    public static String[] parseTokenString(String text, String token) {
        Object[] tok = new String[]{};
        if (text == null) {
            return tok;
        }
        int p = 0;
        int q = 0;
        while (q < text.length()) {
            q = text.indexOf(token, p + 1);
            if (q == -1) {
                Arrays.add((Object[])tok, (Object)text.substring(p));
                break;
            }
            Arrays.add((Object[])tok, (Object)text.substring(p, q));
            p = q + token.length();
        }
        return tok;
    }

    public static String[] parseCsvString(String text) {
        int q;
        Object[] tok = new String[]{};
        if (text == null) {
            return tok;
        }
        int p = 0;
        boolean inQuote = false;
        for (q = 0; q < text.length(); ++q) {
            if (text.charAt(q) == '\"' && (q == 0 || q > 0 && text.charAt(q - 1) != '\\')) {
                boolean bl = inQuote = !inQuote;
            }
            if (text.charAt(q) != ',' || inQuote) continue;
            Arrays.add((Object[])tok, (Object)text.substring(p, q).trim());
            p = q + 1;
            ++q;
        }
        if (p + 1 < q) {
            Arrays.add((Object[])tok, (Object)text.substring(p, q).trim());
        }
        return tok;
    }

    public static String makeCsvString(String[] input) {
        if (input == null || input.length == 0) {
            return "";
        }
        if (input.length == 1) {
            return input[0];
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length - 1; ++i) {
            buffer.append(input[i]);
            buffer.append(", ");
        }
        buffer.append(input[input.length - 1]);
        return buffer.toString();
    }

    public static String makeCsvString(Object[] input) {
        if (input == null || input.length == 0) {
            return "";
        }
        if (input.length == 1) {
            return input[0].toString();
        }
        String[] stringArray = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            stringArray[i] = input[i].toString();
        }
        return StringParser.makeCsvString(stringArray);
    }

    public static String parseValidCharsetString(String encoding) {
        if (encoding == null) {
            return "ISO-8859-1";
        }
        if (encoding.toUpperCase().indexOf("ISO-8859-1") != -1) {
            return "ISO-8859-1";
        }
        if (encoding.toUpperCase().indexOf("UTF-8") != -1) {
            return "UTF-8";
        }
        if (encoding.toUpperCase().indexOf("UTF-16BE") != -1) {
            return "UTF-16BE";
        }
        if (encoding.toUpperCase().indexOf("US-ASCII") != -1) {
            return "US-ASCII";
        }
        return "ISO-8859-1";
    }

    public static InputStream createInputStream(String[] rawLines) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < rawLines.length; ++i) {
            buf.append(rawLines[i] + "\r\n");
        }
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    public static byte[] readWholeStream(InputStream is) throws IOException {
        byte[] tmpBuf;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (is.available() > 0 && is.read(tmpBuf = new byte[is.available()]) >= 0) {
            bos.write(tmpBuf);
        }
        return bos.toByteArray();
    }

    public static String decodeQuotedPrintable(String text) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int length = text.length();
        while (index < length) {
            if (text.charAt(index) == '=') {
                if (index + 2 >= length) break;
                char ch1 = text.charAt(index + 1);
                char ch2 = text.charAt(index + 2);
                if (ch1 == '\r' && ch2 == '\n') {
                    index += 3;
                    continue;
                }
                if (ch1 == '\n') {
                    index += 2;
                    continue;
                }
                try {
                    int charVal = Integer.parseInt(text.substring(index + 1, index + 3), 16);
                    buffer.append((char)charVal);
                }
                catch (NumberFormatException exp) {
                    // empty catch block
                }
                index += 3;
                continue;
            }
            buffer.append(text.charAt(index));
            ++index;
        }
        return buffer.toString();
    }

    public static String encodeQuotedPrintable(String text) {
        StringBuffer buffer = new StringBuffer();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch != '\t' && ch != ' ' && ch < '\u0080') {
                if (buffer.length() == 75 && i < length - 1) {
                    buffer.append("=\r\n");
                }
                buffer.append(ch);
                continue;
            }
            if (buffer.length() == 73 && i < length - 3) {
                buffer.append("=\r\n");
            }
            String charStr = Integer.toHexString(ch).toUpperCase();
            buffer.append('=');
            if (charStr.length() == 1) {
                buffer.append('0');
            }
            buffer.append(charStr);
        }
        return buffer.toString();
    }

    public static String removeEscapedChars(String text) {
        int size = text.length();
        if (size < 2) {
            return text;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < size) {
            char ch = text.charAt(i);
            if (i < size - 1 && ch == '\\') {
                char nextCh = text.charAt(i + 1);
                if (nextCh == '\\' || nextCh == '\"') {
                    buf.append(nextCh);
                    i += 2;
                    continue;
                }
                buf.append(ch);
                ++i;
                continue;
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public static String addEscapedChars(String text) {
        StringBuffer buf = new StringBuffer();
        int size = text.length();
        for (int i = 0; i < size; ++i) {
            char ch = text.charAt(i);
            if (ch == '\\' || ch == '\"') {
                buf.append('\\');
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String[] parseRecipient(String recipient) {
        String[] result = new String[2];
        String text = recipient.trim();
        int p = text.indexOf(60);
        int q = text.indexOf(62);
        result[1] = p == -1 && q == -1 ? text : (p != -1 && q != -1 && p < q && text.length() > 2 ? text.substring(p + 1, q) : (p != -1 && q == -1 && text.length() > 1 ? text.substring(p + 1) : ""));
        if (result[1].length() == 0) {
            return result;
        }
        if (p != -1 && p > 0) {
            result[0] = text.substring(0, p).trim();
            int length = result[0].length();
            if (length >= 2 && result[0].charAt(0) == '\"' && result[0].charAt(length - 1) == '\"') {
                result[0] = result[0].substring(1, length - 1);
            }
        } else {
            result[0] = null;
        }
        return result;
    }

    public static String mergeRecipient(String name, String address) {
        String result;
        if (address == null || address.length() == 0) {
            result = "";
        } else if (name != null && name.length() > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            buf.append(name);
            buf.append("\" <");
            buf.append(address);
            buf.append('>');
            result = buf.toString();
        } else {
            result = address;
        }
        return result;
    }

    public static String[] toStringArray(Object[] input) {
        String[] result;
        if (input == null) {
            result = null;
        } else if (input.length == 0) {
            result = new String[]{};
        } else {
            result = new String[input.length];
            for (int i = 0; i < input.length; ++i) {
                result[i] = input[i] != null ? input[i].toString() : null;
            }
        }
        return result;
    }
}

