/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializableHashtable;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public abstract class ConnectionConfig
implements Serializable {
    private long uniqueId;
    private String acctName;
    private String serverName;
    private boolean serverSSL;
    private int serverPort;
    private boolean deviceSide;

    public ConnectionConfig() {
        this.setDefaults();
    }

    public ConnectionConfig(DataInputStream input) {
        try {
            this.deserialize(input);
        }
        catch (IOException ex) {
            this.setDefaults();
        }
    }

    protected void setDefaults() {
        this.uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
        this.acctName = "";
        this.serverName = "";
        this.serverSSL = false;
        this.serverPort = 110;
        this.deviceSide = false;
    }

    public String getAcctName() {
        return this.acctName;
    }

    public void setAcctName(String acctName) {
        this.acctName = acctName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean getServerSSL() {
        return this.serverSSL;
    }

    public void setServerSSL(boolean serverSSL) {
        this.serverSSL = serverSSL;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public boolean getDeviceSide() {
        return this.deviceSide;
    }

    public void setDeviceSide(boolean deviceSide) {
        this.deviceSide = deviceSide;
    }

    public final void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        SerializableHashtable table = new SerializableHashtable();
        this.writeConfigItems(table);
        table.serialize(output);
    }

    public final void deserialize(DataInputStream input) throws IOException {
        this.setDefaults();
        this.uniqueId = input.readLong();
        SerializableHashtable table = new SerializableHashtable();
        table.deserialize(input);
        this.readConfigItems(table);
    }

    protected void writeConfigItems(SerializableHashtable table) {
        table.put("account_acctName", this.acctName);
        table.put("account_serverName", this.serverName);
        table.put("account_serverSSL", new Boolean(this.serverSSL));
        table.put("account_serverPort", new Integer(this.serverPort));
        table.put("account_deviceSide", new Boolean(this.deviceSide));
    }

    protected void readConfigItems(SerializableHashtable table) {
        Object value = table.get("account_acctName");
        if (value != null && value instanceof String) {
            this.acctName = (String)value;
        }
        if ((value = table.get("account_serverName")) != null && value instanceof String) {
            this.serverName = (String)value;
        }
        if ((value = table.get("account_serverSSL")) != null && value instanceof Boolean) {
            this.serverSSL = (Boolean)value;
        }
        if ((value = table.get("account_serverPort")) != null && value instanceof Integer) {
            this.serverPort = (Integer)value;
        }
        if ((value = table.get("account_deviceSide")) != null && value instanceof Boolean) {
            this.deviceSide = (Boolean)value;
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }
}

