/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.rim.device.api.system.ApplicationDescriptor;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.DeviceInfo;
import net.rim.device.api.system.EventLogger;
import org.logicprobe.LogicMail.mail.LocalMessageToken;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.util.MailMessageParser;

public class MaildirFolder {
    private String folderPath;
    private String folderUrl;
    private boolean initialized;
    private FileConnection fileConnection;
    private Hashtable messageEnvelopeMap;
    private boolean messageEnvelopeMapDirty = true;
    private int nextIndex = 0;
    private static String EOF_MARKER = "----";

    public MaildirFolder(String folderPath, String folderUrl) {
        this.folderPath = folderPath;
        this.folderUrl = folderUrl;
        this.messageEnvelopeMap = new Hashtable();
    }

    public void open() throws IOException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("MaildirFolder.open()\r\nOpening: " + this.folderUrl).getBytes(), (int)5);
        }
        this.fileConnection = (FileConnection)Connector.open((String)(this.folderUrl + '/'));
        if (!this.fileConnection.exists()) {
            this.fileConnection.mkdir();
        }
        this.fileConnection.close();
        this.fileConnection = (FileConnection)Connector.open((String)(this.folderUrl + "/cur/"));
        if (!this.fileConnection.exists()) {
            this.fileConnection.mkdir();
        }
        if (!this.initialized) {
            FileConnection indexFileConnection = (FileConnection)Connector.open((String)(this.folderUrl + "/index.dat"));
            if (indexFileConnection.exists()) {
                DataInputStream inputStream = indexFileConnection.openDataInputStream();
                try {
                    String uniqueId;
                    while (!(uniqueId = inputStream.readUTF()).equals(EOF_MARKER)) {
                        MessageEnvelope envelope = new MessageEnvelope();
                        envelope.deserialize(inputStream);
                        this.messageEnvelopeMap.put(uniqueId, envelope);
                    }
                    this.messageEnvelopeMapDirty = false;
                }
                catch (IOException exp) {
                    this.messageEnvelopeMapDirty = true;
                }
            }
            this.initialized = true;
        }
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("MaildirFolder.open()\r\nOpened with " + this.messageEnvelopeMap.size() + " messages in index file").getBytes(), (int)5);
        }
    }

    public void close() throws IOException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"MaildirFolder.close()".getBytes(), (int)5);
        }
        if (this.fileConnection != null) {
            this.fileConnection.close();
            this.fileConnection = null;
        }
        if (this.messageEnvelopeMapDirty) {
            FileConnection indexFileConnection = (FileConnection)Connector.open((String)(this.folderUrl + "/index.dat"));
            if (indexFileConnection.exists()) {
                indexFileConnection.truncate(0L);
            } else {
                indexFileConnection.create();
            }
            DataOutputStream outputStream = indexFileConnection.openDataOutputStream();
            Enumeration e = this.messageEnvelopeMap.keys();
            while (e.hasMoreElements()) {
                String uniqueId = (String)e.nextElement();
                outputStream.writeUTF(uniqueId);
                MessageEnvelope envelope = (MessageEnvelope)this.messageEnvelopeMap.get(uniqueId);
                envelope.serialize(outputStream);
            }
            outputStream.writeUTF(EOF_MARKER);
            outputStream.close();
            indexFileConnection.close();
            this.messageEnvelopeMapDirty = false;
        }
    }

    public FolderMessage[] getFolderMessages() throws IOException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"MaildirFolder.getFolderMessages()".getBytes(), (int)5);
        }
        if (this.fileConnection == null) {
            throw new IOException("Maildir not open");
        }
        Vector<String> fileList = new Vector<String>();
        Enumeration e = this.fileConnection.list();
        while (e.hasMoreElements()) {
            String file = (String)e.nextElement();
            if (file.indexOf(95) == -1) continue;
            fileList.addElement(file);
        }
        Vector<FolderMessage> folderMessageList = new Vector<FolderMessage>();
        int size = fileList.size();
        this.nextIndex = 0;
        for (int i = 0; i < size; ++i) {
            String fileName = (String)fileList.elementAt(i);
            FileConnection mailFileConnection = (FileConnection)Connector.open((String)(this.fileConnection.getURL() + '/' + fileName));
            if (mailFileConnection.exists() && !mailFileConnection.isDirectory() && mailFileConnection.canRead()) {
                try {
                    int p = fileName.indexOf("_2,");
                    if (p != -1) {
                        MessageEnvelope envelope;
                        String uniqueId = fileName.substring(0, p);
                        if (this.messageEnvelopeMap.containsKey(uniqueId)) {
                            envelope = (MessageEnvelope)this.messageEnvelopeMap.get(uniqueId);
                        } else {
                            InputStream inputStream = mailFileConnection.openInputStream();
                            envelope = this.getMessageEnvelope(inputStream);
                            inputStream.close();
                            this.messageEnvelopeMap.put(uniqueId, envelope);
                            this.messageEnvelopeMapDirty = true;
                        }
                        FolderMessage folderMessage = new FolderMessage(new LocalMessageToken(this.folderPath, uniqueId), envelope, this.nextIndex++, uniqueId.hashCode());
                        folderMessage.setAnswered(fileName.indexOf(82, p += 3) != -1);
                        folderMessage.setDeleted(fileName.indexOf(84, p) != -1);
                        folderMessage.setDraft(fileName.indexOf(68, p) != -1);
                        folderMessage.setFlagged(fileName.indexOf(70, p) != -1);
                        folderMessage.setSeen(fileName.indexOf(83, p) != -1);
                        folderMessageList.addElement(folderMessage);
                    }
                }
                catch (Exception exp) {
                    EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to read envelope for " + mailFileConnection.getURL()).getBytes(), (int)2);
                }
            }
            mailFileConnection.close();
        }
        Object[] result = new FolderMessage[folderMessageList.size()];
        folderMessageList.copyInto(result);
        return result;
    }

    private MessageEnvelope getMessageEnvelope(InputStream inputStream) throws IOException {
        int ch;
        InputStreamReader reader = new InputStreamReader(inputStream);
        Vector<String> headerLines = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        while ((ch = reader.read()) != -1) {
            if (ch == 10) {
                if (buf.length() <= 0) break;
                headerLines.addElement(buf.toString());
                buf.delete(0, buf.length());
                continue;
            }
            if (ch == 13) continue;
            buf.append((char)ch);
        }
        Object[] headerLinesArray = new String[headerLines.size()];
        headerLines.copyInto(headerLinesArray);
        MessageEnvelope envelope = MailMessageParser.parseMessageEnvelope((String[])headerLinesArray);
        return envelope;
    }

    public String getMessageSource(LocalMessageToken localMessageToken) throws IOException {
        String messageSource;
        block7: {
            if (EventLogger.getMinimumLevel() >= 5) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("MaildirFolder.getMessageSource(): " + localMessageToken.getMessageUid()).getBytes(), (int)5);
            }
            if (this.fileConnection == null) {
                throw new IOException("Maildir not open");
            }
            String uniqueId = localMessageToken.getMessageUid();
            if (uniqueId == null) {
                return null;
            }
            Enumeration e = this.fileConnection.list(uniqueId + '*', false);
            if (!e.hasMoreElements()) {
                return null;
            }
            String matchingFile = (String)e.nextElement();
            messageSource = null;
            try {
                FileConnection mailFileConnection = (FileConnection)Connector.open((String)(this.fileConnection.getURL() + '/' + matchingFile));
                if (mailFileConnection.exists() && !mailFileConnection.isDirectory() && mailFileConnection.canRead()) {
                    InputStream inputStream = mailFileConnection.openInputStream();
                    messageSource = this.getMessageSourceFromStream(inputStream);
                    inputStream.close();
                }
            }
            catch (Exception exp) {
                if (EventLogger.getMinimumLevel() < 5) break block7;
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("Error getting message source: " + exp.toString()).getBytes(), (int)5);
            }
        }
        return messageSource;
    }

    private String getMessageSourceFromStream(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuffer buf = new StringBuffer();
        char[] rawBuf = new char[1024];
        while ((n = reader.read(rawBuf, 0, 1024)) != -1) {
            buf.append(rawBuf, 0, n);
        }
        rawBuf = null;
        return buf.toString();
    }

    public FolderMessage appendMessage(String rawMessage, MessageFlags initialFlags) {
        FolderMessage result;
        MessageEnvelope envelope;
        String uniqueId;
        block11: {
            if (EventLogger.getMinimumLevel() >= 5) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])"MaildirFolder.appendMessage()".getBytes(), (int)5);
            }
            StringBuffer buf = new StringBuffer();
            buf.append(System.currentTimeMillis());
            buf.append('.');
            buf.append(ApplicationManager.getApplicationManager().getProcessId(ApplicationDescriptor.currentApplicationDescriptor()));
            buf.append('.');
            buf.append(DeviceInfo.getDeviceId());
            uniqueId = buf.toString();
            buf.append("_2,");
            if (initialFlags.isAnswered()) {
                buf.append('R');
            }
            if (initialFlags.isDeleted()) {
                buf.append('T');
            }
            if (initialFlags.isDraft()) {
                buf.append('D');
            }
            if (initialFlags.isFlagged()) {
                buf.append('F');
            }
            if (initialFlags.isSeen()) {
                buf.append('S');
            }
            if (EventLogger.getMinimumLevel() >= 5) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("MaildirFolder.appendMessage()\r\nfilename: " + buf.toString()).getBytes(), (int)5);
            }
            envelope = null;
            try {
                FileConnection mailFileConnection = (FileConnection)Connector.open((String)(this.fileConnection.getURL() + '/' + buf.toString()));
                mailFileConnection.create();
                DataOutputStream outputStream = mailFileConnection.openDataOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                writer.write(rawMessage);
                outputStream.close();
                InputStream inputStream = mailFileConnection.openInputStream();
                envelope = this.getMessageEnvelope(inputStream);
                inputStream.close();
                mailFileConnection.close();
                this.messageEnvelopeMap.put(uniqueId, envelope);
                this.messageEnvelopeMapDirty = true;
            }
            catch (IOException exp) {
                if (EventLogger.getMinimumLevel() < 5) break block11;
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("Error writing message: " + exp.toString()).getBytes(), (int)5);
            }
        }
        if (envelope != null) {
            result = new FolderMessage(new LocalMessageToken(this.folderPath, uniqueId), envelope, this.nextIndex++, uniqueId.hashCode());
            result.setAnswered(initialFlags.isAnswered());
            result.setDeleted(initialFlags.isDeleted());
            result.setDraft(initialFlags.isDraft());
            result.setFlagged(initialFlags.isFlagged());
            result.setSeen(initialFlags.isSeen());
        } else {
            result = null;
        }
        return result;
    }
}

