/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class MessageEnvelope
implements Serializable {
    private long uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
    public Date date;
    public String subject;
    public String[] from;
    public String[] sender;
    public String[] replyTo;
    public String[] to;
    public String[] cc;
    public String[] bcc;
    public String inReplyTo;
    public String messageId;

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        output.writeLong(this.date.getTime());
        output.writeUTF(this.subject != null ? this.subject : "");
        MessageEnvelope.serializeArray(output, this.from);
        MessageEnvelope.serializeArray(output, this.sender);
        MessageEnvelope.serializeArray(output, this.replyTo);
        MessageEnvelope.serializeArray(output, this.to);
        MessageEnvelope.serializeArray(output, this.cc);
        MessageEnvelope.serializeArray(output, this.bcc);
        output.writeUTF(this.inReplyTo != null ? this.inReplyTo : "");
        output.writeUTF(this.messageId != null ? this.messageId : "");
    }

    private static void serializeArray(DataOutputStream output, String[] array) throws IOException {
        output.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            output.writeUTF(array[i]);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.uniqueId = input.readLong();
        long dateValue = input.readLong();
        this.date = Calendar.getInstance().getTime();
        this.date.setTime(dateValue);
        this.subject = input.readUTF();
        this.from = MessageEnvelope.deserializeArray(input);
        this.sender = MessageEnvelope.deserializeArray(input);
        this.replyTo = MessageEnvelope.deserializeArray(input);
        this.to = MessageEnvelope.deserializeArray(input);
        this.cc = MessageEnvelope.deserializeArray(input);
        this.bcc = MessageEnvelope.deserializeArray(input);
        this.inReplyTo = input.readUTF();
        this.messageId = input.readUTF();
    }

    private static String[] deserializeArray(DataInputStream input) throws IOException {
        int length = input.readInt();
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = input.readUTF();
        }
        return result;
    }
}

