/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import org.logicprobe.LogicMail.message.ApplicationContent;
import org.logicprobe.LogicMail.message.ApplicationPart;
import org.logicprobe.LogicMail.message.AudioContent;
import org.logicprobe.LogicMail.message.AudioPart;
import org.logicprobe.LogicMail.message.ImageContent;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessageContent;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.TextContent;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedContentException;
import org.logicprobe.LogicMail.message.VideoContent;
import org.logicprobe.LogicMail.message.VideoPart;

public class MimeMessageContentFactory {
    public static MimeMessageContent createContent(MimeMessagePart mimeMessagePart, String data) throws UnsupportedContentException {
        MimeMessageContent content;
        if (mimeMessagePart instanceof TextPart) {
            TextPart textPart = (TextPart)mimeMessagePart;
            content = new TextContent(textPart, textPart.getEncoding(), textPart.getCharset(), data);
        } else if (mimeMessagePart instanceof ImagePart) {
            ImagePart imagePart = (ImagePart)mimeMessagePart;
            content = new ImageContent(imagePart, imagePart.getEncoding(), data);
        } else if (mimeMessagePart instanceof ApplicationPart) {
            ApplicationPart applicationPart = (ApplicationPart)mimeMessagePart;
            content = new ApplicationContent(applicationPart, applicationPart.getEncoding(), data);
        } else if (mimeMessagePart instanceof AudioPart) {
            AudioPart audioPart = (AudioPart)mimeMessagePart;
            content = new AudioContent(audioPart, audioPart.getEncoding(), data);
        } else if (mimeMessagePart instanceof VideoPart) {
            VideoPart videoPart = (VideoPart)mimeMessagePart;
            content = new VideoContent(videoPart, videoPart.getEncoding(), data);
        } else if (mimeMessagePart instanceof MessagePart) {
            MessagePart messagePart = (MessagePart)mimeMessagePart;
            content = new MessageContent(messagePart, messagePart.getEncoding(), data);
        } else {
            throw new UnsupportedContentException("Unsupported content type");
        }
        return content;
    }

    public static boolean isContentSupported(MimeMessagePart mimeMessagePart) {
        boolean result = mimeMessagePart instanceof TextPart ? TextContent.isPartSupported((TextPart)mimeMessagePart) : (mimeMessagePart instanceof ImagePart ? ImageContent.isPartSupported((ImagePart)mimeMessagePart) : (mimeMessagePart instanceof ApplicationPart ? ApplicationContent.isPartSupported((ApplicationPart)mimeMessagePart) : (mimeMessagePart instanceof AudioPart ? AudioContent.isPartSupported((AudioPart)mimeMessagePart) : (mimeMessagePart instanceof VideoPart ? VideoContent.isPartSupported((VideoPart)mimeMessagePart) : (mimeMessagePart instanceof MessagePart ? MessageContent.isPartSupported((MessagePart)mimeMessagePart) : false)))));
        return result;
    }
}

