/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.message.MimeMessagePartVisitor;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public abstract class MimeMessagePart
implements Serializable {
    private long uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
    private String tag;
    private String mimeType;
    private String mimeSubtype;
    private int size;
    private MimeMessagePart parent;

    protected MimeMessagePart(String mimeType, String mimeSubtype, int size, String tag) {
        this.tag = tag;
        this.mimeType = mimeType;
        this.mimeSubtype = mimeSubtype;
        this.size = size;
        this.parent = null;
    }

    public abstract void accept(MimeMessagePartVisitor var1);

    public String getTag() {
        return this.tag;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMimeSubtype() {
        return this.mimeSubtype;
    }

    public int getSize() {
        return this.size;
    }

    protected void setParent(MimeMessagePart parent) {
        this.parent = parent;
    }

    public MimeMessagePart getParent() {
        return this.parent;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        output.writeUTF(this.tag);
        output.writeUTF(this.mimeType);
        output.writeUTF(this.mimeSubtype);
        output.writeInt(this.size);
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.uniqueId = input.readLong();
        this.tag = input.readUTF();
        this.mimeType = input.readUTF();
        this.mimeSubtype = input.readUTF();
        this.size = input.readInt();
    }
}

