/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.MimeMessagePartVisitor;
import org.logicprobe.LogicMail.util.SerializationUtils;

public class MultiPart
extends MimeMessagePart {
    private MimeMessagePart[] parts;
    private boolean partMixed = false;
    private boolean partAlternative = false;
    private boolean partRelated = false;
    private boolean partSigned = false;

    public MultiPart(String mimeSubtype, String tag) {
        super("multipart", mimeSubtype, -1, tag);
        if (mimeSubtype.equalsIgnoreCase("alternative")) {
            this.partAlternative = true;
        } else if (mimeSubtype.equalsIgnoreCase("related")) {
            this.partRelated = true;
        } else if (mimeSubtype.equalsIgnoreCase("signed")) {
            this.partSigned = true;
        } else {
            this.partMixed = true;
        }
    }

    public MultiPart(String mimeSubtype) {
        this(mimeSubtype, "");
    }

    public MultiPart() {
        this("", "");
    }

    public void accept(MimeMessagePartVisitor visitor) {
        visitor.visitMultiPart(this);
        if (this.parts != null) {
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].accept(visitor);
            }
        }
    }

    public void addPart(MimeMessagePart part) {
        if (this.parts == null) {
            this.parts = new MimeMessagePart[1];
            this.parts[0] = part;
        } else {
            Arrays.add((Object[])this.parts, (Object)part);
        }
        part.setParent(this);
    }

    public MimeMessagePart[] getParts() {
        return this.parts;
    }

    public boolean isPartMixed() {
        return this.partMixed;
    }

    public boolean isPartAlternative() {
        return this.partAlternative;
    }

    public boolean isPartRelated() {
        return this.partRelated;
    }

    public boolean isPartSigned() {
        return this.partSigned;
    }

    public void serialize(DataOutputStream output) throws IOException {
        super.serialize(output);
        output.writeBoolean(this.partMixed);
        output.writeBoolean(this.partAlternative);
        output.writeBoolean(this.partRelated);
        output.writeBoolean(this.partSigned);
        output.writeInt(this.parts.length);
        for (int i = 0; i < this.parts.length; ++i) {
            SerializationUtils.serializeClass(this.parts[i], output);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        super.deserialize(input);
        this.partMixed = input.readBoolean();
        this.partAlternative = input.readBoolean();
        this.partRelated = input.readBoolean();
        this.partSigned = input.readBoolean();
        int partCount = input.readInt();
        for (int i = 0; i < partCount; ++i) {
            MimeMessagePart part = (MimeMessagePart)SerializationUtils.deserializeClass(input);
            this.addPart(part);
        }
    }
}

