/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.mail.AbstractMailSender;
import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.mail.FolderEvent;
import org.logicprobe.LogicMail.mail.FolderListener;
import org.logicprobe.LogicMail.mail.FolderMessagesEvent;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.MailSenderListener;
import org.logicprobe.LogicMail.mail.MailStoreListener;
import org.logicprobe.LogicMail.mail.MessageEvent;
import org.logicprobe.LogicMail.mail.MessageListener;
import org.logicprobe.LogicMail.mail.MessageSentEvent;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.mail.NetworkMailStore;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.model.AccountNodeEvent;
import org.logicprobe.LogicMail.model.AccountNodeListener;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.model.NodeVisitor;
import org.logicprobe.LogicMail.model.OutboxMailboxNode;
import org.logicprobe.LogicMail.model.OutgoingMessageNode;
import org.logicprobe.LogicMail.util.DataStore;
import org.logicprobe.LogicMail.util.DataStoreFactory;
import org.logicprobe.LogicMail.util.EventListener;
import org.logicprobe.LogicMail.util.EventListenerList;
import org.logicprobe.LogicMail.util.Serializable;

public class AccountNode
implements Node {
    public static final int STATUS_LOCAL = 0;
    public static final int STATUS_OFFLINE = 1;
    public static final int STATUS_ONLINE = 2;
    private AbstractMailStore mailStore;
    private boolean usePersistedState;
    private AbstractMailSender mailSender;
    private MailRootNode parent;
    private MailboxNode rootMailbox = null;
    private Hashtable pathMailboxMap;
    private Object rootMailboxLock = new Object();
    private EventListenerList listenerList = new EventListenerList();
    private AccountConfig accountConfig;
    private int status;
    private boolean shutdown = false;
    private DataStore accountDataStore;
    private MailSenderListener mailSenderListener = new MailSenderListener(){

        public void messageSent(MessageSentEvent e) {
            AccountNode.this.mailSender_MessageSent(e);
        }
    };
    static /* synthetic */ Class class$org$logicprobe$LogicMail$model$AccountNodeListener;

    AccountNode(AbstractMailStore mailStore) {
        this(mailStore, true);
    }

    AccountNode(AbstractMailStore mailStore, boolean usePersistedState) {
        this.pathMailboxMap = new Hashtable();
        this.mailStore = mailStore;
        this.usePersistedState = usePersistedState;
        if (!mailStore.isLocal() && mailStore instanceof NetworkMailStore) {
            this.accountConfig = ((NetworkMailStore)mailStore).getAccountConfig();
            this.status = 1;
        } else {
            this.status = 0;
        }
        this.mailStore.addMailStoreListener(new MailStoreListener(){

            public void folderTreeUpdated(FolderEvent e) {
                AccountNode.this.mailStore_FolderTreeUpdated(e);
            }
        });
        this.mailStore.addFolderListener(new FolderListener(){

            public void folderStatusChanged(FolderEvent e) {
                AccountNode.this.mailStore_FolderStatusChanged(e);
            }

            public void folderMessagesAvailable(FolderMessagesEvent e) {
                AccountNode.this.mailStore_FolderMessagesAvailable(e);
            }
        });
        this.mailStore.addMessageListener(new MessageListener(){

            public void messageAvailable(MessageEvent e) {
                AccountNode.this.mailStore_messageAvailable(e);
            }

            public void messageFlagsChanged(MessageEvent e) {
                AccountNode.this.mailStore_messageFlagsChanged(e);
            }

            public void messageDeleted(MessageEvent e) {
                AccountNode.this.mailStore_messageDeleted(e);
            }

            public void messageUndeleted(MessageEvent e) {
                AccountNode.this.mailStore_messageUndeleted(e);
            }
        });
        if (!mailStore.hasFolders()) {
            this.rootMailbox = new MailboxNode(new FolderTreeItem("", "", ""), false, -1);
            this.rootMailbox.setParentAccount(this);
            MailboxNode inboxNode = new MailboxNode(new FolderTreeItem("INBOX", "INBOX", ""), false, 1);
            inboxNode.setParentAccount(this);
            this.rootMailbox.addMailbox(inboxNode);
            this.pathMailboxMap.put("INBOX", inboxNode);
        }
        if (usePersistedState) {
            this.load();
        }
    }

    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    AbstractMailSender getMailSender() {
        return this.mailSender;
    }

    void setMailSender(AbstractMailSender mailSender) {
        if (this.mailSender != null && mailSender == null) {
            this.mailSender.removeMailSenderListener(this.mailSenderListener);
            this.mailSender = null;
        } else if (this.mailSender != null && this.mailSender != mailSender) {
            this.mailSender.removeMailSenderListener(this.mailSenderListener);
            this.mailSender = mailSender;
            this.mailSender.addMailSenderListener(this.mailSenderListener);
        } else if (this.mailSender == null && mailSender != null) {
            this.mailSender = mailSender;
            this.mailSender.addMailSenderListener(this.mailSenderListener);
        }
    }

    public boolean hasMailSender() {
        return this.mailSender != null;
    }

    void setParent(MailRootNode parent) {
        this.parent = parent;
    }

    public MailRootNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxNode getRootMailbox() {
        Object object = this.rootMailboxLock;
        synchronized (object) {
            return this.rootMailbox;
        }
    }

    public String toString() {
        if (this.accountConfig != null) {
            return this.accountConfig.toString();
        }
        return "Local Folders";
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    AbstractMailStore getMailStore() {
        return this.mailStore;
    }

    void setStatus(int status) {
        if (this.status != status) {
            this.status = status;
            if (this.status == 1 && !this.shutdown && this.mailStore instanceof NetworkMailStore) {
                ((NetworkMailStore)this.mailStore).restart();
            }
            this.fireAccountStatusChanged(0);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void requestDisconnect(boolean shutdown) {
        if (this.status == 2 && this.mailStore instanceof NetworkMailStore) {
            ((NetworkMailStore)this.mailStore).shutdown(false);
            this.shutdown = shutdown;
        }
    }

    public boolean hasFolders() {
        return this.mailStore.hasFolders();
    }

    public boolean hasUndelete() {
        return this.mailStore.hasUndelete();
    }

    public void refreshMailboxes() {
        if (this.mailStore.hasFolders()) {
            this.mailStore.requestFolderTree();
        }
    }

    public void refreshMailboxStatus() {
        int size = this.pathMailboxMap.size();
        FolderTreeItem[] folders = new FolderTreeItem[size];
        Enumeration e = this.pathMailboxMap.keys();
        for (int i = 0; i < size; ++i) {
            folders[i] = ((MailboxNode)this.pathMailboxMap.get(e.nextElement())).getFolderTreeItem();
        }
        this.mailStore.requestFolderStatus(folders);
    }

    public void sendMessage(MessageEnvelope envelope, Message message) {
        if (this.mailSender != null) {
            FolderMessage outgoingFolderMessage = new FolderMessage(null, envelope, -1, -1);
            outgoingFolderMessage.setSeen(false);
            outgoingFolderMessage.setRecent(true);
            OutgoingMessageNode outgoingMessage = new OutgoingMessageNode(outgoingFolderMessage, this, this.mailSender);
            outgoingMessage.setMessageStructure(message.getStructure());
            outgoingMessage.putMessageContent(message.getAllContent());
            MailManager.getInstance().getOutboxMailboxNode().addMessage(outgoingMessage);
        }
    }

    public void sendMessageReply(MessageEnvelope envelope, Message message, MessageNode originalMessageNode) {
        if (this.mailSender != null) {
            FolderMessage outgoingFolderMessage = new FolderMessage(null, envelope, -1, -1);
            outgoingFolderMessage.setSeen(false);
            outgoingFolderMessage.setRecent(true);
            OutgoingMessageNode outgoingMessage = new OutgoingMessageNode(outgoingFolderMessage, this, this.mailSender, originalMessageNode);
            outgoingMessage.setMessageStructure(message.getStructure());
            outgoingMessage.putMessageContent(message.getAllContent());
            MailManager.getInstance().getOutboxMailboxNode().addMessage(outgoingMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mailStore_FolderTreeUpdated(FolderEvent e) {
        FolderTreeItem rootFolder = e.getFolder();
        Object object = this.rootMailboxLock;
        synchronized (object) {
            Hashtable<String, MailboxNode> remainingMailboxMap = new Hashtable<String, MailboxNode>();
            if (this.rootMailbox != null) {
                Vector flatMailboxes = new Vector();
                this.populateFlatMailboxes(flatMailboxes, this.rootMailbox);
                this.rootMailbox = null;
                Hashtable folderPathMap = new Hashtable();
                this.populateFolderPathMap(folderPathMap, rootFolder);
                int size = flatMailboxes.size();
                for (int i = 0; i < size; ++i) {
                    MailboxNode mailboxNode = (MailboxNode)flatMailboxes.elementAt(i);
                    String path = mailboxNode.getFolderTreeItem().getPath();
                    if (!folderPathMap.containsKey(path)) continue;
                    mailboxNode.setFolderTreeItem((FolderTreeItem)folderPathMap.get(path));
                    remainingMailboxMap.put(path, mailboxNode);
                }
            }
            this.pathMailboxMap.clear();
            this.rootMailbox = new MailboxNode(rootFolder, false, -1);
            this.populateMailboxNodes(rootFolder, this.rootMailbox, remainingMailboxMap);
        }
        if (this.usePersistedState) {
            this.save();
        }
        this.fireAccountStatusChanged(1);
    }

    private void populateFlatMailboxes(Vector flatMailboxes, MailboxNode currentMailbox) {
        flatMailboxes.addElement(currentMailbox);
        MailboxNode[] childNodes = currentMailbox.getMailboxes();
        for (int i = 0; i < childNodes.length; ++i) {
            this.populateFlatMailboxes(flatMailboxes, childNodes[i]);
        }
        currentMailbox.clearMailboxes();
    }

    private void populateFolderPathMap(Hashtable folderPathMap, FolderTreeItem folderTreeItem) {
        if (folderTreeItem != null) {
            folderPathMap.put(folderTreeItem.getPath(), folderTreeItem);
            if (folderTreeItem.hasChildren()) {
                FolderTreeItem[] children = folderTreeItem.children();
                for (int i = 0; i < children.length; ++i) {
                    this.populateFolderPathMap(folderPathMap, children[i]);
                }
            }
        }
    }

    private void populateMailboxNodes(FolderTreeItem folderTreeItem, MailboxNode currentMailbox, Hashtable remainingMailboxMap) {
        this.pathMailboxMap.put(folderTreeItem.getPath(), currentMailbox);
        if (folderTreeItem.hasChildren()) {
            FolderTreeItem[] folderTreeItemChildren = folderTreeItem.children();
            for (int i = 0; i < folderTreeItemChildren.length; ++i) {
                MailboxNode childMailbox;
                if (remainingMailboxMap.containsKey(folderTreeItemChildren[i].getPath())) {
                    childMailbox = (MailboxNode)remainingMailboxMap.get(folderTreeItemChildren[i].getPath());
                } else {
                    int mailboxType = this.getMailboxType(folderTreeItemChildren[i]);
                    childMailbox = mailboxType == 2 ? new OutboxMailboxNode(folderTreeItemChildren[i]) : new MailboxNode(folderTreeItemChildren[i], folderTreeItemChildren[i].isAppendable(), mailboxType);
                    childMailbox.setParentAccount(this);
                }
                this.populateMailboxNodes(folderTreeItemChildren[i], childMailbox, remainingMailboxMap);
                currentMailbox.addMailbox(childMailbox);
            }
        }
    }

    private void mailStore_FolderStatusChanged(FolderEvent e) {
        this.updateMailboxStatus(e.getFolder());
    }

    private void updateMailboxStatus(FolderTreeItem currentFolder) {
        MailboxNode mailboxNode = (MailboxNode)this.pathMailboxMap.get(currentFolder.getPath());
        if (mailboxNode != null) {
            FolderTreeItem mailboxFolder = mailboxNode.getFolderTreeItem();
            mailboxFolder.setMsgCount(currentFolder.getMsgCount());
            mailboxFolder.setUnseenCount(currentFolder.getUnseenCount());
            mailboxNode.fireMailboxStatusChanged(0, null);
        }
        if (currentFolder.hasChildren()) {
            FolderTreeItem[] children = currentFolder.children();
            for (int i = 0; i < children.length; ++i) {
                this.updateMailboxStatus(children[i]);
            }
        }
    }

    private void mailStore_FolderMessagesAvailable(FolderMessagesEvent e) {
        if (e.getMessages() != null) {
            if (!this.pathMailboxMap.containsKey(e.getFolder().getPath())) {
                return;
            }
            MailboxNode mailboxNode = (MailboxNode)this.pathMailboxMap.get(e.getFolder().getPath());
            FolderMessage[] folderMessages = e.getMessages();
            Vector<MessageNode> addedMessages = new Vector<MessageNode>();
            for (int i = 0; i < folderMessages.length; ++i) {
                addedMessages.addElement(new MessageNode(folderMessages[i]));
            }
            Object[] addedMessagesArray = new MessageNode[addedMessages.size()];
            addedMessages.copyInto(addedMessagesArray);
            mailboxNode.addMessages((MessageNode[])addedMessagesArray);
        }
    }

    private void mailStore_messageAvailable(MessageEvent e) {
        MessageNode messageNode = this.findMessageForToken(e.getMessageToken());
        if (messageNode != null) {
            switch (e.getType()) {
                case 0: {
                    messageNode.setMessageStructure(e.getMessageStructure());
                    messageNode.setMessageSource(e.getMessageSource());
                    messageNode.putMessageContent(e.getMessageContent());
                    break;
                }
                case 1: {
                    messageNode.putMessageContent(e.getMessageContent());
                }
            }
        }
    }

    private void mailStore_messageFlagsChanged(MessageEvent e) {
        MessageNode messageNode = this.findMessageForToken(e.getMessageToken());
        if (messageNode != null) {
            messageNode.fireMessageStatusChanged(2);
        }
    }

    private void mailStore_messageDeleted(MessageEvent e) {
        MessageNode messageNode = this.findMessageForToken(e.getMessageToken());
        if (messageNode != null) {
            messageNode.fireMessageStatusChanged(2);
        }
    }

    private void mailStore_messageUndeleted(MessageEvent e) {
        MessageNode messageNode = this.findMessageForToken(e.getMessageToken());
        if (messageNode != null) {
            messageNode.fireMessageStatusChanged(2);
        }
    }

    private MessageNode findMessageForToken(MessageToken messageToken) {
        MailboxNode mailboxNode = null;
        Enumeration e = this.pathMailboxMap.elements();
        while (e.hasMoreElements()) {
            MailboxNode currentMailbox = (MailboxNode)e.nextElement();
            if (!messageToken.containedWithin(currentMailbox.getFolderTreeItem())) continue;
            mailboxNode = currentMailbox;
            break;
        }
        if (mailboxNode != null) {
            return mailboxNode.getMessageByToken(messageToken);
        }
        return null;
    }

    private void mailSender_MessageSent(MessageSentEvent e) {
    }

    private int getMailboxType(FolderTreeItem folderTreeItem) {
        if (folderTreeItem.getPath().equalsIgnoreCase("INBOX")) {
            return 1;
        }
        if (this.status == 0 && folderTreeItem.getPath().equalsIgnoreCase("Outbox")) {
            return 2;
        }
        if (this.status == 0 && folderTreeItem.getPath().equalsIgnoreCase("Drafts")) {
            return 3;
        }
        if (this.status == 0 && folderTreeItem.getPath().equalsIgnoreCase("Sent")) {
            return 4;
        }
        if (this.status == 0 && folderTreeItem.getPath().equalsIgnoreCase("Trash")) {
            return 5;
        }
        return 0;
    }

    public void addAccountNodeListener(AccountNodeListener l) {
        this.listenerList.add(class$org$logicprobe$LogicMail$model$AccountNodeListener == null ? (class$org$logicprobe$LogicMail$model$AccountNodeListener = AccountNode.class$("org.logicprobe.LogicMail.model.AccountNodeListener")) : class$org$logicprobe$LogicMail$model$AccountNodeListener, l);
    }

    public void removeAccountNodeListener(AccountNodeListener l) {
        this.listenerList.remove(class$org$logicprobe$LogicMail$model$AccountNodeListener == null ? (class$org$logicprobe$LogicMail$model$AccountNodeListener = AccountNode.class$("org.logicprobe.LogicMail.model.AccountNodeListener")) : class$org$logicprobe$LogicMail$model$AccountNodeListener, l);
    }

    public AccountNodeListener[] getAccountNodeListeners() {
        return (AccountNodeListener[])this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$AccountNodeListener == null ? (class$org$logicprobe$LogicMail$model$AccountNodeListener = AccountNode.class$("org.logicprobe.LogicMail.model.AccountNodeListener")) : class$org$logicprobe$LogicMail$model$AccountNodeListener);
    }

    protected void fireAccountStatusChanged(int type) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$AccountNodeListener == null ? (class$org$logicprobe$LogicMail$model$AccountNodeListener = AccountNode.class$("org.logicprobe.LogicMail.model.AccountNodeListener")) : class$org$logicprobe$LogicMail$model$AccountNodeListener);
        AccountNodeEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new AccountNodeEvent(this, type);
            }
            ((AccountNodeListener)listeners[i]).accountStatusChanged(e);
        }
    }

    private void save() {
        if (this.accountDataStore == null) {
            this.accountDataStore = DataStoreFactory.getConnectionCacheStore();
        }
        if (this.mailStore.isLocal()) {
            this.accountDataStore.putNamedObject("LocalMailStore", this.rootMailbox);
        } else {
            this.accountDataStore.putNamedObject(Long.toString(this.accountConfig.getUniqueId()), this.rootMailbox);
        }
        this.accountDataStore.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Serializable loadedObject;
        if (this.accountDataStore == null) {
            this.accountDataStore = DataStoreFactory.getConnectionCacheStore();
        }
        if ((loadedObject = this.mailStore.isLocal() ? this.accountDataStore.getNamedObject("LocalMailStore") : this.accountDataStore.getNamedObject(Long.toString(this.accountConfig.getUniqueId()))) instanceof MailboxNode) {
            Object object = this.rootMailboxLock;
            synchronized (object) {
                this.rootMailbox = (MailboxNode)loadedObject;
                this.rootMailbox.setParentAccount(this);
                this.prepareDeserializedMailboxNode(this.rootMailbox);
            }
        }
    }

    public void removeSavedData() {
        if (this.accountDataStore != null) {
            this.accountDataStore.delete();
            this.accountDataStore = null;
        }
    }

    private void prepareDeserializedMailboxNode(MailboxNode mailboxNode) {
        mailboxNode.setParentAccount(this);
        FolderTreeItem item = mailboxNode.getFolderTreeItem();
        if (item != null && item.getPath().length() > 0) {
            this.pathMailboxMap.put(item.getPath(), mailboxNode);
        }
        MailboxNode[] children = mailboxNode.getMailboxes();
        for (int i = 0; i < children.length; ++i) {
            this.prepareDeserializedMailboxNode(children[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

