/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import java.util.Vector;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.MailSettingsEvent;
import org.logicprobe.LogicMail.conf.MailSettingsListener;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.mail.AbstractMailSender;
import org.logicprobe.LogicMail.mail.MailConnectionListener;
import org.logicprobe.LogicMail.mail.MailConnectionLoginEvent;
import org.logicprobe.LogicMail.mail.MailConnectionManager;
import org.logicprobe.LogicMail.mail.MailConnectionStateEvent;
import org.logicprobe.LogicMail.mail.MailConnectionStatusEvent;
import org.logicprobe.LogicMail.mail.MailFactory;
import org.logicprobe.LogicMail.mail.NetworkMailSender;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManagerEvent;
import org.logicprobe.LogicMail.model.MailManagerListener;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.OutboxMailboxNode;
import org.logicprobe.LogicMail.util.EventListener;
import org.logicprobe.LogicMail.util.EventListenerList;

public class MailManager {
    private static MailManager instance = null;
    private EventListenerList listenerList = new EventListenerList();
    private MailRootNode mailRootNode;
    private MailSettings mailSettings = MailSettings.getInstance();
    private OutboxMailboxNode outboxMailboxNode;
    static /* synthetic */ Class class$org$logicprobe$LogicMail$model$MailManagerListener;

    private MailManager() {
        this.mailRootNode = new MailRootNode();
        this.mailSettings_MailSettingsSaved(new MailSettingsEvent(this));
        MailSettings.getInstance().addMailSettingsListener(new MailSettingsListener(){

            public void mailSettingsSaved(MailSettingsEvent e) {
                MailManager.this.mailSettings_MailSettingsSaved(e);
            }
        });
        MailConnectionManager.getInstance().addMailConnectionListener(new MailConnectionListener(){

            public void mailConnectionStateChanged(MailConnectionStateEvent e) {
                MailManager.this.mailConnectionManager_MailConnectionStateChanged(e);
            }

            public void mailConnectionStatus(MailConnectionStatusEvent e) {
            }

            public void mailConnectionError(MailConnectionStatusEvent e) {
            }

            public void mailConnectionLogin(MailConnectionLoginEvent e) {
            }
        });
        AccountNode[] accounts = this.mailRootNode.getAccounts();
        for (int i = 0; i < accounts.length; ++i) {
            if (accounts[i].getStatus() != 0) continue;
            accounts[i].refreshMailboxes();
            accounts[i].refreshMailboxStatus();
        }
        MailboxNode[] localMailboxes = this.mailRootNode.getLocalAccount().getRootMailbox().getMailboxes();
        for (int i = 0; i < localMailboxes.length; ++i) {
            if (!(localMailboxes[i] instanceof OutboxMailboxNode)) continue;
            this.outboxMailboxNode = (OutboxMailboxNode)localMailboxes[i];
            break;
        }
    }

    public static synchronized MailManager getInstance() {
        if (instance == null) {
            instance = new MailManager();
        }
        return instance;
    }

    public synchronized MailRootNode getMailRootNode() {
        return this.mailRootNode;
    }

    public OutboxMailboxNode getOutboxMailboxNode() {
        return this.outboxMailboxNode;
    }

    private synchronized void mailSettings_MailSettingsSaved(MailSettingsEvent e) {
        int i;
        AccountNode[] existingAccounts = this.mailRootNode.getAccounts();
        Vector<AccountNode> newAccounts = new Vector<AccountNode>();
        for (int i2 = 0; i2 < existingAccounts.length; ++i2) {
            if (existingAccounts[i2].getStatus() != 0) continue;
            newAccounts.addElement(existingAccounts[i2]);
        }
        int num = this.mailSettings.getNumAccounts();
        for (i = 0; i < num; ++i) {
            AccountConfig accountConfig = this.mailSettings.getAccountConfig(i);
            boolean accountExists = false;
            for (int j = 0; j < existingAccounts.length; ++j) {
                if (accountConfig != existingAccounts[j].getAccountConfig()) continue;
                accountExists = true;
                newAccounts.addElement(existingAccounts[j]);
                break;
            }
            if (accountExists) continue;
            AccountNode newAccountNode = new AccountNode(MailFactory.createMailStore(accountConfig));
            newAccounts.addElement(newAccountNode);
        }
        for (i = 0; i < existingAccounts.length; ++i) {
            this.mailRootNode.removeAccount(existingAccounts[i]);
        }
        num = newAccounts.size();
        for (i = 0; i < num; ++i) {
            this.mailRootNode.addAccount((AccountNode)newAccounts.elementAt(i));
        }
        for (i = 0; i < existingAccounts.length; ++i) {
            boolean accountDeleted = true;
            int size = newAccounts.size();
            for (int j = 0; j < size; ++j) {
                AccountNode newAccount = (AccountNode)newAccounts.elementAt(j);
                if (newAccount != existingAccounts[i]) continue;
                accountDeleted = false;
                break;
            }
            if (!accountDeleted) continue;
            existingAccounts[i].removeSavedData();
            MailFactory.clearMailStore(existingAccounts[i].getAccountConfig());
        }
        existingAccounts = this.mailRootNode.getAccounts();
        for (i = 0; i < existingAccounts.length; ++i) {
            if (existingAccounts[i].getStatus() == 0) continue;
            AbstractMailSender mailSender = existingAccounts[i].getMailSender();
            OutgoingConfig outgoingConfig = existingAccounts[i].getAccountConfig().getOutgoingConfig();
            if (outgoingConfig == null) {
                if (mailSender != null) {
                    mailSender.shutdown(false);
                }
                existingAccounts[i].setMailSender(null);
                continue;
            }
            if (mailSender instanceof NetworkMailSender && ((NetworkMailSender)mailSender).getOutgoingConfig() != outgoingConfig) {
                mailSender.shutdown(false);
                existingAccounts[i].setMailSender(MailFactory.createMailSender(existingAccounts[i].getAccountConfig().getOutgoingConfig()));
                continue;
            }
            if (mailSender != null) continue;
            existingAccounts[i].setMailSender(MailFactory.createMailSender(existingAccounts[i].getAccountConfig().getOutgoingConfig()));
        }
        this.fireMailConfigurationChanged();
    }

    private void mailConnectionManager_MailConnectionStateChanged(MailConnectionStateEvent e) {
        AccountNode[] accounts = this.mailRootNode.getAccounts();
        AccountNode matchingAccount = null;
        for (int i = 0; i < accounts.length; ++i) {
            if (!e.getConnectionConfig().equals(accounts[i].getAccountConfig())) continue;
            matchingAccount = accounts[i];
            break;
        }
        if (matchingAccount != null) {
            int state = e.getState();
            if (state == 1) {
                matchingAccount.setStatus(2);
            } else if (state == 0) {
                matchingAccount.setStatus(1);
            }
        }
    }

    public void addMailManagerListener(MailManagerListener l) {
        this.listenerList.add(class$org$logicprobe$LogicMail$model$MailManagerListener == null ? (class$org$logicprobe$LogicMail$model$MailManagerListener = MailManager.class$("org.logicprobe.LogicMail.model.MailManagerListener")) : class$org$logicprobe$LogicMail$model$MailManagerListener, l);
    }

    public void removeMailManagerListener(MailManagerListener l) {
        this.listenerList.remove(class$org$logicprobe$LogicMail$model$MailManagerListener == null ? (class$org$logicprobe$LogicMail$model$MailManagerListener = MailManager.class$("org.logicprobe.LogicMail.model.MailManagerListener")) : class$org$logicprobe$LogicMail$model$MailManagerListener, l);
    }

    public MailManagerListener[] getMailManagerListeners() {
        return (MailManagerListener[])this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MailManagerListener == null ? (class$org$logicprobe$LogicMail$model$MailManagerListener = MailManager.class$("org.logicprobe.LogicMail.model.MailManagerListener")) : class$org$logicprobe$LogicMail$model$MailManagerListener);
    }

    private void fireMailConfigurationChanged() {
        EventListener[] listeners = this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MailManagerListener == null ? (class$org$logicprobe$LogicMail$model$MailManagerListener = MailManager.class$("org.logicprobe.LogicMail.model.MailManagerListener")) : class$org$logicprobe$LogicMail$model$MailManagerListener);
        MailManagerEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new MailManagerEvent(this);
            }
            ((MailManagerListener)listeners[i]).mailConfigurationChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

