/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.util.Arrays;
import net.rim.device.api.util.Comparator;
import org.logicprobe.LogicMail.AppInfo;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.ImapConfig;
import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.message.AbstractMimeMessagePartVisitor;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessageMimeConverter;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.MimeMessagePartTransformer;
import org.logicprobe.LogicMail.message.TextContent;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.model.Address;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.model.NodeVisitor;
import org.logicprobe.LogicMail.util.EventListener;
import org.logicprobe.LogicMail.util.EventListenerList;
import org.logicprobe.LogicMail.util.StringParser;

public class MessageNode
implements Node {
    private static String strCRLF = "\r\n";
    private static MessageNodeComparator comparator = new MessageNodeComparator();
    private MessageToken messageToken;
    private int hashCode = -1;
    private int flags;
    private Date date;
    private String subject;
    private Address[] from;
    private Address[] sender;
    private Address[] replyTo;
    private Address[] to;
    private Address[] cc;
    private Address[] bcc;
    private String inReplyTo;
    private String messageId;
    private MailboxNode parent;
    private MimeMessagePart messageStructure;
    private Hashtable messageContent = new Hashtable();
    private MimeMessagePart[] attachmentParts;
    private String messageSource;
    private EventListenerList listenerList = new EventListenerList();
    private boolean refreshInProgress;
    static /* synthetic */ Class class$org$logicprobe$LogicMail$model$MessageNodeListener;

    MessageNode(FolderMessage folderMessage) {
        this.messageToken = folderMessage.getMessageToken();
        this.flags = MessageNode.convertMessageFlags(folderMessage.getFlags());
        MessageEnvelope envelope = folderMessage.getEnvelope();
        this.date = envelope.date;
        this.subject = envelope.subject;
        this.from = MessageNode.createAddressArray(envelope.from);
        this.sender = MessageNode.createAddressArray(envelope.sender);
        this.replyTo = MessageNode.createAddressArray(envelope.replyTo);
        this.to = MessageNode.createAddressArray(envelope.to);
        this.cc = MessageNode.createAddressArray(envelope.cc);
        this.bcc = MessageNode.createAddressArray(envelope.bcc);
        this.inReplyTo = envelope.inReplyTo;
        this.messageId = envelope.messageId;
        this.messageStructure = folderMessage.getStructure();
        if (this.messageStructure != null) {
            this.attachmentParts = MimeMessagePartTransformer.getAttachmentParts(this.messageStructure);
        }
    }

    private MessageNode() {
    }

    private static Address[] createAddressArray(String[] recipients) {
        Address[] result;
        if (recipients != null && recipients.length > 0) {
            result = new Address[recipients.length];
            for (int i = 0; i < recipients.length; ++i) {
                result[i] = new Address(recipients[i]);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static Comparator getComparator() {
        return comparator;
    }

    public boolean equals(Object obj) {
        return comparator.compare(this, obj) == 0;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.messageToken != null ? 217 + this.messageToken.hashCode() : (this.messageId != null ? this.messageId.hashCode() : super.hashCode());
        }
        return this.hashCode;
    }

    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    void setParent(MailboxNode parent) {
        this.parent = parent;
    }

    public MailboxNode getParent() {
        return this.parent;
    }

    public MessageToken getMessageToken() {
        return this.messageToken;
    }

    protected void setMessageToken(MessageToken messageToken) {
        this.messageToken = messageToken;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Address[] getFrom() {
        return this.from;
    }

    public void setFrom(Address[] from) {
        this.from = from;
    }

    public Address[] getSender() {
        return this.sender;
    }

    public void setSender(Address[] sender) {
        this.sender = sender;
    }

    public Address[] getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(Address[] replyTo) {
        this.replyTo = replyTo;
    }

    public Address[] getTo() {
        return this.to;
    }

    public void setTo(Address[] to) {
        this.to = to;
    }

    public Address[] getCc() {
        return this.cc;
    }

    public void setCc(Address[] cc) {
        this.cc = cc;
    }

    public Address[] getBcc() {
        return this.bcc;
    }

    public void setBcc(Address[] bcc) {
        this.bcc = bcc;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMessageStructure(MimeMessagePart messageStructure) {
        boolean fireEvent;
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            this.messageStructure = messageStructure;
            if (this.messageStructure != null) {
                this.refreshInProgress = false;
                this.flags &= 0xFFFFFFDF;
                this.attachmentParts = MimeMessagePartTransformer.getAttachmentParts(this.messageStructure);
                fireEvent = true;
            } else {
                fireEvent = false;
            }
        }
        if (fireEvent) {
            this.fireMessageStatusChanged(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putMessageContent(MimeMessageContent mimeMessageContent) {
        MimeMessageContent mimeMessageContent2 = mimeMessageContent;
        synchronized (mimeMessageContent2) {
            this.messageContent.put(mimeMessageContent.getMessagePart(), mimeMessageContent);
        }
        this.fireMessageStatusChanged(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putMessageContent(MimeMessageContent[] messageContent) {
        MimeMessageContent[] mimeMessageContentArray = messageContent;
        synchronized (messageContent) {
            for (int i = 0; i < messageContent.length; ++i) {
                this.messageContent.put(messageContent[i].getMessagePart(), messageContent[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireMessageStatusChanged(1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessagePart getMessageStructure() {
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            if (this.messageStructure != null) {
                this.flags |= 1;
            }
            return this.messageStructure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessageContent getMessageContent(MimeMessagePart mimeMessagePart) {
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            return (MimeMessageContent)this.messageContent.get(mimeMessagePart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessageContent() {
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            return this.messageStructure != null && !this.messageContent.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessageContent[] getAllMessageContent() {
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            MimeMessageContent[] result = new MimeMessageContent[this.messageContent.size()];
            Enumeration e = this.messageContent.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                result[i++] = (MimeMessageContent)this.messageContent.get(e.nextElement());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessagePart[] getAttachmentParts() {
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            return this.attachmentParts;
        }
    }

    void setMessageSource(String messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessageSource() {
        return this.messageSource;
    }

    public String toString() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toMimeMessage(boolean includeUserAgent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("From: ");
        buffer.append(StringParser.makeCsvString(this.from));
        buffer.append(strCRLF);
        buffer.append("To: ");
        buffer.append(StringParser.makeCsvString(this.to));
        buffer.append(strCRLF);
        if (this.cc != null && this.cc.length > 0) {
            buffer.append("Cc: ");
            buffer.append(StringParser.makeCsvString(this.cc));
            buffer.append(strCRLF);
        }
        if (this.replyTo != null && this.replyTo.length > 0) {
            buffer.append("Reply-To: ");
            buffer.append(StringParser.makeCsvString(this.replyTo));
            buffer.append(strCRLF);
        }
        buffer.append("Date: ");
        buffer.append(StringParser.createDateString(this.date));
        buffer.append(strCRLF);
        if (includeUserAgent) {
            buffer.append("User-Agent: ");
            buffer.append(AppInfo.getName());
            buffer.append('/');
            buffer.append(AppInfo.getVersion());
            buffer.append(strCRLF);
        }
        buffer.append("Subject: ");
        buffer.append(this.subject);
        buffer.append(strCRLF);
        if (this.inReplyTo != null) {
            buffer.append("In-Reply-To: ");
            buffer.append(this.inReplyTo);
            buffer.append(strCRLF);
        }
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            Message message = new Message(this.messageStructure);
            Enumeration en = this.messageContent.keys();
            while (en.hasMoreElements()) {
                MimeMessagePart part = (MimeMessagePart)en.nextElement();
                message.putContent(part, (MimeMessageContent)this.messageContent.get(part));
            }
            MessageMimeConverter messageMime = new MessageMimeConverter(message);
            buffer.append(messageMime.toMimeString());
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageNode toReplyMessage() {
        String senderName;
        if (this.sender != null && this.sender.length > 0) {
            senderName = this.sender[0].getName();
            if (senderName == null || senderName.length() == 0) {
                senderName = this.sender[0].getAddress();
            }
        } else {
            senderName = "";
        }
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            FindFirstTextPartVisitor findVisitor = new FindFirstTextPartVisitor();
            if (this.messageStructure != null) {
                this.messageStructure.accept(findVisitor);
            }
            TextPart originalTextPart = findVisitor.getFirstTextPart();
            TextContent originalTextContent = (TextContent)this.messageContent.get(originalTextPart);
            StringBuffer buf = new StringBuffer();
            buf.append("On ");
            buf.append(StringParser.createDateString(this.date));
            buf.append(", ");
            buf.append(senderName);
            buf.append(" wrote:\r\n");
            buf.append("> ");
            if (originalTextContent != null) {
                String originalText = originalTextContent.getText();
                int size = originalText.length();
                for (int i = 0; i < size; ++i) {
                    char ch = originalText.charAt(i);
                    buf.append(ch);
                    if (ch != '\n' || i >= size - 1) continue;
                    buf.append("> ");
                }
            }
            MessageNode replyNode = new MessageNode();
            String contentText = buf.toString();
            TextPart replyPart = new TextPart("plain", "", "", "", "", "", contentText.length());
            replyNode.messageStructure = replyPart;
            replyNode.putMessageContent(new TextContent(replyPart, contentText));
            this.populateReplyEnvelope(replyNode);
            return replyNode;
        }
    }

    public MessageNode toReplyAllMessage(String myAddress) {
        int i;
        MessageNode replyNode = this.toReplyMessage();
        if (this.to != null) {
            for (i = 0; i < this.to.length; ++i) {
                if (this.to[i].getAddress().toLowerCase().indexOf(myAddress) != -1) continue;
                if (replyNode.to == null) {
                    replyNode.to = new Address[1];
                    replyNode.to[0] = this.to[i];
                    continue;
                }
                Arrays.add((Object[])replyNode.to, (Object)this.to[i]);
            }
        }
        if (this.cc != null) {
            for (i = 0; i < this.cc.length; ++i) {
                if (this.cc[i].getAddress().toLowerCase().indexOf(myAddress) != -1) continue;
                if (replyNode.cc == null) {
                    replyNode.cc = new Address[1];
                    replyNode.cc[0] = this.cc[i];
                    continue;
                }
                Arrays.add((Object[])replyNode.cc, (Object)this.cc[i]);
            }
        }
        return replyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageNode toForwardMessage() {
        String fromString = StringParser.makeCsvString(StringParser.toStringArray(this.from));
        String toString = StringParser.makeCsvString(StringParser.toStringArray(this.to));
        String ccString = StringParser.makeCsvString(StringParser.toStringArray(this.cc));
        Hashtable hashtable = this.messageContent;
        synchronized (hashtable) {
            FindFirstTextPartVisitor findVisitor = new FindFirstTextPartVisitor();
            if (this.messageStructure != null) {
                this.messageStructure.accept(findVisitor);
            }
            TextPart originalTextPart = findVisitor.getFirstTextPart();
            TextContent originalTextContent = (TextContent)this.messageContent.get(originalTextPart);
            StringBuffer buf = new StringBuffer();
            buf.append("----Original Message----\r\n");
            buf.append("Subject: ");
            buf.append(this.subject);
            buf.append("\r\n");
            buf.append("Date: ");
            buf.append(StringParser.createDateString(this.date));
            buf.append("\r\n");
            if (fromString != null && fromString.length() > 0) {
                buf.append("From: ");
                buf.append(fromString);
                buf.append("\r\n");
            }
            if (toString != null && toString.length() > 0) {
                buf.append("To: ");
                buf.append(toString);
                buf.append("\r\n");
            }
            if (ccString != null && ccString.length() > 0) {
                buf.append("Cc: ");
                buf.append(ccString);
                buf.append("\r\n");
            }
            buf.append("\r\n");
            if (originalTextContent != null) {
                buf.append(originalTextContent.getText());
                buf.append("\r\n");
            }
            buf.append("------------------------");
            MessageNode forwardNode = new MessageNode();
            String contentText = buf.toString();
            TextPart forwardPart = new TextPart("plain", "", "", "", "", "", contentText.length());
            forwardNode.messageStructure = forwardPart;
            forwardNode.putMessageContent(new TextContent(forwardPart, contentText));
            forwardNode.subject = this.subject.toLowerCase().startsWith("fwd:") ? this.subject : "Fwd: " + this.subject;
            return forwardNode;
        }
    }

    private void populateReplyEnvelope(MessageNode replyNode) {
        replyNode.subject = this.subject.startsWith("Re:") || this.subject.startsWith("re:") ? this.subject : "Re: " + this.subject;
        if (this.replyTo == null || this.replyTo.length == 0) {
            if (this.sender == null || this.sender.length == 0) {
                replyNode.to = new Address[this.from.length];
                for (int i = 0; i < this.from.length; ++i) {
                    replyNode.to[i] = this.from[i];
                }
            } else {
                replyNode.to = new Address[this.sender.length];
                for (int i = 0; i < this.sender.length; ++i) {
                    replyNode.to[i] = this.sender[i];
                }
            }
        } else {
            replyNode.to = new Address[this.replyTo.length];
            for (int i = 0; i < this.replyTo.length; ++i) {
                replyNode.to[i] = this.replyTo[i];
            }
        }
        replyNode.inReplyTo = this.messageId;
    }

    public boolean refreshMessage() {
        boolean result = false;
        if (!this.refreshInProgress) {
            this.refreshInProgress = true;
            AbstractMailStore mailStore = this.parent.getParentAccount().getMailStore();
            if (mailStore.hasMessageParts()) {
                int maxSize = Integer.MAX_VALUE;
                Object[] displayableParts = MimeMessagePartTransformer.getDisplayableParts(this.messageStructure);
                AccountConfig accountConfig = this.parent.getParentAccount().getAccountConfig();
                if (accountConfig instanceof ImapConfig) {
                    maxSize = ((ImapConfig)accountConfig).getMaxMessageSize();
                }
                Vector<Object> partsToFetch = new Vector<Object>();
                int sizeRequested = 0;
                for (int i = 0; i < displayableParts.length && (sizeRequested += displayableParts[i].getSize()) <= maxSize; ++i) {
                    partsToFetch.addElement(displayableParts[i]);
                }
                if (partsToFetch.size() > 0) {
                    displayableParts = new MimeMessagePart[partsToFetch.size()];
                    partsToFetch.copyInto(displayableParts);
                    mailStore.requestMessageParts(this.messageToken, (MimeMessagePart[])displayableParts);
                    result = true;
                }
            } else {
                mailStore.requestMessage(this.messageToken);
                result = true;
            }
        }
        return result;
    }

    public void deleteMessage() {
        this.parent.getParentAccount().getMailStore().requestMessageDelete(this.messageToken, MessageNode.createMessageFlags(this.flags));
    }

    public void undeleteMessage() {
        AbstractMailStore mailStore = this.parent.getParentAccount().getMailStore();
        if (mailStore.hasUndelete()) {
            mailStore.requestMessageUndelete(this.messageToken, MessageNode.createMessageFlags(this.flags));
        }
    }

    public void addMessageNodeListener(MessageNodeListener l) {
        this.listenerList.add(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener, l);
    }

    public void removeMessageNodeListener(MessageNodeListener l) {
        this.listenerList.remove(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener, l);
    }

    public MessageNodeListener[] getMessageNodeListeners() {
        return (MessageNodeListener[])this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener);
    }

    protected void fireMessageStatusChanged(int type) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener);
        MessageNodeEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new MessageNodeEvent(this, type);
            }
            ((MessageNodeListener)listeners[i]).messageStatusChanged(e);
        }
    }

    static int convertMessageFlags(MessageFlags messageFlags) {
        int flags = 0;
        if (messageFlags.isSeen()) {
            flags |= 1;
        }
        if (messageFlags.isAnswered()) {
            flags |= 2;
        }
        if (messageFlags.isFlagged()) {
            flags |= 4;
        }
        if (messageFlags.isDeleted()) {
            flags |= 8;
        }
        if (messageFlags.isDraft()) {
            flags |= 0x10;
        }
        if (messageFlags.isRecent()) {
            flags |= 0x20;
        }
        if (messageFlags.isJunk()) {
            flags |= 0x40;
        }
        return flags;
    }

    static MessageFlags createMessageFlags(int flags) {
        MessageFlags messageFlags = new MessageFlags();
        messageFlags.setSeen((flags & 1) != 0);
        messageFlags.setAnswered((flags & 2) != 0);
        messageFlags.setFlagged((flags & 4) != 0);
        messageFlags.setDeleted((flags & 8) != 0);
        messageFlags.setDraft((flags & 0x10) != 0);
        messageFlags.setRecent((flags & 0x20) != 0);
        messageFlags.setJunk((flags & 0x40) != 0);
        return messageFlags;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FindFirstTextPartVisitor
    extends AbstractMimeMessagePartVisitor {
        private TextPart firstTextPart;

        private FindFirstTextPartVisitor() {
        }

        public TextPart getFirstTextPart() {
            return this.firstTextPart;
        }

        public void visitTextPart(TextPart part) {
            if (this.firstTextPart == null) {
                this.firstTextPart = part;
            }
        }
    }

    private static class MessageNodeComparator
    implements Comparator {
        private MessageNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof MessageNode && o2 instanceof MessageNode) {
                long time2;
                long time1;
                MessageNode message1 = (MessageNode)o1;
                MessageNode message2 = (MessageNode)o2;
                int result = message1.date != null && message2.date != null ? ((time1 = message1.date.getTime()) < (time2 = message2.date.getTime()) ? -1 : (time1 > time2 ? 1 : 0)) : 0;
                return result;
            }
            throw new ClassCastException("Cannot compare types");
        }
    }

    public static interface Flag {
        public static final int SEEN = 1;
        public static final int ANSWERED = 2;
        public static final int FLAGGED = 4;
        public static final int DELETED = 8;
        public static final int DRAFT = 16;
        public static final int RECENT = 32;
        public static final int JUNK = 64;
    }
}

