/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.mail.AbstractMailSender;
import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.MailSenderListener;
import org.logicprobe.LogicMail.mail.MessageSentEvent;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.OutgoingMessageNode;
import org.logicprobe.LogicMail.util.StringParser;

public class OutboxMailboxNode
extends MailboxNode {
    private int lastMessageId = 0;
    private Hashtable mailSenderTable = new Hashtable();
    private Hashtable outboundMessageMap = new Hashtable();
    private MailSenderListener mailSenderListener = new MailSenderListener(){

        public void messageSent(MessageSentEvent e) {
            OutboxMailboxNode.this.mailSender_MessageSent(e);
        }
    };

    OutboxMailboxNode(FolderTreeItem folderTreeItem) {
        super(folderTreeItem, false, 2);
    }

    void addMessage(MessageNode message) {
        if (message instanceof OutgoingMessageNode) {
            this.addOutgoingMessageImpl((OutgoingMessageNode)message);
        }
        super.addMessage(message);
    }

    void addMessages(MessageNode[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            if (!(messages[i] instanceof OutgoingMessageNode)) continue;
            this.addOutgoingMessageImpl((OutgoingMessageNode)messages[i]);
        }
        super.addMessages(messages);
    }

    public int getUnseenMessageCount() {
        return this.getMessageCount();
    }

    protected void fireMailboxStatusChanged(int type, MessageNode[] affectedMessages) {
        super.fireMailboxStatusChanged(type, affectedMessages);
        if (type == 1) {
            for (int i = 0; i < affectedMessages.length; ++i) {
                if (!(affectedMessages[i] instanceof OutgoingMessageNode)) continue;
                this.handleNewMessage((OutgoingMessageNode)affectedMessages[i]);
            }
        }
    }

    private void addOutgoingMessageImpl(OutgoingMessageNode message) {
        message.setId(this.lastMessageId++);
        AbstractMailSender mailSender = message.getMailSender();
        if (!this.mailSenderTable.containsKey(mailSender)) {
            mailSender.addMailSenderListener(this.mailSenderListener);
            this.mailSenderTable.put(mailSender, new Integer(1));
        } else {
            int count = (Integer)this.mailSenderTable.get(mailSender);
            this.mailSenderTable.put(mailSender, new Integer(count++));
        }
        OutboxMessageToken messageToken = new OutboxMessageToken(this.getFolderTreeItem(), message.getId());
        message.setMessageToken(messageToken);
    }

    private void handleNewMessage(OutgoingMessageNode outgoingMessageNode) {
        MessageEnvelope envelope = new MessageEnvelope();
        envelope.date = outgoingMessageNode.getDate();
        envelope.subject = outgoingMessageNode.getSubject();
        envelope.from = StringParser.toStringArray(outgoingMessageNode.getFrom());
        envelope.sender = StringParser.toStringArray(outgoingMessageNode.getSender());
        envelope.replyTo = StringParser.toStringArray(outgoingMessageNode.getReplyTo());
        envelope.to = StringParser.toStringArray(outgoingMessageNode.getTo());
        envelope.cc = StringParser.toStringArray(outgoingMessageNode.getCc());
        envelope.bcc = StringParser.toStringArray(outgoingMessageNode.getBcc());
        envelope.inReplyTo = outgoingMessageNode.getInReplyTo();
        envelope.messageId = outgoingMessageNode.getMessageId();
        Message message = new Message(outgoingMessageNode.getMessageStructure());
        MimeMessageContent[] content = outgoingMessageNode.getAllMessageContent();
        for (int i = 0; i < content.length; ++i) {
            message.putContent(content[i].getMessagePart(), content[i]);
        }
        this.outboundMessageMap.put(message, outgoingMessageNode);
        outgoingMessageNode.getMailSender().requestSendMessage(envelope, message);
    }

    private void mailSender_MessageSent(MessageSentEvent e) {
        if (this.outboundMessageMap.get(e.getMessage()) instanceof OutgoingMessageNode) {
            AbstractMailStore sendingMailStore;
            MessageNode replyToMessageNode;
            OutgoingMessageNode outgoingMessageNode = (OutgoingMessageNode)this.outboundMessageMap.get(e.getMessage());
            this.outboundMessageMap.remove(e.getMessage());
            AccountConfig sendingAccountConfig = outgoingMessageNode.getSendingAccount().getAccountConfig();
            MailboxNode sentMailbox = sendingAccountConfig.getSentMailbox();
            if (sentMailbox != null && sentMailbox.hasAppend()) {
                MessageFlags initialFlags = new MessageFlags();
                initialFlags.setSeen(true);
                sentMailbox.appendRawMessage(e.getMessageSource(), initialFlags);
            }
            if ((replyToMessageNode = outgoingMessageNode.getReplyToMessageNode()) != null && (sendingMailStore = outgoingMessageNode.getSendingAccount().getMailStore()).hasFlags()) {
                sendingMailStore.requestMessageAnswered(replyToMessageNode.getMessageToken(), MessageNode.createMessageFlags(replyToMessageNode.getFlags()));
            }
            this.removeMessage(outgoingMessageNode);
        }
    }

    private static class OutboxMessageToken
    implements MessageToken {
        private String folderPath;
        private int messageId;

        public OutboxMessageToken(FolderTreeItem folderTreeItem, int messageId) {
            this.folderPath = folderTreeItem.getPath();
            this.messageId = messageId;
        }

        public int getMessageId() {
            return this.messageId;
        }

        public boolean containedWithin(FolderTreeItem folderTreeItem) {
            return folderTreeItem.getPath().equals(this.folderPath);
        }

        public long getUniqueId() {
            return 0L;
        }

        public void serialize(DataOutputStream output) throws IOException {
        }

        public void deserialize(DataInputStream input) throws IOException {
        }
    }
}

