/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.microedition.io.HttpConnection;
import net.rim.device.api.browser.field.BrowserContent;
import net.rim.device.api.browser.field.Event;
import net.rim.device.api.browser.field.RenderingApplication;
import net.rim.device.api.browser.field.RenderingException;
import net.rim.device.api.browser.field.RenderingSession;
import net.rim.device.api.browser.field.RequestedResource;
import net.rim.device.api.system.EncodedImage;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.message.ContentPart;
import org.logicprobe.LogicMail.message.ImageContent;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.TextContent;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.ui.BrowserFieldManager;
import org.logicprobe.LogicMail.util.UnicodeNormalizer;

public class BrowserFieldRenderer
implements RenderingApplication {
    private MessageNode messageNode;
    private TextContent content;
    private RenderingSession renderingSession;
    private BrowserContent browserContent;

    public BrowserFieldRenderer(MessageNode messageNode, TextContent content) {
        this.messageNode = messageNode;
        this.content = content;
        this.renderingSession = RenderingSession.getNewInstance();
    }

    public Field getBrowserField() {
        Object field = null;
        try {
            this.browserContent = this.renderingSession.getBrowserContent((HttpConnection)new LocalDataHttpConnection(this.content), (RenderingApplication)this, null);
            if (this.browserContent != null) {
                field = this.browserContent.getDisplayableContent();
            }
        }
        catch (RenderingException e) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("RenderingException: " + e.toString()).getBytes(), (int)2);
        }
        if (field != null) {
            BrowserFieldManager fieldManager = new BrowserFieldManager();
            fieldManager.add((Field)field);
            field = fieldManager;
        }
        return field;
    }

    public void finishLoading() {
        if (this.browserContent != null) {
            try {
                this.browserContent.finishLoading();
            }
            catch (RenderingException e) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("RenderingException: " + e.toString()).getBytes(), (int)2);
            }
        }
    }

    public Object eventOccurred(Event event) {
        return null;
    }

    public int getAvailableHeight(BrowserContent browserContent) {
        return Graphics.getScreenHeight();
    }

    public int getAvailableWidth(BrowserContent browserContent) {
        return Graphics.getScreenWidth();
    }

    public String getHTTPCookie(String url) {
        return null;
    }

    public int getHistoryPosition(BrowserContent browserContent) {
        return 0;
    }

    public HttpConnection getResource(RequestedResource resource, BrowserContent referrer) {
        if (resource == null) {
            return null;
        }
        if (resource.isCacheOnly()) {
            return null;
        }
        String url = resource.getUrl();
        if (url == null) {
            return null;
        }
        if (this.messageNode != null) {
            int p = url.indexOf("cid:");
            if (p == -1 || url.length() < 5) {
                return null;
            }
            String contentId = '<' + url.substring(4) + '>';
            MimeMessageContent contentMatch = null;
            MimeMessageContent[] contentArray = this.messageNode.getAllMessageContent();
            for (int i = 0; i < contentArray.length; ++i) {
                ContentPart part = contentArray[i].getMessagePart();
                if (!contentId.equals(part.getContentId())) continue;
                contentMatch = contentArray[i];
                break;
            }
            if (contentMatch != null) {
                return new LocalDataHttpConnection(contentMatch);
            }
        }
        return null;
    }

    public void invokeRunnable(Runnable runnable) {
        new Thread(runnable).run();
    }

    private static String getNormalizedText(TextContent content) {
        if (MailSettings.getInstance().getGlobalConfig().getUnicodeNormalization()) {
            String text = content.getText();
            if (((TextPart)content.getMessagePart()).getEncoding().equalsIgnoreCase("quoted-printable")) {
                try {
                    byte[] encodedBytes = text.getBytes();
                    text = new String(encodedBytes, ((TextPart)content.getMessagePart()).getCharset());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return UnicodeNormalizer.getInstance().normalize(text);
        }
        return content.getText();
    }

    private static class LocalDataHttpConnection
    implements HttpConnection {
        private ContentPart contentPart;
        private String mimeType;
        private byte[] data;

        public LocalDataHttpConnection(MimeMessageContent content) {
            this.contentPart = content.getMessagePart();
            if (content instanceof TextContent) {
                String text = BrowserFieldRenderer.getNormalizedText((TextContent)content);
                this.mimeType = this.contentPart.getMimeType() + '/' + this.contentPart.getMimeSubtype();
                try {
                    this.data = text.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (content instanceof ImageContent) {
                ImageContent imageContent = (ImageContent)content;
                EncodedImage image = imageContent.getImage();
                this.mimeType = image.getMIMEType();
                this.data = image.getData();
            } else {
                this.mimeType = this.contentPart.getMimeType() + '/' + this.contentPart.getMimeSubtype();
            }
            if (this.data == null) {
                this.data = new byte[0];
            }
        }

        public long getDate() throws IOException {
            return 0L;
        }

        public long getExpiration() throws IOException {
            return 0L;
        }

        public String getFile() {
            return null;
        }

        public String getHeaderField(String name) throws IOException {
            String result = name.equalsIgnoreCase("content-type") ? this.getType() : (name.equalsIgnoreCase("content-length") ? Long.toString(this.getLength()) : (name.equalsIgnoreCase("content-location") ? this.getURL() : (name.equalsIgnoreCase("accept-charset") ? "UTF-8" : null)));
            return result;
        }

        public String getHeaderField(int n) throws IOException {
            return "";
        }

        public long getHeaderFieldDate(String name, long def) throws IOException {
            return def;
        }

        public int getHeaderFieldInt(String name, int def) throws IOException {
            return def;
        }

        public String getHeaderFieldKey(int n) throws IOException {
            return null;
        }

        public String getHost() {
            return "localhost";
        }

        public long getLastModified() throws IOException {
            return 0L;
        }

        public int getPort() {
            return 80;
        }

        public String getProtocol() {
            return "http";
        }

        public String getQuery() {
            return null;
        }

        public String getRef() {
            return null;
        }

        public String getRequestMethod() {
            return "GET";
        }

        public String getRequestProperty(String key) {
            return null;
        }

        public int getResponseCode() throws IOException {
            return 200;
        }

        public String getResponseMessage() throws IOException {
            return "OK";
        }

        public String getURL() {
            return "";
        }

        public void setRequestMethod(String method) throws IOException {
        }

        public void setRequestProperty(String key, String property) throws IOException {
        }

        public String getEncoding() {
            return null;
        }

        public long getLength() {
            return this.data.length;
        }

        public String getType() {
            return this.mimeType;
        }

        public DataInputStream openDataInputStream() throws IOException {
            return new DataInputStream(this.openInputStream());
        }

        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public void close() throws IOException {
        }

        public DataOutputStream openDataOutputStream() throws IOException {
            return null;
        }

        public OutputStream openOutputStream() throws IOException {
            return null;
        }
    }
}

