/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EditField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.ui.BitmapButtonField;
import org.logicprobe.LogicMail.ui.FolderSelectionDialog;

public class FileSaveDialog
extends Dialog {
    private static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private ButtonField folderButtonField;
    private LabelField folderNameField;
    private EditField nameEditField;
    private ButtonField saveButtonField;
    private ButtonField cancelButtonField;
    private static String ROOT_URL = "file:///";
    private String folderUrl;
    private FieldChangeListener fieldChangeListener = new FieldChangeListener(){

        public void fieldChanged(Field field, int context) {
            if (field == FileSaveDialog.this.nameEditField) {
                FileSaveDialog.this.validateDialog();
            } else if (field == FileSaveDialog.this.folderButtonField) {
                FileSaveDialog.this.selectFolder();
            } else if (field == FileSaveDialog.this.saveButtonField) {
                FileSaveDialog.this.select(1);
            } else if (field == FileSaveDialog.this.cancelButtonField) {
                FileSaveDialog.this.cancel();
            }
        }
    };

    public FileSaveDialog(String folderUrl, String fileName) {
        super(' ' + resources.getString(157), null, null, 0, Bitmap.getPredefinedBitmap((int)0), 0x2000000000000L);
        this.folderUrl = ROOT_URL;
        this.setEscapeEnabled(true);
        this.initFields();
        if (folderUrl == null || folderUrl.length() == 0 || !folderUrl.startsWith(ROOT_URL)) {
            String localDataLocation = MailSettings.getInstance().getGlobalConfig().getLocalDataLocation();
            if (localDataLocation.startsWith("file:///store")) {
                this.setFolderUrl("file:///store/home/user/");
            } else if (localDataLocation.startsWith("file:///SDCard")) {
                this.setFolderUrl("file:///SDCard/BlackBerry/");
            } else {
                this.setFolderUrl(null);
            }
        } else {
            this.setFolderUrl(folderUrl);
        }
        this.setFileName(fileName);
    }

    public FileSaveDialog(String fileName) {
        this(null, fileName);
    }

    private void initFields() {
        HorizontalFieldManager folderFieldManager = new HorizontalFieldManager();
        this.folderButtonField = new BitmapButtonField(Bitmap.getBitmapResource((String)"folder.png"));
        this.folderButtonField.setChangeListener(this.fieldChangeListener);
        this.folderNameField = new LabelField((Object)this.folderUrl.substring(ROOT_URL.length() - 1));
        folderFieldManager.add((Field)this.folderButtonField);
        folderFieldManager.add((Field)new LabelField((Object)" ", 0x80000000000000L));
        folderFieldManager.add((Field)this.folderNameField);
        this.nameEditField = new EditField(resources.getString(158) + ' ', "");
        this.nameEditField.setChangeListener(this.fieldChangeListener);
        HorizontalFieldManager buttonFieldManager = new HorizontalFieldManager(0x300000000L);
        this.saveButtonField = new ButtonField(resources.getString(28));
        this.saveButtonField.setChangeListener(this.fieldChangeListener);
        this.saveButtonField.setEditable(false);
        this.cancelButtonField = new ButtonField(resources.getString(38));
        this.cancelButtonField.setChangeListener(this.fieldChangeListener);
        buttonFieldManager.add((Field)this.saveButtonField);
        buttonFieldManager.add((Field)this.cancelButtonField);
        this.add((Field)folderFieldManager);
        this.add((Field)this.nameEditField);
        this.add((Field)new SeparatorField());
        this.add((Field)buttonFieldManager);
    }

    public void setFolderUrl(String folderUrl) {
        if (folderUrl != null && folderUrl.length() > 0) {
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)folderUrl);
                if (fileConnection.isDirectory() && fileConnection.canWrite()) {
                    this.folderUrl = folderUrl;
                }
            }
            catch (IOException e) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to open: " + folderUrl).getBytes(), (int)2);
                this.folderUrl = ROOT_URL;
            }
        } else {
            this.folderUrl = ROOT_URL;
        }
        this.folderNameField.setText((Object)this.folderUrl.substring(ROOT_URL.length() - 1));
        this.validateDialog();
    }

    public void setFileName(String fileName) {
        if (fileName != null) {
            this.nameEditField.setText(fileName);
        } else {
            this.nameEditField.setText("");
        }
        this.validateDialog();
    }

    public String getFileUrl() {
        if (this.saveButtonField.isEditable()) {
            return this.folderUrl + this.nameEditField.getText();
        }
        return null;
    }

    private void validateDialog() {
        boolean isValid = !this.folderUrl.equals(ROOT_URL) && this.nameEditField.getText().length() != 0;
        this.saveButtonField.setEditable(isValid);
    }

    private void selectFolder() {
        FolderSelectionDialog dialog = new FolderSelectionDialog();
        dialog.setFolderUrl(this.folderUrl);
        if (dialog.doModal() != -1) {
            this.folderUrl = dialog.getFolderUrl();
            this.folderNameField.setText((Object)this.folderUrl.substring(ROOT_URL.length() - 1));
            this.validateDialog();
        }
    }
}

