/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.AutoTextEditField;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EmailAddressEditField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.ui.AbstractConfigScreen;

public class IdentityConfigScreen
extends AbstractConfigScreen {
    private IdentityConfig identityConfig;
    private boolean configSaved;
    private BasicEditField identityNameField;
    private BasicEditField fullNameField;
    private EmailAddressEditField emailAddressField;
    private EmailAddressEditField replyToAddressField;
    private AutoTextEditField msgSignatureField;
    private ButtonField saveButton;

    public IdentityConfigScreen(IdentityConfig identityConfig) {
        super("LogicMail - " + AbstractConfigScreen.resources.getString(56));
        this.identityConfig = identityConfig;
        this.configSaved = false;
        this.initFields();
    }

    private void initFields() {
        this.identityNameField = new BasicEditField(AbstractConfigScreen.resources.getString(57) + " ", this.identityConfig.getIdentityName());
        this.fullNameField = new BasicEditField(AbstractConfigScreen.resources.getString(58) + " ", this.identityConfig.getFullName());
        this.emailAddressField = new EmailAddressEditField(AbstractConfigScreen.resources.getString(59) + " ", this.identityConfig.getEmailAddress());
        this.replyToAddressField = new EmailAddressEditField(AbstractConfigScreen.resources.getString(60) + " ", this.identityConfig.getReplyToAddress());
        this.msgSignatureField = new AutoTextEditField();
        this.msgSignatureField.setText(this.identityConfig.getMsgSignature());
        this.saveButton = new ButtonField(AbstractConfigScreen.resources.getString(28), 0x300000000L);
        this.saveButton.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                IdentityConfigScreen.this.saveButton_FieldChanged(field, context);
            }
        });
        this.add((Field)this.identityNameField);
        this.add((Field)new SeparatorField());
        this.add((Field)this.fullNameField);
        this.add((Field)this.emailAddressField);
        this.add((Field)this.replyToAddressField);
        this.add((Field)new SeparatorField());
        this.add((Field)new RichTextField(AbstractConfigScreen.resources.getString(148), 0x80000000000000L));
        this.add((Field)this.msgSignatureField);
        this.add((Field)new SeparatorField());
        this.add((Field)this.saveButton);
    }

    private void saveButton_FieldChanged(Field field, int context) {
        field.setDirty(false);
        this.onClose();
    }

    protected boolean onSavePrompt() {
        if (this.identityNameField.getText().length() > 0 && this.emailAddressField.getText().length() > 0) {
            return super.onSavePrompt();
        }
        int result = Dialog.ask((String)AbstractConfigScreen.resources.getString(36), (Object[])new String[]{AbstractConfigScreen.resources.getString(37), AbstractConfigScreen.resources.getString(38)}, (int)0);
        return result == 0;
    }

    public void save() {
        this.identityConfig.setIdentityName(this.identityNameField.getText());
        this.identityConfig.setFullName(this.fullNameField.getText());
        this.identityConfig.setEmailAddress(this.emailAddressField.getText());
        this.identityConfig.setReplyToAddress(this.replyToAddressField.getText());
        this.identityConfig.setMsgSignature(this.msgSignatureField.getText());
        this.configSaved = true;
    }

    public boolean configSaved() {
        return this.configSaved;
    }
}

