/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.AccountNodeEvent;
import org.logicprobe.LogicMail.model.AccountNodeListener;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailManagerEvent;
import org.logicprobe.LogicMail.model.MailManagerListener;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MailboxNodeEvent;
import org.logicprobe.LogicMail.model.MailboxNodeListener;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.ui.MailHomeListener;
import org.logicprobe.LogicMail.ui.MailHomeView;
import org.logicprobe.LogicMail.ui.NavigationController;

public class MailHomePresenter {
    private NavigationController navigationController;
    private MailRootNode mailRootNode;
    private MailHomeView mailHomeView;
    private MailManager mailManager;
    private Hashtable accountTreeNodeMap;
    private Hashtable mailboxTreeNodeMap;
    private boolean firstVisible;
    private MailHomeView.TreeNode mailTreeRootNode;
    private MailManagerListener mailManagerListener;
    private AccountNodeListener accountNodeListener;
    private MailboxNodeListener mailboxNodeListener;

    public MailHomePresenter(NavigationController navigationController, MailRootNode mailRootNode, MailHomeView mailHomeView) {
        this.navigationController = navigationController;
        this.mailRootNode = mailRootNode;
        this.mailHomeView = mailHomeView;
        this.mailManager = MailManager.getInstance();
        this.accountTreeNodeMap = new Hashtable();
        this.mailboxTreeNodeMap = new Hashtable();
        this.mailManagerListener = new MailManagerListener(){

            public void mailConfigurationChanged(MailManagerEvent e) {
                MailHomePresenter.this.mailManager_MailConfigurationChanged(e);
            }
        };
        this.accountNodeListener = new AccountNodeListener(){

            public void accountStatusChanged(AccountNodeEvent e) {
                MailHomePresenter.this.accountNodeListener_AccountStatusChanged(e);
            }
        };
        this.mailboxNodeListener = new MailboxNodeListener(){

            public void mailboxStatusChanged(MailboxNodeEvent e) {
                MailHomePresenter.this.mailboxNodeListener_MailboxStatusChanged(e);
            }
        };
        this.mailHomeView.setMailHomeListener(new MailHomeListener(){

            public int getContextMenuItems(Object activeField) {
                return MailHomePresenter.this.mailHome_GetContextMenuItems((MailHomeView.TreeNode)activeField);
            }

            public void handleContextMenuItem(int menuItem, Object activeField) {
                switch (menuItem) {
                    case 1: {
                        MailHomePresenter.this.mailHome_OpenNode((MailHomeView.TreeNode)activeField);
                        break;
                    }
                    case 2: {
                        MailHomePresenter.this.mailHome_RefreshNodeStatus((MailHomeView.TreeNode)activeField);
                        break;
                    }
                    case 4: {
                        MailHomePresenter.this.mailHome_RefreshNodeFolders((MailHomeView.TreeNode)activeField);
                        break;
                    }
                    case 8: {
                        MailHomePresenter.this.mailHome_ComposeMessage((MailHomeView.TreeNode)activeField);
                        break;
                    }
                    case 16: {
                        MailHomePresenter.this.mailHome_DisconnectNodeAccount((MailHomeView.TreeNode)activeField);
                    }
                }
            }

            public void handleVisibilityChange(boolean visible) {
                MailHomePresenter.this.mailHome_HandleVisibilityChange(visible);
            }
        });
    }

    public void initialize() {
        this.refreshMailTree();
        this.mailManager.addMailManagerListener(this.mailManagerListener);
    }

    private void mailManager_MailConfigurationChanged(MailManagerEvent e) {
        this.refreshMailTree();
    }

    private void accountNodeListener_AccountStatusChanged(AccountNodeEvent e) {
        if (e.getType() == 0) {
            MailHomeView.TreeNode node = (MailHomeView.TreeNode)this.accountTreeNodeMap.get(e.getSource());
            if (node != null) {
                this.mailHomeView.refreshMailTreeNode(node);
            }
        } else if (e.getType() == 1) {
            this.refreshAccountFolders((AccountNode)e.getSource());
        }
    }

    private void mailboxNodeListener_MailboxStatusChanged(MailboxNodeEvent e) {
        MailHomeView.TreeNode mailboxTreeNode = (MailHomeView.TreeNode)this.mailboxTreeNodeMap.get(e.getSource());
        if (mailboxTreeNode != null) {
            this.mailHomeView.refreshMailTreeNode(mailboxTreeNode);
        }
    }

    private void refreshMailTree() {
        this.clearMailTreeSubscriptions();
        this.generateMailTree();
        this.mailHomeView.populateMailTree(this.mailTreeRootNode);
    }

    private void generateMailTree() {
        this.mailTreeRootNode = new MailHomeView.TreeNode(null, 0);
        AccountNode[] accounts = this.mailRootNode.getAccounts();
        this.mailTreeRootNode.children = new MailHomeView.TreeNode[accounts.length];
        for (int i = 0; i < accounts.length; ++i) {
            MailHomeView.TreeNode accountTreeNode = new MailHomeView.TreeNode(accounts[i], 1);
            MailboxNode rootMailbox = accounts[i].getRootMailbox();
            if (rootMailbox != null) {
                MailboxNode[] mailboxNodes = rootMailbox.getMailboxes();
                accountTreeNode.children = new MailHomeView.TreeNode[mailboxNodes.length];
                for (int j = 0; j < mailboxNodes.length; ++j) {
                    accountTreeNode.children[j] = this.populateMailboxTreeNode(mailboxNodes[j]);
                }
            }
            accounts[i].addAccountNodeListener(this.accountNodeListener);
            this.accountTreeNodeMap.put(accounts[i], accountTreeNode);
            this.mailTreeRootNode.children[i] = accountTreeNode;
        }
    }

    private MailHomeView.TreeNode populateMailboxTreeNode(MailboxNode mailboxNode) {
        MailHomeView.TreeNode mailboxTreeNode = new MailHomeView.TreeNode(mailboxNode, 2);
        mailboxNode.addMailboxNodeListener(this.mailboxNodeListener);
        this.mailboxTreeNodeMap.put(mailboxNode, mailboxTreeNode);
        MailboxNode[] mailboxes = mailboxNode.getMailboxes();
        mailboxTreeNode.children = new MailHomeView.TreeNode[mailboxes.length];
        for (int i = 0; i < mailboxes.length; ++i) {
            mailboxTreeNode.children[i] = this.populateMailboxTreeNode(mailboxes[i]);
        }
        return mailboxTreeNode;
    }

    private void clearMailTreeSubscriptions() {
        Node node;
        Enumeration e = this.accountTreeNodeMap.keys();
        while (e.hasMoreElements()) {
            node = (AccountNode)e.nextElement();
            ((AccountNode)node).removeAccountNodeListener(this.accountNodeListener);
        }
        this.accountTreeNodeMap.clear();
        e = this.mailboxTreeNodeMap.keys();
        while (e.hasMoreElements()) {
            node = (MailboxNode)e.nextElement();
            ((MailboxNode)node).removeMailboxNodeListener(this.mailboxNodeListener);
        }
        this.mailboxTreeNodeMap.clear();
    }

    private void refreshAccountFolders(AccountNode accountNode) {
        Vector mailboxNodeList = new Vector();
        MailHomeView.TreeNode accountTreeNode = (MailHomeView.TreeNode)this.accountTreeNodeMap.get(accountNode);
        MailHomePresenter.getMailboxNodes(mailboxNodeList, accountTreeNode);
        int size = mailboxNodeList.size();
        for (int i = 0; i < size; ++i) {
            MailboxNode mailboxNode = (MailboxNode)mailboxNodeList.elementAt(i);
            if (!this.mailboxTreeNodeMap.containsKey(mailboxNode)) continue;
            mailboxNode.removeMailboxNodeListener(this.mailboxNodeListener);
            this.mailboxTreeNodeMap.remove(mailboxNode);
        }
        MailboxNode rootMailbox = accountNode.getRootMailbox();
        if (rootMailbox != null) {
            MailboxNode[] mailboxNodes = rootMailbox.getMailboxes();
            accountTreeNode.children = new MailHomeView.TreeNode[mailboxNodes.length];
            for (int i = 0; i < mailboxNodes.length; ++i) {
                accountTreeNode.children[i] = this.populateMailboxTreeNode(mailboxNodes[i]);
            }
        }
        this.mailHomeView.populateMailTree(this.mailTreeRootNode);
    }

    private static void getMailboxNodes(Vector result, MailHomeView.TreeNode treeNode) {
        if (treeNode.node instanceof MailboxNode) {
            result.addElement(treeNode.node);
        }
        if (treeNode.children != null) {
            for (int i = 0; i < treeNode.children.length; ++i) {
                MailHomePresenter.getMailboxNodes(result, treeNode.children[i]);
            }
        }
    }

    private void mailHome_HandleVisibilityChange(boolean visible) {
        if (visible && this.firstVisible) {
            this.firstVisible = false;
            if (this.mailRootNode.getAccounts().length <= 1) {
                this.navigationController.displayAccountConfigurationWizard();
            }
        }
    }

    private boolean mailHome_OpenNode(MailHomeView.TreeNode treeNode) {
        if (treeNode.node instanceof MailboxNode) {
            MailboxNode mailboxNode = (MailboxNode)treeNode.node;
            this.navigationController.displayMailbox(mailboxNode);
            return true;
        }
        return false;
    }

    private void mailHome_RefreshNodeStatus(MailHomeView.TreeNode treeNode) {
        AccountNode accountNode = MailHomePresenter.getAccountForTreeNode(treeNode);
        if (accountNode != null) {
            accountNode.refreshMailboxStatus();
        }
    }

    private void mailHome_RefreshNodeFolders(MailHomeView.TreeNode treeNode) {
        AccountNode accountNode = MailHomePresenter.getAccountForTreeNode(treeNode);
        if (accountNode != null) {
            accountNode.refreshMailboxes();
        }
    }

    private void mailHome_DisconnectNodeAccount(MailHomeView.TreeNode treeNode) {
        AccountNode accountNode = MailHomePresenter.getAccountForTreeNode(treeNode);
        if (accountNode != null) {
            accountNode.requestDisconnect(false);
        }
    }

    private void mailHome_ComposeMessage(MailHomeView.TreeNode treeNode) {
        AccountNode accountNode = MailHomePresenter.getAccountForTreeNode(treeNode);
        if (accountNode != null) {
            this.navigationController.displayComposition(accountNode);
        }
    }

    private int mailHome_GetContextMenuItems(MailHomeView.TreeNode treeNode) {
        int menuItems = 0;
        if (treeNode.node instanceof MailboxNode) {
            menuItems |= 1;
            menuItems |= 8;
        } else if (treeNode.node instanceof AccountNode) {
            AccountNode accountNode = (AccountNode)treeNode.node;
            if (accountNode.getRootMailbox() != null) {
                menuItems |= 2;
            }
            if (accountNode.hasFolders()) {
                menuItems |= 4;
            }
            if (accountNode.hasMailSender()) {
                menuItems |= 8;
            }
            if (accountNode.getStatus() == 2) {
                menuItems |= 0x10;
            }
        }
        return menuItems;
    }

    private static AccountNode getAccountForTreeNode(MailHomeView.TreeNode treeNode) {
        AccountNode accountNode;
        if (treeNode.node instanceof AccountNode) {
            accountNode = (AccountNode)treeNode.node;
        } else if (treeNode.node instanceof MailboxNode) {
            MailboxNode mailboxNode = (MailboxNode)treeNode.node;
            accountNode = mailboxNode.getParentAccount();
        } else {
            accountNode = null;
        }
        return accountNode;
    }
}

