/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Hashtable;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.RichTextField;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.message.ContentPart;
import org.logicprobe.LogicMail.message.ImageContent;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.TextContent;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.ui.BrowserFieldRenderer;
import org.logicprobe.LogicMail.util.UnicodeNormalizer;

public class MessageFieldFactory {
    private static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private static Hashtable createdBrowserFields = new Hashtable();

    public static Field createMessageField(MessageNode messageNode, MimeMessageContent content) {
        Field field = content instanceof TextContent ? MessageFieldFactory.createTextMessageField(messageNode, (TextContent)content) : (content instanceof ImageContent ? MessageFieldFactory.createImageMessageField((ImageContent)content) : MessageFieldFactory.createUnsupportedMessageField(content));
        return field;
    }

    private static Field createTextMessageField(MessageNode messageNode, TextContent content) {
        TextPart part = (TextPart)content.getMessagePart();
        if (part.getMimeSubtype().equalsIgnoreCase("html")) {
            return MessageFieldFactory.createBrowserField(messageNode, content);
        }
        return new RichTextField(MessageFieldFactory.getNormalizedText(content));
    }

    private static String getNormalizedText(TextContent content) {
        if (MailSettings.getInstance().getGlobalConfig().getUnicodeNormalization()) {
            String text = content.getText();
            if (((TextPart)content.getMessagePart()).getEncoding().equalsIgnoreCase("quoted-printable")) {
                try {
                    byte[] encodedBytes = text.getBytes();
                    text = new String(encodedBytes, ((TextPart)content.getMessagePart()).getCharset());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return UnicodeNormalizer.getInstance().normalize(text);
        }
        return content.getText();
    }

    private static Field createImageMessageField(ImageContent content) {
        return new BitmapField(content.getImage().getBitmap());
    }

    private static Field createUnsupportedMessageField(MimeMessageContent content) {
        ContentPart part = content.getMessagePart();
        return new RichTextField(resources.getString(84) + ' ' + part.getMimeType() + '/' + part.getMimeSubtype());
    }

    private static Field createBrowserField(MessageNode messageNode, TextContent content) {
        BrowserFieldRenderer fieldRenderer = new BrowserFieldRenderer(messageNode, content);
        Field field = fieldRenderer.getBrowserField();
        if (field != null) {
            createdBrowserFields.put(field, fieldRenderer);
        }
        return field;
    }

    public static void handleRenderedField(Field field) {
        BrowserFieldRenderer fieldRenderer = (BrowserFieldRenderer)createdBrowserFields.get(field);
        if (fieldRenderer != null) {
            fieldRenderer.finishLoading();
            createdBrowserFields.remove(field);
        }
    }
}

