/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.system.Bitmap;
import org.logicprobe.LogicMail.message.ApplicationPart;
import org.logicprobe.LogicMail.message.AudioPart;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.MimeMessagePartVisitor;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.message.VideoPart;

public class MessageIcons {
    private static MessageIcons instance = new MessageIcons();
    private MessagePartIconVisitor visitor = new MessagePartIconVisitor();
    private Bitmap mimeImageBitmap;
    private Bitmap mimeTextBitmap;
    private Bitmap mimeAudioBitmap;
    private Bitmap mimeVideoBitmap;
    private Bitmap mimeApplicationBitmap;
    private Bitmap mimeMessageBitmap;

    private MessageIcons() {
    }

    public static Bitmap getIcon(MimeMessagePart mimeMessagePart) {
        return instance.getIconImpl(mimeMessagePart);
    }

    private Bitmap getIconImpl(MimeMessagePart mimeMessagePart) {
        this.visitor.clearIcon();
        mimeMessagePart.accept(this.visitor);
        return this.visitor.getIcon();
    }

    private class MessagePartIconVisitor
    implements MimeMessagePartVisitor {
        private Bitmap icon;

        private MessagePartIconVisitor() {
        }

        public void visitApplicationPart(ApplicationPart part) {
            if (this.icon != null) {
                return;
            }
            if (MessageIcons.this.mimeApplicationBitmap == null) {
                MessageIcons.this.mimeApplicationBitmap = Bitmap.getBitmapResource((String)"mime_application.png");
            }
            this.icon = MessageIcons.this.mimeApplicationBitmap;
        }

        public void visitAudioPart(AudioPart part) {
            if (this.icon != null) {
                return;
            }
            if (MessageIcons.this.mimeAudioBitmap == null) {
                MessageIcons.this.mimeAudioBitmap = Bitmap.getBitmapResource((String)"mime_audio.png");
            }
            this.icon = MessageIcons.this.mimeAudioBitmap;
        }

        public void visitImagePart(ImagePart part) {
            if (this.icon != null) {
                return;
            }
            if (MessageIcons.this.mimeImageBitmap == null) {
                MessageIcons.this.mimeImageBitmap = Bitmap.getBitmapResource((String)"mime_image.png");
            }
            this.icon = MessageIcons.this.mimeImageBitmap;
        }

        public void visitTextPart(TextPart part) {
            if (this.icon != null) {
                return;
            }
            if (MessageIcons.this.mimeTextBitmap == null) {
                MessageIcons.this.mimeTextBitmap = Bitmap.getBitmapResource((String)"mime_text.png");
            }
            this.icon = MessageIcons.this.mimeTextBitmap;
        }

        public void visitMessagePart(MessagePart part) {
            if (this.icon != null) {
                return;
            }
            if (MessageIcons.this.mimeMessageBitmap == null) {
                MessageIcons.this.mimeMessageBitmap = Bitmap.getBitmapResource((String)"mime_message.png");
            }
            this.icon = MessageIcons.this.mimeMessageBitmap;
        }

        public void visitMultiPart(MultiPart part) {
            if (this.icon != null) {
                return;
            }
        }

        public void visitVideoPart(VideoPart part) {
            if (MessageIcons.this.mimeVideoBitmap == null) {
                MessageIcons.this.mimeVideoBitmap = Bitmap.getBitmapResource((String)"mime_video.png");
            }
            this.icon = MessageIcons.this.mimeVideoBitmap;
        }

        public void visitUnsupportedPart(UnsupportedPart part) {
            this.visitApplicationPart(null);
        }

        public void clearIcon() {
            this.icon = null;
        }

        public Bitmap getIcon() {
            return this.icon;
        }
    }
}

