/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Timer;
import java.util.TimerTask;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import org.logicprobe.LogicMail.ui.ThrobberRenderer;

public class StatusBarField
extends Field {
    private int preferredHeight = Font.getDefault().getHeight() + 2;
    private String statusText;
    private ThrobberRenderer throbberRenderer = new ThrobberRenderer(this.preferredHeight);
    private Timer timer = new Timer();
    private TimerTask timerTask;

    public StatusBarField() {
        super(0x1000000000000000L);
    }

    protected void onDisplay() {
        super.onDisplay();
        this.timerTask = new AnimationTimerTask();
        this.timer.scheduleAtFixedRate(this.timerTask, 200L, 100L);
    }

    protected void onUndisplay() {
        this.timerTask.cancel();
        super.onUndisplay();
    }

    public void setStatusText(String statusText) {
        if (this.statusText != statusText) {
            this.statusText = statusText;
            this.invalidate();
        }
    }

    public String getStatusText() {
        return this.statusText;
    }

    public boolean hasStatus() {
        return this.statusText != null && this.statusText.length() > 0;
    }

    protected void layout(int width, int height) {
        this.setExtent(this.getPreferredWidth(), this.getPreferredHeight());
    }

    public int getPreferredWidth() {
        return Graphics.getScreenWidth();
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    protected void paint(Graphics graphics) {
        int width = this.getPreferredWidth();
        int throbberSize = this.throbberRenderer.getSize();
        int backgroundColor = graphics.getBackgroundColor();
        graphics.setBackgroundColor(0xD3D3D3);
        graphics.clear();
        graphics.drawRect(0, 0, width, this.preferredHeight);
        if (this.statusText != null && this.statusText.length() > 0) {
            graphics.drawText(this.statusText, 1, 1, 64, width - throbberSize - 2);
        }
        graphics.pushRegion(width - throbberSize, 0, throbberSize, throbberSize, 0, 0);
        this.throbberRenderer.paint(graphics);
        graphics.popContext();
        graphics.setBackgroundColor(backgroundColor);
    }

    private class AnimationTimerTask
    extends TimerTask {
        private AnimationTimerTask() {
        }

        public void run() {
            StatusBarField.this.throbberRenderer.nextPosition();
            StatusBarField.this.invalidate();
        }
    }
}

