/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Timer;
import java.util.TimerTask;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;
import org.logicprobe.LogicMail.ui.ThrobberRenderer;

public class ThrobberField
extends Field {
    private ThrobberRenderer throbberRenderer;
    private Timer timer;
    private TimerTask timerTask;

    public ThrobberField(int size) {
        this.throbberRenderer = new ThrobberRenderer(size);
        this.timer = new Timer();
    }

    public ThrobberField(int size, long style) {
        super(style);
        this.throbberRenderer = new ThrobberRenderer(size);
        this.timer = new Timer();
    }

    protected void onDisplay() {
        super.onDisplay();
        this.timerTask = new AnimationTimerTask();
        this.timer.scheduleAtFixedRate(this.timerTask, 200L, 100L);
    }

    protected void onUndisplay() {
        this.timerTask.cancel();
        super.onUndisplay();
    }

    protected void layout(int width, int height) {
        int size = this.throbberRenderer.getSize();
        this.setExtent(size, size);
    }

    protected void paint(Graphics graphics) {
        this.throbberRenderer.paint(graphics);
    }

    public int getPreferredWidth() {
        return this.throbberRenderer.getSize();
    }

    public int getPreferredHeight() {
        return this.throbberRenderer.getSize();
    }

    private class AnimationTimerTask
    extends TimerTask {
        private AnimationTimerTask() {
        }

        public void run() {
            ThrobberField.this.throbberRenderer.nextPosition();
            ThrobberField.this.invalidate();
        }
    }
}

