/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Graphics;

public class ThrobberRenderer {
    private static double PI_4 = 0.7853981633974483;
    private int size;
    private int sizeHalf;
    private int sizeDiv;
    private int radius;
    private int position = 0;
    private int[] cx;
    private int[] cy;

    public ThrobberRenderer(int size) {
        this.size = size;
        this.sizeHalf = size / 2;
        this.sizeDiv = size / 8;
        this.radius = size / 10;
        this.cx = new int[8];
        this.cy = new int[8];
        this.cx[0] = (this.sizeHalf - this.sizeDiv) / 2;
        this.cy[0] = this.sizeHalf;
        this.cx[1] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[1] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
        this.cx[2] = this.sizeHalf;
        this.cy[2] = (this.sizeHalf - this.sizeDiv) / 2;
        this.cx[3] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[3] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
        this.cx[4] = size - (this.sizeHalf - this.sizeDiv) / 2;
        this.cy[4] = this.sizeHalf;
        this.cx[5] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[5] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
        this.cx[6] = this.sizeHalf;
        this.cy[6] = size - (this.sizeHalf - this.sizeDiv) / 2;
        this.cx[7] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[7] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
    }

    public int getSize() {
        return this.size;
    }

    public void paint(Graphics graphics) {
        int color;
        int i;
        int index = 0;
        for (i = this.position; i >= 0; --i) {
            color = 31 * Math.min(6, index);
            graphics.setColor(color * 65536 + color * 256 + color);
            this.drawCircle(graphics, i);
            ++index;
        }
        for (i = 7; i > this.position; --i) {
            color = 31 * Math.min(6, index);
            graphics.setColor(color * 65536 + color * 256 + color);
            this.drawCircle(graphics, i);
            ++index;
        }
    }

    private void drawCircle(Graphics graphics, int index) {
        if (index < 0 || index > 7) {
            return;
        }
        graphics.fillArc(this.cx[index] - this.radius, this.cy[index] - this.radius, this.radius * 2, this.radius * 2, 0, 360);
    }

    public void resetPosition() {
        this.position = 0;
    }

    public void nextPosition() {
        this.position = this.position < 7 ? ++this.position : 0;
    }
}

