/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.file.FileSystemRegistry;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializableHashtable;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class GlobalConfig
implements Serializable {
    private long uniqueId;
    public static final int WIFI_DISABLED = 0;
    public static final int WIFI_PROMPT = 1;
    public static final int WIFI_ALWAYS = 2;
    public static final int MESSAGE_DISPLAY_PLAIN_TEXT = 0;
    public static final int MESSAGE_DISPLAY_HTML = 1;
    private String languageCode;
    private boolean unicodeNormalization;
    private int messageDisplayFormat;
    private int retMsgCount;
    private boolean dispOrder;
    private String localDataLocation;
    private int wifiMode;
    private boolean connDebug;
    private boolean hideDeletedMsg;
    private String localHostname;

    public GlobalConfig() {
        this.setDefaults();
    }

    public GlobalConfig(DataInputStream input) {
        try {
            this.deserialize(input);
        }
        catch (IOException ex) {
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
        this.languageCode = "";
        this.unicodeNormalization = false;
        this.messageDisplayFormat = 0;
        this.retMsgCount = 30;
        this.dispOrder = false;
        this.wifiMode = 0;
        this.hideDeletedMsg = true;
        this.localHostname = "";
        Enumeration e = FileSystemRegistry.listRoots();
        this.localDataLocation = e.hasMoreElements() ? "file:///" + (String)e.nextElement() + "LogicMail/" : "file:///LogicMail/";
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setUnicodeNormalization(boolean unicodeNormalization) {
        this.unicodeNormalization = unicodeNormalization;
    }

    public boolean getUnicodeNormalization() {
        return this.unicodeNormalization;
    }

    public void setMessageDisplayFormat(int messageDisplayFormat) {
        this.messageDisplayFormat = messageDisplayFormat;
    }

    public int getMessageDisplayFormat() {
        return this.messageDisplayFormat;
    }

    public void setRetMsgCount(int retMsgCount) {
        this.retMsgCount = retMsgCount;
    }

    public int getRetMsgCount() {
        return this.retMsgCount;
    }

    public void setDispOrder(boolean dispOrder) {
        this.dispOrder = dispOrder;
    }

    public boolean getDispOrder() {
        return this.dispOrder;
    }

    public void setLocalDataLocation(String localDataLocation) {
        this.localDataLocation = localDataLocation;
    }

    public String getLocalDataLocation() {
        return this.localDataLocation;
    }

    public int getWifiMode() {
        return this.wifiMode;
    }

    public void setWifiMode(int wifiMode) {
        this.wifiMode = wifiMode;
    }

    public boolean getConnDebug() {
        return this.connDebug;
    }

    public void setConnDebug(boolean connDebug) {
        this.connDebug = connDebug;
    }

    public boolean getHideDeletedMsg() {
        return this.hideDeletedMsg;
    }

    public void setHideDeletedMsg(boolean hideDeletedMsg) {
        this.hideDeletedMsg = hideDeletedMsg;
    }

    public String getLocalHostname() {
        return this.localHostname;
    }

    public void setLocalHostname(String localHostname) {
        this.localHostname = localHostname;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        SerializableHashtable table = new SerializableHashtable();
        table.put("global_languageCode", this.languageCode);
        table.put("global_unicodeNormalization", new Boolean(this.unicodeNormalization));
        table.put("global_messageDisplayFormat", new Integer(this.messageDisplayFormat));
        table.put("global_retMsgCount", new Integer(this.retMsgCount));
        table.put("global_dispOrder", new Boolean(this.dispOrder));
        table.put("global_localDataLocation", this.localDataLocation);
        table.put("global_wifiMode", new Integer(this.wifiMode));
        table.put("global_connDebug", new Boolean(this.connDebug));
        table.put("global_hideDeletedMsg", new Boolean(this.hideDeletedMsg));
        table.put("global_localHostname", this.localHostname);
        table.serialize(output);
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.setDefaults();
        this.uniqueId = input.readLong();
        SerializableHashtable table = new SerializableHashtable();
        table.deserialize(input);
        Object value = table.get("global_languageCode");
        if (value != null && value instanceof String) {
            this.languageCode = (String)value;
        }
        if ((value = table.get("global_unicodeNormalization")) != null && value instanceof Boolean) {
            this.unicodeNormalization = (Boolean)value;
        }
        if ((value = table.get("global_messageDisplayFormat")) != null && value instanceof Integer) {
            this.messageDisplayFormat = (Integer)value;
        }
        if ((value = table.get("global_retMsgCount")) != null && value instanceof Integer) {
            this.retMsgCount = (Integer)value;
        }
        if ((value = table.get("global_dispOrder")) != null && value instanceof Boolean) {
            this.dispOrder = (Boolean)value;
        }
        if ((value = table.get("global_localDataLocation")) != null && value instanceof String) {
            this.localDataLocation = (String)value;
        }
        if ((value = table.get("global_wifiMode")) != null && value instanceof Integer) {
            this.wifiMode = (Integer)value;
            if (this.wifiMode < 0 || this.wifiMode > 2) {
                this.wifiMode = 0;
            }
        }
        if ((value = table.get("global_connDebug")) != null && value instanceof Boolean) {
            this.connDebug = (Boolean)value;
        }
        if ((value = table.get("global_hideDeletedMsg")) != null && value instanceof Boolean) {
            this.hideDeletedMsg = (Boolean)value;
        }
        if ((value = table.get("global_localHostname")) != null && value instanceof String) {
            this.localHostname = (String)value;
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }
}

