/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.IOException;
import java.util.Vector;
import net.rim.device.api.system.UnsupportedOperationException;
import org.logicprobe.LogicMail.mail.AbstractMailConnectionHandler;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailConnectionHandlerListener;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.mail.imap.ImapClient;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.util.Queue;

public class IncomingMailConnectionHandler
extends AbstractMailConnectionHandler {
    private IncomingMailClient incomingClient;
    public static final int REQUEST_FOLDER_TREE = 10;
    public static final int REQUEST_FOLDER_STATUS = 11;
    public static final int REQUEST_FOLDER_MESSAGES_RANGE = 12;
    public static final int REQUEST_FOLDER_MESSAGES_SET = 13;
    public static final int REQUEST_FOLDER_MESSAGES_RECENT = 14;
    public static final int REQUEST_MESSAGE = 20;
    public static final int REQUEST_MESSAGE_PARTS = 21;
    public static final int REQUEST_MESSAGE_DELETE = 22;
    public static final int REQUEST_MESSAGE_UNDELETE = 23;
    public static final int REQUEST_MESSAGE_ANSWERED = 24;
    public static final int REQUEST_MESSAGE_APPEND = 25;
    private static final int IDLE_TIMEOUT = 300000;
    private static final int IDLE_POLL_INTERVAL = 500;

    public IncomingMailConnectionHandler(IncomingMailClient client) {
        super(client);
        this.incomingClient = client;
    }

    protected void handleRequest(int type, Object[] params) throws IOException, MailException {
        switch (type) {
            case 10: {
                this.handleRequestFolderTree();
                break;
            }
            case 11: {
                this.handleRequestFolderStatus((FolderTreeItem[])params[0]);
                break;
            }
            case 12: {
                this.handleRequestFolderMessagesRange((FolderTreeItem)params[0], (Integer)params[1], (Integer)params[2]);
                break;
            }
            case 13: {
                this.handleRequestFolderMessagesSet((FolderTreeItem)params[0], (int[])params[1]);
                break;
            }
            case 14: {
                this.handleRequestFolderMessagesRecent((FolderTreeItem)params[0]);
                break;
            }
            case 20: {
                this.handleRequestMessage((MessageToken)params[0]);
                break;
            }
            case 21: {
                this.handleRequestMessageParts((MessageToken)params[0], (MimeMessagePart[])params[1]);
                break;
            }
            case 22: {
                this.handleRequestMessageDelete((MessageToken)params[0], (MessageFlags)params[1]);
                break;
            }
            case 23: {
                this.handleRequestMessageUndelete((MessageToken)params[0], (MessageFlags)params[1]);
                break;
            }
            case 24: {
                this.handleRequestMessageAnswered((MessageToken)params[0], (MessageFlags)params[1]);
                break;
            }
            case 25: {
                this.handleRequestMessageAppend((FolderTreeItem)params[0], (String)params[1], (MessageFlags)params[2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBeginIdle() throws IOException, MailException {
        if (this.incomingClient.hasIdle()) {
            this.incomingClient.idleModeBegin();
            boolean endIdle = false;
            int idleTime = 0;
            while (!endIdle) {
                Queue requestQueue;
                this.sleepConnectionThread(500L);
                idleTime += 500;
                if (this.incomingClient.idleModePoll()) {
                    this.addRequest(14, new Object[]{this.incomingClient.getActiveFolder()});
                    endIdle = true;
                    continue;
                }
                if (this.getShutdownInProgress()) {
                    endIdle = true;
                    continue;
                }
                if (idleTime >= 300000) {
                    endIdle = true;
                    continue;
                }
                Queue queue = requestQueue = this.getRequestQueue();
                synchronized (queue) {
                    if (requestQueue.element() != null) {
                        endIdle = true;
                    }
                }
            }
            this.incomingClient.idleModeEnd();
            if (idleTime >= 300000) {
                if (this.incomingClient.noop()) {
                    this.addRequest(14, new Object[]{this.incomingClient.getActiveFolder()});
                } else {
                    FolderTreeItem inboxMailbox = this.incomingClient.getInboxFolder();
                    FolderTreeItem activeMailbox = this.incomingClient.getActiveFolder();
                    if (inboxMailbox != null && !inboxMailbox.getPath().equalsIgnoreCase(activeMailbox.getPath())) {
                        this.incomingClient.setActiveFolder(inboxMailbox);
                    }
                }
            }
        } else {
            Queue requestQueue;
            Queue queue = requestQueue = this.getRequestQueue();
            synchronized (queue) {
                if (requestQueue.element() != null) {
                    return;
                }
                try {
                    requestQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void handleRequestFolderTree() throws IOException, MailException {
        String message = AbstractMailConnectionHandler.resources.getString(164);
        this.showStatus(message);
        FolderTreeItem root = this.incomingClient.getFolderTree(this.getProgressHandler(message));
        MailConnectionHandlerListener listener = this.getListener();
        if (root != null && listener != null) {
            listener.mailConnectionRequestComplete(10, root);
        }
    }

    private void handleRequestFolderStatus(FolderTreeItem[] folders) throws IOException, MailException {
        String message = AbstractMailConnectionHandler.resources.getString(165);
        this.showStatus(message);
        this.incomingClient.refreshFolderStatus(folders, this.getProgressHandler(message));
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(11, folders);
        }
    }

    private void handleRequestFolderMessagesRange(FolderTreeItem folder, int firstIndex, int lastIndex) throws IOException, MailException {
        String message = AbstractMailConnectionHandler.resources.getString(166);
        this.showStatus(message + "...");
        this.checkActiveFolder(folder);
        FolderMessage[] messages = this.incomingClient.getFolderMessages(firstIndex, lastIndex, this.getProgressHandler(message));
        MailConnectionHandlerListener listener = this.getListener();
        if (messages != null && messages.length > 0 && listener != null) {
            listener.mailConnectionRequestComplete(12, new Object[]{folder, messages});
        }
    }

    private void handleRequestFolderMessagesSet(FolderTreeItem folder, int[] indices) throws IOException, MailException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void handleRequestFolderMessagesRecent(FolderTreeItem folder) throws IOException, MailException {
        String message = AbstractMailConnectionHandler.resources.getString(166);
        this.showStatus(message + "...");
        this.checkActiveFolder(folder);
        FolderMessage[] messages = this.incomingClient.getNewFolderMessages(this.getProgressHandler(message));
        MailConnectionHandlerListener listener = this.getListener();
        if (messages != null && messages.length > 0 && listener != null) {
            listener.mailConnectionRequestComplete(14, new Object[]{folder, messages});
        }
    }

    private void handleRequestMessage(MessageToken messageToken) throws IOException, MailException {
        String statusMessage = AbstractMailConnectionHandler.resources.getString(167);
        this.showStatus(statusMessage);
        this.checkActiveFolder(messageToken);
        Message message = this.incomingClient.getMessage(messageToken, this.getProgressHandler(statusMessage));
        MailConnectionHandlerListener listener = this.getListener();
        if (message != null && listener != null) {
            listener.mailConnectionRequestComplete(20, new Object[]{messageToken, message.getStructure(), message.getAllContent()});
        }
    }

    private void handleRequestMessageParts(MessageToken messageToken, MimeMessagePart[] messageParts) throws IOException, MailException {
        Object[] messageContent;
        String statusMessage = AbstractMailConnectionHandler.resources.getString(167);
        this.showStatus(statusMessage);
        this.checkActiveFolder(messageToken);
        if (this.incomingClient instanceof ImapClient) {
            Vector<MimeMessageContent> messageContentVector = new Vector<MimeMessageContent>();
            for (int i = 0; i < messageParts.length; ++i) {
                MimeMessageContent content = ((ImapClient)this.incomingClient).getMessagePart(messageToken, messageParts[i], this.getProgressHandler(statusMessage));
                if (content == null) continue;
                messageContentVector.addElement(content);
            }
            messageContent = new MimeMessageContent[messageContentVector.size()];
            messageContentVector.copyInto(messageContent);
        } else {
            messageContent = null;
        }
        MailConnectionHandlerListener listener = this.getListener();
        if (messageContent != null && listener != null) {
            listener.mailConnectionRequestComplete(21, new Object[]{messageToken, messageContent});
        }
    }

    private void handleRequestMessageDelete(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        this.showStatus(AbstractMailConnectionHandler.resources.getString(168));
        this.checkActiveFolder(messageToken);
        this.incomingClient.deleteMessage(messageToken, messageFlags);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(22, new Object[]{messageToken, messageFlags});
        }
    }

    private void handleRequestMessageUndelete(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        this.showStatus(AbstractMailConnectionHandler.resources.getString(169));
        this.checkActiveFolder(messageToken);
        this.incomingClient.undeleteMessage(messageToken, messageFlags);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(23, new Object[]{messageToken, messageFlags});
        }
    }

    private void handleRequestMessageAnswered(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        this.showStatus(AbstractMailConnectionHandler.resources.getString(170));
        if (this.incomingClient instanceof ImapClient) {
            ((ImapClient)this.incomingClient).messageAnswered(messageToken, messageFlags);
        }
        messageFlags.setAnswered(true);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(24, new Object[]{messageToken, messageFlags});
        }
    }

    private void handleRequestMessageAppend(FolderTreeItem folder, String rawMessage, MessageFlags initialFlags) throws IOException, MailException {
        MailConnectionHandlerListener listener;
        this.showStatus(AbstractMailConnectionHandler.resources.getString(171));
        if (this.incomingClient instanceof ImapClient) {
            ((ImapClient)this.incomingClient).appendMessage(folder, rawMessage, initialFlags);
        }
        if ((listener = this.getListener()) != null) {
            listener.mailConnectionRequestComplete(25, new Object[]{folder, null});
        }
    }

    private void checkActiveFolder(FolderTreeItem requestFolder) throws IOException, MailException {
        if (this.incomingClient.getActiveFolder() == null || !this.incomingClient.getActiveFolder().getPath().equals(requestFolder.getPath())) {
            this.incomingClient.setActiveFolder(requestFolder);
        }
    }

    private void checkActiveFolder(MessageToken messageToken) throws IOException, MailException {
        this.incomingClient.setActiveFolder(messageToken);
    }
}

