/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.util.Hashtable;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.ImapConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.conf.PopConfig;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.mail.imap.ImapClient;
import org.logicprobe.LogicMail.mail.pop.PopClient;
import org.logicprobe.LogicMail.mail.smtp.SmtpClient;

public class MailClientFactory {
    private static Hashtable incomingClientTable = new Hashtable();
    private static Hashtable outgoingClientTable = new Hashtable();

    private MailClientFactory() {
    }

    public static IncomingMailClient createMailClient(AccountConfig acctConfig) {
        IncomingMailClient client = (IncomingMailClient)incomingClientTable.get(acctConfig);
        if (client == null) {
            GlobalConfig globalConfig = MailSettings.getInstance().getGlobalConfig();
            if (acctConfig instanceof PopConfig) {
                client = new PopClient(globalConfig, (PopConfig)acctConfig);
                incomingClientTable.put(acctConfig, client);
            } else if (acctConfig instanceof ImapConfig) {
                client = new ImapClient(globalConfig, (ImapConfig)acctConfig);
                incomingClientTable.put(acctConfig, client);
            }
        }
        return client;
    }

    static void setIncomingMailClient(AccountConfig acctConfig, IncomingMailClient client) {
        incomingClientTable.put(acctConfig, client);
    }

    public static OutgoingMailClient createOutgoingMailClient(OutgoingConfig outgoingConfig) {
        OutgoingMailClient client = null;
        if (outgoingConfig != null && (client = (OutgoingMailClient)outgoingClientTable.get(outgoingConfig)) == null) {
            GlobalConfig globalConfig = MailSettings.getInstance().getGlobalConfig();
            client = new SmtpClient(globalConfig, outgoingConfig);
            outgoingClientTable.put(outgoingConfig, client);
        }
        return client;
    }

    static void setOutgoingMailClient(OutgoingConfig outgoingConfig, OutgoingMailClient client) {
        outgoingClientTable.put(outgoingConfig, client);
    }
}

