/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.mail.AbstractMailSender;
import org.logicprobe.LogicMail.mail.MailClientFactory;
import org.logicprobe.LogicMail.mail.MailConnectionHandlerListener;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.mail.OutgoingMailConnectionHandler;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;

public class NetworkMailSender
extends AbstractMailSender {
    private OutgoingMailClient client;
    private OutgoingMailConnectionHandler connectionHandler;
    private OutgoingConfig outgoingConfig;

    public NetworkMailSender(OutgoingConfig outgoingConfig) {
        this.client = MailClientFactory.createOutgoingMailClient(outgoingConfig);
        this.outgoingConfig = outgoingConfig;
        this.connectionHandler = new OutgoingMailConnectionHandler(this.client);
        this.connectionHandler.setListener(new MailConnectionHandlerListener(){

            public void mailConnectionRequestComplete(int type, Object result) {
                NetworkMailSender.this.connectionHandler_mailConnectionRequestComplete(type, result);
            }
        });
        this.connectionHandler.start();
    }

    public OutgoingConfig getOutgoingConfig() {
        return this.outgoingConfig;
    }

    public void shutdown(boolean wait) {
        this.connectionHandler.shutdown(wait);
    }

    public void restart() {
        if (!this.connectionHandler.isRunning()) {
            this.connectionHandler.start();
        }
    }

    public void requestSendMessage(MessageEnvelope envelope, Message message) {
        this.connectionHandler.addRequest(10, new Object[]{envelope, message});
    }

    private void connectionHandler_mailConnectionRequestComplete(int type, Object result) {
        switch (type) {
            case 10: {
                Object[] results = (Object[])result;
                this.fireMessageSent((MessageEnvelope)results[0], (Message)results[1], (String)results[2]);
            }
        }
    }
}

