/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.logicprobe.LogicMail.mail.AbstractMailConnectionHandler;
import org.logicprobe.LogicMail.mail.MailConnectionHandlerListener;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.util.Queue;

public class OutgoingMailConnectionHandler
extends AbstractMailConnectionHandler {
    private OutgoingMailClient outgoingClient;
    private Timer connectionTimer = null;
    private static final int CONNECTION_TIMEOUT = 120000;
    public static final int REQUEST_SEND_MESSAGE = 10;
    private TimerTask connectionTimerTask;

    public OutgoingMailConnectionHandler(OutgoingMailClient client) {
        super(client);
        this.outgoingClient = client;
        this.connectionTimer = new Timer();
    }

    protected void handleRequest(int type, Object[] params) throws IOException, MailException {
        if (this.connectionTimerTask != null) {
            this.connectionTimerTask.cancel();
            this.connectionTimerTask = null;
        }
        switch (type) {
            case 10: {
                this.handleRequestSendMessage((MessageEnvelope)params[0], (Message)params[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBeginIdle() {
        Queue requestQueue;
        if (this.connectionTimerTask != null) {
            this.connectionTimerTask.cancel();
            this.connectionTimerTask = null;
        }
        this.connectionTimerTask = new ConnectionTimerTask();
        this.connectionTimer.schedule(this.connectionTimerTask, 120000L);
        Queue queue = requestQueue = this.getRequestQueue();
        synchronized (queue) {
            if (requestQueue.element() != null) {
                return;
            }
            try {
                requestQueue.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void handleBeforeClosing() {
        if (this.connectionTimerTask != null) {
            this.connectionTimerTask.cancel();
            this.connectionTimerTask = null;
        }
    }

    private void handleRequestSendMessage(MessageEnvelope envelope, Message message) throws IOException, MailException {
        this.showStatus(AbstractMailConnectionHandler.resources.getString(163));
        String messageSource = this.outgoingClient.sendMessage(envelope, message);
        MailConnectionHandlerListener listener = this.getListener();
        if (messageSource != null && messageSource.length() > 0 && listener != null) {
            listener.mailConnectionRequestComplete(10, new Object[]{envelope, message, messageSource});
        }
    }

    private class ConnectionTimerTask
    extends TimerTask {
        private ConnectionTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Queue requestQueue;
            Queue queue = requestQueue = OutgoingMailConnectionHandler.this.getRequestQueue();
            synchronized (queue) {
                OutgoingMailConnectionHandler.this.setConnectionState(5);
                requestQueue.notifyAll();
            }
        }
    }
}

