/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Vector;
import net.rim.device.api.system.EventLogger;
import org.logicprobe.LogicMail.mail.imap.ImapProtocol;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.util.StringParser;

class ImapParser {
    private static String strNIL = "NIL";
    private static final String MODIFIED_BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+,";

    private ImapParser() {
    }

    static ImapProtocol.MessageFlags parseMessageFlags(Vector flagsVec) {
        ImapProtocol.MessageFlags flags = new ImapProtocol.MessageFlags();
        int size = flagsVec.size();
        for (int i = 0; i < size; ++i) {
            if (!(flagsVec.elementAt(i) instanceof String)) continue;
            String text = (String)flagsVec.elementAt(i);
            if (text.equalsIgnoreCase("\\Seen")) {
                flags.seen = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Answered")) {
                flags.answered = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Flagged")) {
                flags.flagged = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Deleted")) {
                flags.deleted = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Draft")) {
                flags.draft = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Recent")) {
                flags.recent = true;
                continue;
            }
            if (!text.equalsIgnoreCase("Junk") && !text.equalsIgnoreCase("$Junk")) continue;
            flags.junk = true;
        }
        return flags;
    }

    static String createMessageFlagsString(ImapProtocol.MessageFlags flags) {
        StringBuffer buf = new StringBuffer();
        if (flags.seen) {
            buf.append("\\Seen");
        }
        if (flags.answered) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("\\Answered");
        }
        if (flags.flagged) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("\\Flagged");
        }
        if (flags.deleted) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("\\Deleted");
        }
        if (flags.draft) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("\\Draft");
        }
        if (flags.recent) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("\\Recent");
        }
        return buf.toString();
    }

    static MessageEnvelope parseMessageEnvelope(Vector parsedEnv) {
        if (parsedEnv.size() < 10) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapParser.parseMessageEnvelope: Sanity check failed".getBytes(), (int)3);
            return ImapParser.generateDummyEnvelope();
        }
        MessageEnvelope env = new MessageEnvelope();
        if (parsedEnv.elementAt(0) instanceof String) {
            try {
                env.date = StringParser.parseDateString((String)parsedEnv.elementAt(0));
            }
            catch (Exception e) {
                env.date = Calendar.getInstance().getTime();
            }
        }
        if (parsedEnv.elementAt(1) instanceof String) {
            String subject = (String)parsedEnv.elementAt(1);
            env.subject = subject.equals(strNIL) ? "" : StringParser.parseEncodedHeader(subject);
        }
        if (parsedEnv.elementAt(2) instanceof Vector) {
            env.from = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(2));
        }
        if (parsedEnv.elementAt(3) instanceof Vector) {
            env.sender = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(3));
        }
        if (parsedEnv.elementAt(4) instanceof Vector) {
            env.replyTo = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(4));
        }
        if (parsedEnv.elementAt(5) instanceof Vector) {
            env.to = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(5));
        }
        if (parsedEnv.elementAt(6) instanceof Vector) {
            env.cc = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(6));
        }
        if (parsedEnv.elementAt(7) instanceof Vector) {
            env.bcc = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(7));
        }
        if (parsedEnv.elementAt(8) instanceof String) {
            env.inReplyTo = (String)parsedEnv.elementAt(8);
            if (env.inReplyTo.equals(strNIL)) {
                env.inReplyTo = "";
            }
        }
        if (parsedEnv.elementAt(9) instanceof String) {
            env.messageId = (String)parsedEnv.elementAt(9);
            if (env.messageId.equals(strNIL)) {
                env.messageId = "";
            }
        }
        return env;
    }

    static String[] parseAddressList(Vector addrVec) {
        String[] addrList = new String[addrVec.size()];
        int index = 0;
        for (int i = 0; i < addrVec.size(); ++i) {
            if (!(addrVec.elementAt(i) instanceof Vector) || ((Vector)addrVec.elementAt(i)).size() < 4) continue;
            Vector entry = (Vector)addrVec.elementAt(i);
            String realName = strNIL;
            if (entry.elementAt(0) instanceof String) {
                realName = StringParser.parseEncodedHeader((String)entry.elementAt(0));
            }
            String mbName = strNIL;
            if (entry.elementAt(2) instanceof String) {
                mbName = (String)entry.elementAt(2);
            }
            String hostName = strNIL;
            if (entry.elementAt(3) instanceof String) {
                hostName = (String)entry.elementAt(3);
            }
            String addrStr = (mbName.equals(strNIL) ? "" : mbName) + (hostName.equals(strNIL) ? "" : '@' + hostName);
            addrList[index] = realName.length() > 0 && !realName.equals(strNIL) ? realName + " <" + addrStr + ">" : addrStr;
            ++index;
        }
        return addrList;
    }

    static MessageEnvelope generateDummyEnvelope() {
        MessageEnvelope env = new MessageEnvelope();
        env.date = Calendar.getInstance().getTime();
        env.from = new String[1];
        env.from[0] = "<sender>";
        env.subject = "<subject>";
        return env;
    }

    static MessageSection parseMessageStructure(String rawText) {
        Vector parsedText = null;
        try {
            parsedText = StringParser.nestedParenStringLexer(rawText.substring(rawText.indexOf(40)));
        }
        catch (Exception exp) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapParser.parseMessageStructure: Caught exception when parsing input:\r\n" + exp.toString()).getBytes(), (int)3);
            return null;
        }
        Vector parsedStruct = null;
        int size = parsedText.size();
        for (int i = 0; i < size; ++i) {
            String label;
            if (!(parsedText.elementAt(i) instanceof String) || !(label = (String)parsedText.elementAt(i)).equalsIgnoreCase("BODYSTRUCTURE") || i >= size - 1 || !(parsedText.elementAt(i + 1) instanceof Vector)) continue;
            parsedStruct = (Vector)parsedText.elementAt(i + 1);
        }
        if (parsedStruct == null) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapParser.parseMessageStructure: Sanity check failed".getBytes(), (int)3);
            return null;
        }
        MessageSection msgStructure = ImapParser.parseMessageStructureParameter(parsedStruct);
        return msgStructure;
    }

    static MessageSection parseMessageStructureParameter(Vector parsedStruct) {
        MessageSection msgStructure = ImapParser.parseMessageStructureHelper(null, 1, parsedStruct);
        ImapParser.fixMessageStructure(msgStructure);
        return msgStructure;
    }

    private static void fixMessageStructure(MessageSection msgStructure) {
        if (msgStructure == null) {
            return;
        }
        int p = msgStructure.address.indexOf(46);
        if (p != -1 && p + 1 < msgStructure.address.length()) {
            msgStructure.address = msgStructure.address.substring(p + 1);
        }
        if (msgStructure.subsections != null && msgStructure.subsections.length > 0) {
            for (int i = 0; i < msgStructure.subsections.length; ++i) {
                ImapParser.fixMessageStructure(msgStructure.subsections[i]);
            }
        }
    }

    private static MessageSection parseMessageStructureHelper(String parentAddress, int index, Vector parsedStruct) {
        String address = parentAddress == null ? Integer.toString(index) : parentAddress + "." + Integer.toString(index);
        if (parsedStruct.elementAt(0) instanceof String) {
            MessageSection section = ImapParser.parseMessageStructureSection(parsedStruct);
            section.address = address;
            return section;
        }
        if (parsedStruct.elementAt(0) instanceof Vector) {
            int size = parsedStruct.size();
            Vector<MessageSection> subSectionsVector = new Vector<MessageSection>();
            for (int i = 0; i < size; ++i) {
                if (parsedStruct.elementAt(i) instanceof Vector) {
                    subSectionsVector.addElement(ImapParser.parseMessageStructureHelper(address, i + 1, (Vector)parsedStruct.elementAt(i)));
                    continue;
                }
                if (!(parsedStruct.elementAt(i) instanceof String)) continue;
                MessageSection section = new MessageSection();
                section.type = "multipart";
                section.subtype = ((String)parsedStruct.elementAt(i)).toLowerCase();
                section.subsections = new MessageSection[subSectionsVector.size()];
                subSectionsVector.copyInto(section.subsections);
                section.address = address;
                return section;
            }
        }
        return null;
    }

    private static MessageSection parseMessageStructureSection(Vector sectionList) {
        Vector tmpVec;
        MessageSection sec = new MessageSection();
        int sectionListSize = sectionList.size();
        if (sectionList.elementAt(0) instanceof String) {
            sec.type = ((String)sectionList.elementAt(0)).toLowerCase();
        }
        if (sectionList.elementAt(1) instanceof String) {
            sec.subtype = ((String)sectionList.elementAt(1)).toLowerCase();
        }
        sec.charset = null;
        if (sectionList.elementAt(2) instanceof Vector) {
            tmpVec = (Vector)sectionList.elementAt(2);
            int size = tmpVec.size();
            for (int i = 0; i < size - 1; i += 2) {
                if (!(tmpVec.elementAt(i) instanceof String) || !(tmpVec.elementAt(i + 1) instanceof String)) continue;
                String key = (String)tmpVec.elementAt(i);
                String value = (String)tmpVec.elementAt(i + 1);
                if (key.equalsIgnoreCase("charset")) {
                    sec.charset = value;
                    continue;
                }
                if (!key.equalsIgnoreCase("name")) continue;
                sec.name = value;
            }
        }
        if (sectionList.elementAt(3) instanceof String) {
            sec.contentId = (String)sectionList.elementAt(3);
        }
        if (sectionList.elementAt(5) instanceof String) {
            sec.encoding = ((String)sectionList.elementAt(5)).toLowerCase();
        }
        if (sectionList.elementAt(6) instanceof String) {
            try {
                sec.size = Integer.parseInt((String)sectionList.elementAt(6));
            }
            catch (Exception exp) {
                sec.size = -1;
            }
        }
        if (sectionListSize > 8 && sectionList.elementAt(8) instanceof Vector && (tmpVec = (Vector)sectionList.elementAt(8)).elementAt(0) instanceof String) {
            sec.disposition = ((String)tmpVec.elementAt(0)).toLowerCase();
        }
        return sec;
    }

    static String parseFolderName(String rawText) {
        StringBuffer buf = new StringBuffer();
        StringBuffer intlBuf = null;
        int index = 0;
        int len = rawText.length();
        boolean usMode = true;
        while (index < len) {
            char ch = rawText.charAt(index);
            if (usMode) {
                if (ch != '&') {
                    buf.append(ch);
                    ++index;
                    continue;
                }
                if (ch == '&' && index < len - 1 && rawText.charAt(index + 1) == '-') {
                    buf.append(ch);
                    index += 2;
                    continue;
                }
                usMode = false;
                ++index;
                continue;
            }
            if (intlBuf == null) {
                intlBuf = new StringBuffer();
            }
            if (ch == '-') {
                buf.append(ImapParser.decodeModifiedBase64(intlBuf.toString()));
                intlBuf = null;
                usMode = true;
                ++index;
                continue;
            }
            intlBuf.append(ch);
            ++index;
        }
        return buf.toString();
    }

    private static String decodeModifiedBase64(String input) {
        boolean[] bits = new boolean[input.length() * 6];
        int len = input.length();
        int bitsIndex = 0;
        for (int i = 0; i < len; ++i) {
            byte val = (byte)MODIFIED_BASE64_ALPHABET.indexOf(input.charAt(i));
            bits[bitsIndex++] = (val & 0x20) != 0;
            bits[bitsIndex++] = (val & 0x10) != 0;
            bits[bitsIndex++] = (val & 8) != 0;
            bits[bitsIndex++] = (val & 4) != 0;
            bits[bitsIndex++] = (val & 2) != 0;
            bits[bitsIndex++] = (val & 1) != 0;
        }
        byte[] decodeData = new byte[(bits.length - bits.length % 16) / 8];
        bitsIndex = 0;
        block3: for (int i = 0; i < decodeData.length; ++i) {
            decodeData[i] = 0;
            for (int j = 7; j >= 0; --j) {
                int n = i;
                decodeData[n] = (byte)(decodeData[n] + (bits[bitsIndex] ? 1 << j : 0));
                if (++bitsIndex >= bits.length) continue block3;
            }
        }
        try {
            String result = new String(decodeData, "UTF-16BE");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static class MessageSection {
        public String address;
        public String type;
        public String name;
        public String subtype;
        public String encoding;
        public String charset;
        public String disposition;
        public String contentId;
        public int size;
        public MessageSection[] subsections;
    }
}

