/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.pop;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.ConnectionConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.MailSettingsEvent;
import org.logicprobe.LogicMail.conf.MailSettingsListener;
import org.logicprobe.LogicMail.conf.PopConfig;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.MailProgressHandler;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.mail.pop.PopMessageToken;
import org.logicprobe.LogicMail.mail.pop.PopProtocol;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.MailMessageParser;
import org.logicprobe.LogicMail.util.StringParser;

public class PopClient
implements IncomingMailClient {
    private PopConfig accountConfig;
    private Connection connection;
    private PopProtocol popProtocol;
    private String username;
    private String password;
    private boolean openStarted;
    private boolean configChanged;
    private FolderTreeItem activeMailbox = null;
    private MailSettingsListener mailSettingsListener = new MailSettingsListener(){

        public void mailSettingsSaved(MailSettingsEvent e) {
            PopClient.this.mailSettings_MailSettingsSaved(e);
        }
    };

    public PopClient(GlobalConfig globalConfig, PopConfig accountConfig) {
        this.accountConfig = accountConfig;
        this.connection = new Connection(accountConfig.getServerName(), accountConfig.getServerPort(), accountConfig.getServerSSL(), accountConfig.getDeviceSide());
        this.popProtocol = new PopProtocol(this.connection);
        this.username = accountConfig.getServerUser();
        this.password = accountConfig.getServerPass();
        this.activeMailbox = new FolderTreeItem("INBOX", "INBOX", "");
        this.activeMailbox.setMsgCount(0);
        this.openStarted = false;
        this.configChanged = false;
        MailSettings.getInstance().addMailSettingsListener(this.mailSettingsListener);
    }

    private void mailSettings_MailSettingsSaved(MailSettingsEvent e) {
        if (MailSettings.getInstance().containsAccountConfig(this.accountConfig)) {
            this.username = this.accountConfig.getServerUser();
            this.password = this.accountConfig.getServerPass();
            if (!this.isConnected()) {
                this.connection = new Connection(this.accountConfig.getServerName(), this.accountConfig.getServerPort(), this.accountConfig.getServerSSL(), this.accountConfig.getDeviceSide());
                this.popProtocol = new PopProtocol(this.connection);
            } else {
                this.configChanged = true;
            }
        } else {
            MailSettings.getInstance().removeMailSettingsListener(this.mailSettingsListener);
        }
    }

    public AccountConfig getAcctConfig() {
        return this.accountConfig;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.getAcctConfig();
    }

    public boolean open() throws IOException, MailException {
        if (!this.openStarted) {
            this.connection.open();
            this.connection.receive();
            this.openStarted = true;
        }
        try {
            this.popProtocol.executeUser(this.username);
            this.popProtocol.executePass(this.password);
        }
        catch (MailException exp) {
            return false;
        }
        this.activeMailbox.setMsgCount(this.popProtocol.executeStat());
        this.openStarted = false;
        return true;
    }

    public void close() throws IOException, MailException {
        if (this.connection.isConnected()) {
            try {
                this.popProtocol.executeQuit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connection.close();
        if (this.configChanged) {
            this.connection = new Connection(this.accountConfig.getServerName(), this.accountConfig.getServerPort(), this.accountConfig.getServerSSL(), this.accountConfig.getDeviceSide());
            this.popProtocol = new PopProtocol(this.connection);
            this.configChanged = false;
        }
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasFolders() {
        return false;
    }

    public boolean hasUndelete() {
        return false;
    }

    public boolean hasIdle() {
        return false;
    }

    public FolderTreeItem getFolderTree(MailProgressHandler progressHandler) throws IOException, MailException {
        return null;
    }

    public void refreshFolderStatus(FolderTreeItem[] folders, MailProgressHandler progressHandler) throws IOException, MailException {
        this.activeMailbox.setMsgCount(this.popProtocol.executeStat());
        if (folders.length == 1 && folders[0] != this.activeMailbox) {
            folders[0].setMsgCount(this.activeMailbox.getMsgCount());
        }
    }

    public FolderTreeItem getInboxFolder() {
        return this.activeMailbox;
    }

    public FolderTreeItem getActiveFolder() {
        return this.activeMailbox;
    }

    public void setActiveFolder(FolderTreeItem mailbox) throws IOException, MailException {
        this.activeMailbox.setMsgCount(this.popProtocol.executeStat());
    }

    public void setActiveFolder(MessageToken messageToken) throws IOException, MailException {
        this.activeMailbox.setMsgCount(this.popProtocol.executeStat());
    }

    public FolderMessage[] getFolderMessages(int firstIndex, int lastIndex, MailProgressHandler progressHandler) throws IOException, MailException {
        FolderMessage[] folderMessages = new FolderMessage[lastIndex - firstIndex + 1];
        int index = 0;
        int postCount = this.connection.getBytesReceived();
        for (int i = firstIndex; i <= lastIndex; ++i) {
            int preCount = postCount;
            String[] headerText = this.popProtocol.executeTop(i, 0);
            String uid = this.popProtocol.executeUidl(i);
            MessageEnvelope env = MailMessageParser.parseMessageEnvelope(headerText);
            folderMessages[index++] = new FolderMessage(new PopMessageToken(i, uid), env, i, uid.hashCode());
            postCount = this.connection.getBytesReceived();
            if (progressHandler == null) continue;
            progressHandler.mailProgress(0, postCount - preCount, -1);
        }
        return folderMessages;
    }

    public FolderMessage[] getNewFolderMessages(MailProgressHandler progressHandler) throws IOException, MailException {
        int count = MailSettings.getInstance().getGlobalConfig().getRetMsgCount();
        int msgCount = this.activeMailbox.getMsgCount();
        int firstIndex = Math.max(1, msgCount - count);
        return this.getFolderMessages(firstIndex, this.activeMailbox.getMsgCount(), progressHandler);
    }

    public Message getMessage(MessageToken messageToken, MailProgressHandler progressHandler) throws IOException, MailException {
        PopMessageToken popMessageToken = (PopMessageToken)messageToken;
        int maxLines = this.accountConfig.getMaxMessageLines();
        String[] message = this.popProtocol.executeTop(popMessageToken.getMessageIndex(), maxLines, progressHandler);
        Hashtable contentMap = new Hashtable();
        MimeMessagePart rootPart = MailMessageParser.parseRawMessage(contentMap, StringParser.createInputStream(message));
        Message msg = new Message(rootPart);
        Enumeration e = contentMap.keys();
        while (e.hasMoreElements()) {
            MimeMessagePart part = (MimeMessagePart)e.nextElement();
            msg.putContent(part, (MimeMessageContent)contentMap.get(part));
        }
        return msg;
    }

    public void deleteMessage(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        PopMessageToken popMessageToken = (PopMessageToken)messageToken;
        this.popProtocol.executeDele(popMessageToken.getMessageIndex());
        messageFlags.setDeleted(true);
    }

    public void undeleteMessage(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
    }

    public boolean noop() throws IOException, MailException {
        this.popProtocol.executeNoop();
        return false;
    }

    public void idleModeBegin() throws IOException, MailException {
    }

    public void idleModeEnd() throws IOException, MailException {
    }

    public boolean idleModePoll() throws IOException, MailException {
        return false;
    }
}

