/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.IOException;
import net.rim.device.api.io.Base64InputStream;
import net.rim.device.api.system.EncodedImage;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessageContentVisitor;
import org.logicprobe.LogicMail.message.UnsupportedContentException;

public class ImageContent
extends MimeMessageContent {
    private EncodedImage image;
    private byte[] rawData;

    public ImageContent(ImagePart imagePart, EncodedImage image) {
        super(imagePart);
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.image = image;
        this.rawData = null;
    }

    public ImageContent(ImagePart imagePart, String encoding, String data) throws UnsupportedContentException {
        super(imagePart);
        if (encoding.equalsIgnoreCase("base64")) {
            try {
                String mimeSubtype = imagePart.getMimeSubtype();
                byte[] imgBytes = Base64InputStream.decode((String)data);
                this.image = EncodedImage.createEncodedImage((byte[])imgBytes, (int)0, (int)imgBytes.length, (String)("image/" + mimeSubtype.toLowerCase()));
                this.rawData = imgBytes;
            }
            catch (IOException e) {
                throw new UnsupportedContentException("Unable to decode");
            }
        } else {
            throw new UnsupportedContentException("Unsupported encoding");
        }
    }

    public static boolean isPartSupported(ImagePart imagePart) {
        String mimeSubtype = imagePart.getMimeSubtype();
        return mimeSubtype.equalsIgnoreCase("gif") || mimeSubtype.equalsIgnoreCase("png") || mimeSubtype.equalsIgnoreCase("vnd.wap.wbmp") || mimeSubtype.equalsIgnoreCase("jpeg") || mimeSubtype.equalsIgnoreCase("jpg") || mimeSubtype.equalsIgnoreCase("pjpeg") || mimeSubtype.equalsIgnoreCase("bmp") || mimeSubtype.equalsIgnoreCase("tiff");
    }

    public void accept(MimeMessageContentVisitor visitor) {
        visitor.visit(this);
    }

    public EncodedImage getImage() {
        return this.image;
    }

    public byte[] getRawData() {
        return this.rawData;
    }
}

