/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import net.rim.device.api.io.Base64OutputStream;
import net.rim.device.api.mime.MIMEOutputStream;
import net.rim.device.api.system.EncodedImage;
import org.logicprobe.LogicMail.message.AbstractMimeMessagePartVisitor;
import org.logicprobe.LogicMail.message.ImageContent;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextContent;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.util.StringParser;

public class MessageMimeConverter {
    private Message message;
    private ByteArrayOutputStream byteArrayOutputStream;
    private MIMEOutputStream mimeOutputStream;
    private Hashtable partMimeMap;
    private MessageMimeConverterPartVisitor partVisitor;

    public MessageMimeConverter(Message message) {
        this.message = message;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.mimeOutputStream = null;
        this.partMimeMap = new Hashtable();
        this.partVisitor = new MessageMimeConverterPartVisitor();
    }

    public String toMimeString() {
        this.message.getStructure().accept(this.partVisitor);
        try {
            this.mimeOutputStream.flush();
            this.mimeOutputStream.close();
        }
        catch (IOException ex) {
            System.err.println("Unable to close MIMEOutputStream");
            return "";
        }
        return this.byteArrayOutputStream.toString();
    }

    private class MessageMimeConverterPartVisitor
    extends AbstractMimeMessagePartVisitor {
        private MessageMimeConverterPartVisitor() {
        }

        public void visitMultiPart(MultiPart part) {
            if (MessageMimeConverter.this.mimeOutputStream == null) {
                MessageMimeConverter.this.mimeOutputStream = new MIMEOutputStream((OutputStream)MessageMimeConverter.this.byteArrayOutputStream, true, null);
                MessageMimeConverter.this.mimeOutputStream.setContentType(part.getMimeType() + "/" + part.getMimeSubtype());
                MessageMimeConverter.this.partMimeMap.put(part, MessageMimeConverter.this.mimeOutputStream);
            } else {
                MIMEOutputStream parentStream = (MIMEOutputStream)MessageMimeConverter.this.partMimeMap.get(part.getParent());
                MIMEOutputStream currentStream = parentStream.getPartOutputStream(true, null);
                MessageMimeConverter.this.partMimeMap.put(part, currentStream);
            }
        }

        public void visitTextPart(TextPart part) {
            MIMEOutputStream currentStream;
            String encoding;
            boolean isQP;
            boolean isBinary;
            String charset;
            MimeMessageContent content = MessageMimeConverter.this.message.getContent(part);
            if (!(content instanceof TextContent)) {
                return;
            }
            String text = ((TextContent)content).getText();
            char maxChar = '\u0000';
            for (int i = text.length() - 1; i >= 0; --i) {
                char ch = text.charAt(i);
                if (ch <= maxChar) continue;
                maxChar = ch;
            }
            if (maxChar > '\u00ff') {
                charset = "UTF-8";
                isBinary = true;
                isQP = false;
                encoding = "base64";
            } else if (maxChar > '\u007f') {
                charset = "ISO-8859-1";
                isBinary = false;
                isQP = true;
                encoding = "quoted-printable";
            } else {
                charset = "US-ASCII";
                isBinary = false;
                isQP = false;
                encoding = "7bit";
            }
            if (MessageMimeConverter.this.mimeOutputStream == null) {
                MessageMimeConverter.this.mimeOutputStream = new MIMEOutputStream((OutputStream)MessageMimeConverter.this.byteArrayOutputStream, false, encoding);
                currentStream = MessageMimeConverter.this.mimeOutputStream;
            } else {
                MIMEOutputStream parentStream = (MIMEOutputStream)MessageMimeConverter.this.partMimeMap.get(part.getParent());
                currentStream = parentStream.getPartOutputStream(false, encoding);
            }
            MessageMimeConverter.this.partMimeMap.put(part, currentStream);
            currentStream.setContentType(part.getMimeType() + "/" + part.getMimeSubtype());
            currentStream.addContentTypeParameter("charset", charset.toLowerCase());
            try {
                if (!isBinary) {
                    if (isQP) {
                        currentStream.write(StringParser.encodeQuotedPrintable(text).getBytes(charset));
                    } else {
                        currentStream.write(text.getBytes(charset));
                    }
                } else {
                    byte[] data = text.getBytes(charset);
                    currentStream.write(Base64OutputStream.encode((byte[])data, (int)0, (int)data.length, (boolean)true, (boolean)true));
                }
            }
            catch (IOException e) {
                System.err.println("Error encoding content");
            }
        }

        public void visitImagePart(ImagePart part) {
            MIMEOutputStream currentStream;
            MimeMessageContent content = MessageMimeConverter.this.message.getContent(part);
            if (!(content instanceof ImageContent)) {
                return;
            }
            EncodedImage image = ((ImageContent)content).getImage();
            if (MessageMimeConverter.this.mimeOutputStream == null) {
                MessageMimeConverter.this.mimeOutputStream = new MIMEOutputStream((OutputStream)MessageMimeConverter.this.byteArrayOutputStream, false, "base64");
                currentStream = MessageMimeConverter.this.mimeOutputStream;
            } else {
                MIMEOutputStream parentStream = (MIMEOutputStream)MessageMimeConverter.this.partMimeMap.get(part.getParent());
                currentStream = parentStream.getPartOutputStream(false, "base64");
            }
            MessageMimeConverter.this.partMimeMap.put(part, currentStream);
            currentStream.setContentType(part.getMimeType() + "/" + part.getMimeSubtype());
            try {
                byte[] data = image.getData();
                currentStream.write(Base64OutputStream.encode((byte[])data, (int)0, (int)data.length, (boolean)true, (boolean)true));
            }
            catch (IOException e) {
                System.err.println("Error encoding content");
            }
        }

        public void visitUnsupportedPart(UnsupportedPart part) {
            MIMEOutputStream currentStream;
            if (MessageMimeConverter.this.mimeOutputStream == null) {
                MessageMimeConverter.this.mimeOutputStream = new MIMEOutputStream((OutputStream)MessageMimeConverter.this.byteArrayOutputStream, false, "7bit");
                currentStream = MessageMimeConverter.this.mimeOutputStream;
            } else {
                MIMEOutputStream parentStream = (MIMEOutputStream)MessageMimeConverter.this.partMimeMap.get(part.getParent());
                currentStream = parentStream.getPartOutputStream(false, "7bit");
            }
            MessageMimeConverter.this.partMimeMap.put(part, currentStream);
            currentStream.setContentType("text/plain");
            try {
                currentStream.write("Unable to encode part".getBytes());
            }
            catch (IOException e) {
                System.err.println("Error encoding content");
            }
        }
    }
}

