/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import org.logicprobe.LogicMail.message.ApplicationPart;
import org.logicprobe.LogicMail.message.AudioPart;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.message.VideoPart;

public class MimeMessagePartFactory {
    public static MimeMessagePart createMimeMessagePart(String mimeType, String mimeSubtype, String name, String encoding, String param, String disposition, String contentId, int size, String tag) {
        if (name == null) {
            name = "";
        }
        if (encoding == null) {
            encoding = "";
        }
        if (param == null) {
            param = "";
        }
        if (disposition == null) {
            disposition = "";
        }
        if (contentId == null) {
            contentId = "";
        }
        if (tag == null) {
            tag = "";
        }
        MimeMessagePart part = mimeType.equalsIgnoreCase("multipart") ? new MultiPart(mimeSubtype, tag) : (mimeType.equalsIgnoreCase("text") ? new TextPart(mimeSubtype, name, encoding, param, disposition, contentId, size, tag) : (mimeType.equalsIgnoreCase("image") ? new ImagePart(mimeSubtype, name, encoding, disposition, contentId, size, tag) : (mimeType.equalsIgnoreCase("application") ? new ApplicationPart(mimeSubtype, name, encoding, disposition, contentId, size, tag) : (mimeType.equalsIgnoreCase("audio") ? new AudioPart(mimeSubtype, name, encoding, disposition, contentId, size, tag) : (mimeType.equalsIgnoreCase("video") ? new VideoPart(mimeSubtype, name, encoding, disposition, contentId, size, tag) : (mimeType.equalsIgnoreCase("message") ? new MessagePart(mimeSubtype, name, encoding, disposition, contentId, size, tag) : new UnsupportedPart(mimeType, mimeSubtype, tag)))))));
        return part;
    }

    public static MimeMessagePart createMimeMessagePart(String mimeType, String mimeSubtype, String name, String encoding, String param, String disposition, String contentId, int size) {
        return MimeMessagePartFactory.createMimeMessagePart(mimeType, mimeSubtype, name, encoding, param, disposition, contentId, size, "");
    }

    public static boolean isMimeMessagePartSupported(String mimeType, String mimeSubtype) {
        if (mimeType.equalsIgnoreCase("multipart")) {
            return MimeMessagePartFactory.isMultiPartSupported(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("text")) {
            return MimeMessagePartFactory.isTextPartSupported(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("image")) {
            return MimeMessagePartFactory.isImagePartSupported(mimeSubtype);
        }
        return false;
    }

    private static boolean isMultiPartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("mixed") || mimeSubtype.equalsIgnoreCase("related") || mimeSubtype.equalsIgnoreCase("alternative") || mimeSubtype.equalsIgnoreCase("signed");
    }

    private static boolean isTextPartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("plain") || mimeSubtype.equalsIgnoreCase("html");
    }

    private static boolean isImagePartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("gif") || mimeSubtype.equalsIgnoreCase("png") || mimeSubtype.equalsIgnoreCase("vnd.wap.wbmp") || mimeSubtype.equalsIgnoreCase("jpeg") || mimeSubtype.equalsIgnoreCase("jpg") || mimeSubtype.equalsIgnoreCase("pjpeg") || mimeSubtype.equalsIgnoreCase("bmp") || mimeSubtype.equalsIgnoreCase("tif");
    }
}

