/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.util.Vector;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.message.AbstractMimeMessagePartVisitor;
import org.logicprobe.LogicMail.message.ApplicationPart;
import org.logicprobe.LogicMail.message.AudioPart;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MimeMessageContentFactory;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.VideoPart;

public class MimeMessagePartTransformer {
    public static MimeMessagePart[] getDisplayableParts(MimeMessagePart rootPart) {
        DisplayablePartVisitor visitor = new DisplayablePartVisitor();
        rootPart.accept(visitor);
        Vector parts = visitor.getDisplayableParts();
        Object[] result = new MimeMessagePart[parts.size()];
        parts.copyInto(result);
        return result;
    }

    public static MimeMessagePart[] getAttachmentParts(MimeMessagePart rootPart) {
        AttachmentPartVisitor visitor = new AttachmentPartVisitor();
        rootPart.accept(visitor);
        Vector parts = visitor.getAttachmentParts();
        Object[] result = new MimeMessagePart[parts.size()];
        parts.copyInto(result);
        return result;
    }

    private static class AttachmentPartVisitor
    extends AbstractMimeMessagePartVisitor {
        private Vector attachmentParts = new Vector();

        private AttachmentPartVisitor() {
        }

        public Vector getAttachmentParts() {
            return this.attachmentParts;
        }

        public void visitTextPart(TextPart part) {
            String subtype = part.getMimeSubtype();
            if (!subtype.equalsIgnoreCase("plain") && !subtype.equalsIgnoreCase("html")) {
                this.attachmentParts.addElement(part);
            }
        }

        public void visitImagePart(ImagePart part) {
            this.attachmentParts.addElement(part);
        }

        public void visitApplicationPart(ApplicationPart part) {
            this.attachmentParts.addElement(part);
        }

        public void visitAudioPart(AudioPart part) {
            this.attachmentParts.addElement(part);
        }

        public void visitVideoPart(VideoPart part) {
            this.attachmentParts.addElement(part);
        }
    }

    private static class DisplayablePartVisitor
    extends AbstractMimeMessagePartVisitor {
        private Vector displayableParts = new Vector();
        int displayFormat = MailSettings.getInstance().getGlobalConfig().getMessageDisplayFormat();

        public Vector getDisplayableParts() {
            return this.displayableParts;
        }

        public void visitTextPart(TextPart part) {
            if (!MimeMessageContentFactory.isContentSupported(part)) {
                return;
            }
            if (part.getParent() instanceof MultiPart) {
                MultiPart parent = (MultiPart)part.getParent();
                if (parent.getMimeSubtype().equalsIgnoreCase("alternative")) {
                    String subType = part.getMimeSubtype();
                    if (this.displayFormat == 0) {
                        if (subType.equalsIgnoreCase("plain")) {
                            this.displayableParts.addElement(part);
                        } else {
                            MimeMessagePart[] siblings = parent.getParts();
                            boolean otherPlain = false;
                            for (int i = 0; i < siblings.length; ++i) {
                                if (siblings[i] == part || !(siblings[i] instanceof TextPart) || !siblings[i].getMimeSubtype().equalsIgnoreCase("plain")) continue;
                                otherPlain = true;
                                break;
                            }
                            if (!otherPlain) {
                                this.displayableParts.addElement(part);
                            }
                        }
                    } else if (this.displayFormat == 1) {
                        if (subType.equalsIgnoreCase("html")) {
                            this.displayableParts.addElement(part);
                        } else {
                            MimeMessagePart[] siblings = parent.getParts();
                            boolean otherHtml = false;
                            for (int i = 0; i < siblings.length; ++i) {
                                if (siblings[i] == part || !(siblings[i] instanceof TextPart) || !siblings[i].getMimeSubtype().equalsIgnoreCase("html")) continue;
                                otherHtml = true;
                                break;
                            }
                            if (!otherHtml) {
                                this.displayableParts.addElement(part);
                            }
                        }
                    }
                } else {
                    this.displayableParts.addElement(part);
                }
            } else {
                this.displayableParts.addElement(part);
            }
        }

        public void visitImagePart(ImagePart part) {
            if (MimeMessageContentFactory.isContentSupported(part)) {
                this.displayableParts.addElement(part);
            }
        }
    }
}

