/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.rim.device.api.io.Base64InputStream;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessageContentVisitor;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedContentException;
import org.logicprobe.LogicMail.util.StringFactory;
import org.logicprobe.LogicMail.util.StringParser;

public class TextContent
extends MimeMessageContent {
    private String text;

    public TextContent(TextPart textPart, String text) {
        super(textPart);
        this.text = text;
    }

    public TextContent(TextPart textPart, String encoding, String charset, String data) throws UnsupportedContentException {
        super(textPart);
        String mimeSubtype = textPart.getMimeSubtype();
        if (encoding.equalsIgnoreCase("quoted-printable")) {
            data = StringParser.decodeQuotedPrintable(data);
        } else if (encoding.equalsIgnoreCase("base64")) {
            byte[] textBytes;
            try {
                textBytes = Base64InputStream.decode((String)data);
            }
            catch (IOException exp) {
                throw new UnsupportedContentException("Unable to decode");
            }
            try {
                if (charset == null) {
                    charset = "ISO-8859-1";
                }
                data = StringFactory.create(textBytes, charset);
            }
            catch (UnsupportedEncodingException exp) {
                data = new String(textBytes);
            }
        } else if (charset != null && !charset.equalsIgnoreCase("ISO-8859-1") && !charset.equalsIgnoreCase("US-ASCII")) {
            byte[] textBytes = data.getBytes();
            try {
                data = StringFactory.create(textBytes, charset);
            }
            catch (UnsupportedEncodingException exp) {
                // empty catch block
            }
        }
        if (!mimeSubtype.equalsIgnoreCase("plain") && !mimeSubtype.equalsIgnoreCase("html")) {
            throw new UnsupportedContentException("Unsupported subtype");
        }
        this.text = data;
    }

    public static boolean isPartSupported(TextPart textPart) {
        String mimeSubtype = textPart.getMimeSubtype();
        return mimeSubtype.equalsIgnoreCase("plain") || mimeSubtype.equalsIgnoreCase("html");
    }

    public void accept(MimeMessageContentVisitor visitor) {
        visitor.visit(this);
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawData() {
        return this.text.getBytes();
    }
}

