/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.util.SimpleSortingVector;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessageMimeConverter;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailboxNodeEvent;
import org.logicprobe.LogicMail.model.MailboxNodeListener;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.model.NodeVisitor;
import org.logicprobe.LogicMail.util.EventListener;
import org.logicprobe.LogicMail.util.EventListenerList;
import org.logicprobe.LogicMail.util.MailMessageParser;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializationUtils;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class MailboxNode
implements Node,
Serializable {
    private long uniqueId;
    private AccountNode parentAccount;
    private MailboxNode parentMailbox;
    private Vector mailboxes;
    private SimpleSortingVector messages;
    private Hashtable messageMap;
    private Hashtable messageTokenMap;
    private EventListenerList listenerList = new EventListenerList();
    private int type;
    private FolderTreeItem folderTreeItem;
    private boolean hasAppend;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_INBOX = 1;
    public static final int TYPE_OUTBOX = 2;
    public static final int TYPE_DRAFTS = 3;
    public static final int TYPE_SENT = 4;
    public static final int TYPE_TRASH = 5;
    static /* synthetic */ Class class$org$logicprobe$LogicMail$model$MailboxNodeListener;

    MailboxNode(FolderTreeItem folderTreeItem, boolean hasAppend, int type) {
        this.uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
        this.mailboxes = new Vector();
        this.messages = new SimpleSortingVector();
        this.messages.setSortComparator(MessageNode.getComparator());
        this.messages.setSort(true);
        this.messageMap = new Hashtable();
        this.messageTokenMap = new Hashtable();
        if (folderTreeItem != null) {
            this.setFolderTreeItem(new FolderTreeItem(folderTreeItem));
        }
        this.type = type;
        this.hasAppend = hasAppend;
    }

    MailboxNode(FolderTreeItem folderTreeItem, boolean hasAppend) {
        this(folderTreeItem, hasAppend, 0);
    }

    MailboxNode(FolderTreeItem folderTreeItem) {
        this(folderTreeItem, false, 0);
    }

    public MailboxNode() {
        this(null, false, 0);
    }

    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    void setParentAccount(AccountNode parentAccount) {
        this.parentAccount = parentAccount;
    }

    public AccountNode getParentAccount() {
        return this.parentAccount;
    }

    void setParentMailbox(MailboxNode parentMailbox) {
        this.parentMailbox = parentMailbox;
    }

    public MailboxNode getParentMailbox() {
        return this.parentMailbox;
    }

    void setFolderTreeItem(FolderTreeItem folderTreeItem) {
        this.folderTreeItem = new FolderTreeItem(folderTreeItem);
    }

    FolderTreeItem getFolderTreeItem() {
        return this.folderTreeItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxNode[] getMailboxes() {
        MailboxNode[] result;
        Vector vector = this.mailboxes;
        synchronized (vector) {
            int size = this.mailboxes.size();
            result = new MailboxNode[size];
            for (int i = 0; i < size; ++i) {
                result[i] = (MailboxNode)this.mailboxes.elementAt(i);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageNode[] getMessages() {
        MessageNode[] result;
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            int size = this.messages.size();
            result = new MessageNode[size];
            for (int i = 0; i < size; ++i) {
                result[i] = (MessageNode)this.messages.elementAt(i);
            }
        }
        return result;
    }

    public void appendMessage(MessageNode message) {
        if (!this.hasAppend) {
            return;
        }
        String rawMessage = message.getMessageSource();
        if (rawMessage == null) {
            rawMessage = message.toMimeMessage(false);
        }
        int flags = message.getFlags();
        MessageFlags messageFlags = new MessageFlags();
        messageFlags.setSeen((flags & 1) != 0);
        messageFlags.setAnswered((flags & 2) != 0);
        messageFlags.setFlagged((flags & 4) != 0);
        messageFlags.setDeleted((flags & 8) != 0);
        messageFlags.setDraft((flags & 0x10) != 0);
        messageFlags.setRecent((flags & 0x20) != 0);
        messageFlags.setJunk((flags & 0x40) != 0);
        this.parentAccount.getMailStore().requestMessageAppend(this.folderTreeItem, rawMessage, messageFlags);
    }

    public void appendMessage(MessageEnvelope envelope, Message message, MessageFlags messageFlags) {
        if (!this.hasAppend) {
            return;
        }
        String rawMessage = this.generateRawMessage(envelope, message);
        this.parentAccount.getMailStore().requestMessageAppend(this.folderTreeItem, rawMessage, messageFlags);
    }

    private String generateRawMessage(MessageEnvelope envelope, Message message) {
        StringBuffer buf = new StringBuffer();
        buf.append(MailMessageParser.generateMessageHeaders(envelope, false));
        MessageMimeConverter messageMime = new MessageMimeConverter(message);
        buf.append(messageMime.toMimeString());
        String rawMessage = buf.toString();
        return rawMessage;
    }

    public void appendRawMessage(String rawMessage, MessageFlags initialFlags) {
        if (!this.hasAppend) {
            return;
        }
        this.parentAccount.getMailStore().requestMessageAppend(this.folderTreeItem, rawMessage, initialFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMailbox(MailboxNode mailbox) {
        Vector vector = this.mailboxes;
        synchronized (vector) {
            if (!this.mailboxes.contains(mailbox)) {
                this.mailboxes.addElement(mailbox);
                mailbox.setParentMailbox(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMailbox(MailboxNode mailbox) {
        Vector vector = this.mailboxes;
        synchronized (vector) {
            if (this.mailboxes.contains(mailbox)) {
                this.mailboxes.removeElement(mailbox);
                mailbox.setParentMailbox(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMailboxes() {
        Vector vector = this.mailboxes;
        synchronized (vector) {
            this.mailboxes.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(MessageNode message) {
        boolean messageAdded;
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            messageAdded = this.addMessageImpl(message);
        }
        if (messageAdded) {
            this.fireMailboxStatusChanged(1, new MessageNode[]{message});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessages(MessageNode[] messages) {
        Vector<MessageNode> addedMessages = null;
        MessageNode[] messageNodeArray = messages;
        synchronized (messages) {
            for (int i = 0; i < messages.length; ++i) {
                if (!this.addMessageImpl(messages[i])) continue;
                if (addedMessages == null) {
                    addedMessages = new Vector<MessageNode>();
                }
                addedMessages.addElement(messages[i]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (addedMessages != null) {
                Object[] addedMessagesArray = new MessageNode[addedMessages.size()];
                addedMessages.copyInto(addedMessagesArray);
                this.fireMailboxStatusChanged(1, (MessageNode[])addedMessagesArray);
            }
            return;
        }
    }

    private boolean addMessageImpl(MessageNode message) {
        if (!this.messageMap.containsKey(message)) {
            message.setParent(this);
            this.messages.addElement((Object)message);
            this.messageMap.put(message, message);
            this.messageTokenMap.put(message.getMessageToken(), message);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessage(MessageNode message) {
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            if (this.messageMap.containsKey(message)) {
                this.messages.removeElement(message);
                message.setParent(null);
                this.messageMap.remove(message);
                this.messageTokenMap.remove(message.getMessageToken());
            }
        }
        this.fireMailboxStatusChanged(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMessages() {
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            int size = this.messages.size();
            for (int i = 0; i < size; ++i) {
                ((MessageNode)this.messages.elementAt(i)).setParent(null);
            }
            this.messages.removeAllElements();
            this.messageMap.clear();
            this.messageTokenMap.clear();
        }
        this.fireMailboxStatusChanged(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsMessage(MessageNode messageNode) {
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            return this.messageMap.containsKey(messageNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsMessageByTag(MessageToken messageToken) {
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            return this.messageTokenMap.containsKey(messageToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageNode getMessageByToken(MessageToken messageToken) {
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            MessageNode message = (MessageNode)this.messageTokenMap.get(messageToken);
            return message;
        }
    }

    public String toString() {
        return this.folderTreeItem.getName();
    }

    public String getPath() {
        return this.folderTreeItem.getPath();
    }

    public boolean hasAppend() {
        return this.hasAppend;
    }

    void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isSelectable() {
        return this.folderTreeItem.isSelectable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        int result = 0;
        SimpleSortingVector simpleSortingVector = this.messages;
        synchronized (simpleSortingVector) {
            result = this.messages.size();
        }
        return result;
    }

    public int getUnseenMessageCount() {
        return this.folderTreeItem.getUnseenCount();
    }

    public void refreshMessages() {
        this.parentAccount.getMailStore().requestFolderMessagesRecent(this.folderTreeItem);
    }

    public void addMailboxNodeListener(MailboxNodeListener l) {
        this.listenerList.add(class$org$logicprobe$LogicMail$model$MailboxNodeListener == null ? (class$org$logicprobe$LogicMail$model$MailboxNodeListener = MailboxNode.class$("org.logicprobe.LogicMail.model.MailboxNodeListener")) : class$org$logicprobe$LogicMail$model$MailboxNodeListener, l);
    }

    public void removeMailboxNodeListener(MailboxNodeListener l) {
        this.listenerList.remove(class$org$logicprobe$LogicMail$model$MailboxNodeListener == null ? (class$org$logicprobe$LogicMail$model$MailboxNodeListener = MailboxNode.class$("org.logicprobe.LogicMail.model.MailboxNodeListener")) : class$org$logicprobe$LogicMail$model$MailboxNodeListener, l);
    }

    public MailboxNodeListener[] getMailboxNodeListeners() {
        return (MailboxNodeListener[])this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MailboxNodeListener == null ? (class$org$logicprobe$LogicMail$model$MailboxNodeListener = MailboxNode.class$("org.logicprobe.LogicMail.model.MailboxNodeListener")) : class$org$logicprobe$LogicMail$model$MailboxNodeListener);
    }

    void fireMailboxStatusChanged(int type, MessageNode[] affectedMessages) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MailboxNodeListener == null ? (class$org$logicprobe$LogicMail$model$MailboxNodeListener = MailboxNode.class$("org.logicprobe.LogicMail.model.MailboxNodeListener")) : class$org$logicprobe$LogicMail$model$MailboxNodeListener);
        MailboxNodeEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new MailboxNodeEvent(this, type, affectedMessages);
            }
            ((MailboxNodeListener)listeners[i]).mailboxStatusChanged(e);
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        output.writeBoolean(this.hasAppend);
        output.writeInt(this.type);
        this.folderTreeItem.serialize(output);
        Vector vector = this.mailboxes;
        synchronized (vector) {
            int size = this.mailboxes.size();
            output.writeInt(size);
            for (int i = 0; i < size; ++i) {
                byte[] serializedBytes = SerializationUtils.serializeClass((MailboxNode)this.mailboxes.elementAt(i));
                output.writeInt(serializedBytes.length);
                ((OutputStream)output).write(serializedBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(DataInputStream input) throws IOException {
        this.uniqueId = input.readLong();
        this.hasAppend = input.readBoolean();
        this.type = input.readInt();
        this.folderTreeItem = new FolderTreeItem();
        this.folderTreeItem.deserialize(input);
        Vector vector = this.mailboxes;
        synchronized (vector) {
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                int length = input.readInt();
                if (length < 0 || length > 1000000) {
                    throw new IOException();
                }
                byte[] serializedBytes = new byte[length];
                input.read(serializedBytes);
                Serializable deserializedObject = SerializationUtils.deserializeClass(serializedBytes);
                if (!(deserializedObject instanceof MailboxNode)) continue;
                MailboxNode child = (MailboxNode)deserializedObject;
                child.parentMailbox = this;
                this.mailboxes.addElement(child);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

