/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.EditField;
import net.rim.device.api.ui.component.EmailAddressEditField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.PasswordEditField;
import net.rim.device.api.ui.component.RadioButtonField;
import net.rim.device.api.ui.component.RadioButtonGroup;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.text.TextFilter;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.conf.ImapConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.conf.PopConfig;
import org.logicprobe.LogicMail.ui.WizardController;
import org.logicprobe.LogicMail.ui.WizardScreen;

public class AccountConfigWizard
extends WizardController {
    private int accountType = -1;
    private boolean identityCreated;
    private boolean outgoingCreated;
    private static final int ACCOUNT_TYPE_IMAP = 0;
    private static final int ACCOUNT_TYPE_POP = 1;
    private IdentityConfig identityConfig;
    private AccountConfig accountConfig;
    private OutgoingConfig outgoingConfig;
    private WizardScreen newAccountWizardScreen = new WizardScreen(WizardScreen.resources.getString(114), 1){
        private FieldChangeListener fieldChangeListener;
        private ObjectChoiceField identityChoiceField;
        private EditField identityNameEditField;
        private EditField nameEditField;
        private EmailAddressEditField emailAddressEditField;
        private RichTextField commentsField;

        protected void initFields() {
            MailSettings mailSettings = MailSettings.getInstance();
            int numIdentities = mailSettings.getNumIdentities();
            Object[] identityChoices = new Object[numIdentities + 1];
            for (int i = 0; i < numIdentities; ++i) {
                identityChoices[i] = mailSettings.getIdentityConfig(i);
            }
            identityChoices[identityChoices.length - 1] = WizardScreen.resources.getString(115);
            this.fieldChangeListener = new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    this.newAccountWizardScreen_fieldChanged(field, context);
                }
            };
            this.identityChoiceField = new ObjectChoiceField(WizardScreen.resources.getString(116), identityChoices, 0);
            this.identityChoiceField.setChangeListener(this.fieldChangeListener);
            this.identityNameEditField = new EditField(WizardScreen.resources.getString(117) + ' ', "");
            this.identityNameEditField.setChangeListener(this.fieldChangeListener);
            this.nameEditField = new EditField(WizardScreen.resources.getString(118) + ' ', "");
            this.nameEditField.setChangeListener(this.fieldChangeListener);
            this.emailAddressEditField = new EmailAddressEditField(WizardScreen.resources.getString(119) + ' ', "");
            this.emailAddressEditField.setChangeListener(this.fieldChangeListener);
            this.commentsField = new RichTextField(WizardScreen.resources.getString(120));
            this.commentsField.setFont(this.getFont().derive(2));
            this.add((Field)this.identityChoiceField);
            this.add((Field)this.identityNameEditField);
            this.add((Field)this.nameEditField);
            this.add((Field)this.emailAddressEditField);
            this.add((Field)new LabelField());
            this.add((Field)this.commentsField);
            this.populateIdentityItems();
            this.validateData();
        }

        private void newAccountWizardScreen_fieldChanged(Field field, int context) {
            if (field == this.identityChoiceField) {
                this.populateIdentityItems();
            }
            this.validateData();
        }

        private void validateData() {
            if (this.identityNameEditField.getText().trim().length() > 0 && this.nameEditField.getText().trim().length() > 0 && this.emailAddressEditField.getText().trim().length() > 0) {
                this.setInputValid(true);
            } else {
                this.setInputValid(false);
            }
        }

        private void populateIdentityItems() {
            int index = this.identityChoiceField.getSelectedIndex();
            Object item = this.identityChoiceField.getChoice(index);
            if (item instanceof IdentityConfig) {
                IdentityConfig identityConfig = (IdentityConfig)item;
                this.identityNameEditField.setText(identityConfig.getIdentityName());
                this.nameEditField.setText(identityConfig.getFullName());
                this.emailAddressEditField.setText(identityConfig.getEmailAddress());
                this.identityNameEditField.setEditable(false);
                this.nameEditField.setEditable(false);
                this.emailAddressEditField.setEditable(false);
            } else {
                if (index == 0) {
                    this.identityNameEditField.setText("Default");
                } else {
                    this.identityNameEditField.setText("");
                }
                this.nameEditField.setText("");
                this.emailAddressEditField.setText("");
                this.identityNameEditField.setEditable(true);
                this.nameEditField.setEditable(true);
                this.emailAddressEditField.setEditable(true);
            }
        }

        public void gatherResults() {
            int index = this.identityChoiceField.getSelectedIndex();
            Object item = this.identityChoiceField.getChoice(index);
            if (item instanceof IdentityConfig) {
                AccountConfigWizard.this.identityConfig = (IdentityConfig)item;
                AccountConfigWizard.this.identityCreated = false;
            } else {
                AccountConfigWizard.this.identityConfig.setIdentityName(this.identityNameEditField.getText());
                AccountConfigWizard.this.identityConfig.setFullName(this.nameEditField.getText());
                AccountConfigWizard.this.identityConfig.setEmailAddress(this.emailAddressEditField.getText());
                AccountConfigWizard.this.identityCreated = true;
            }
        }
    };
    private WizardScreen accountTypeWizardScreen = new WizardScreen(WizardScreen.resources.getString(121), 0){
        private LabelField descriptionLabelField;
        private RadioButtonGroup accountTypeGroup;
        private RadioButtonField imapAccountType;
        private RadioButtonField popAccountType;

        protected void initFields() {
            this.descriptionLabelField = new LabelField((Object)WizardScreen.resources.getString(122));
            this.accountTypeGroup = new RadioButtonGroup();
            this.accountTypeGroup.setChangeListener(new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    this.setInputValid(accountTypeGroup.getSelectedIndex() != -1);
                }
            });
            this.imapAccountType = new RadioButtonField("IMAP", this.accountTypeGroup, false);
            this.popAccountType = new RadioButtonField("POP", this.accountTypeGroup, false);
            this.add((Field)this.descriptionLabelField);
            this.add((Field)this.imapAccountType);
            this.add((Field)this.popAccountType);
            this.setInputValid(false);
        }

        protected void onPageFlip() {
            if (this.imapAccountType.isSelected()) {
                AccountConfigWizard.this.accountType = 0;
            } else if (this.popAccountType.isSelected()) {
                AccountConfigWizard.this.accountType = 1;
            }
        }

        public void gatherResults() {
        }
    };
    private WizardScreen accountNameWizardScreen = new WizardScreen(WizardScreen.resources.getString(123), 0){
        private LabelField descriptionLabelField;
        private EditField nameEditField;

        protected void initFields() {
            this.descriptionLabelField = new LabelField((Object)WizardScreen.resources.getString(124));
            this.nameEditField = new EditField(WizardScreen.resources.getString(125) + ' ', "");
            this.nameEditField.setChangeListener(new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    this.setInputValid(nameEditField.getText().trim().length() > 0);
                }
            });
            this.add((Field)this.descriptionLabelField);
            this.add((Field)this.nameEditField);
        }

        public void gatherResults() {
            AccountConfigWizard.this.accountConfig.setAcctName(this.nameEditField.getText());
        }
    };
    private WizardScreen mailServerWizardScreen = new WizardScreen(WizardScreen.resources.getString(126), 0){
        private FieldChangeListener fieldChangeListener;
        private LabelField descriptionLabelField;
        private BasicEditField nameEditField;
        private CheckboxField sslCheckboxField;
        private BasicEditField portEditField;
        private CheckboxField useMdsCheckboxField;

        protected void initFields() {
            this.fieldChangeListener = new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    this.mailServerWizardScreen_fieldChanged(field, context);
                }
            };
            this.descriptionLabelField = new LabelField((Object)WizardScreen.resources.getString(127));
            this.nameEditField = new BasicEditField(WizardScreen.resources.getString(23) + " ", "");
            this.nameEditField.setChangeListener(this.fieldChangeListener);
            this.sslCheckboxField = new CheckboxField("SSL", false);
            this.sslCheckboxField.setChangeListener(this.fieldChangeListener);
            this.portEditField = new BasicEditField(WizardScreen.resources.getString(24) + " ", Integer.toString(143));
            this.portEditField.setFilter(TextFilter.get((int)1));
            this.portEditField.setChangeListener(this.fieldChangeListener);
            this.useMdsCheckboxField = new CheckboxField(WizardScreen.resources.getString(27), true);
            this.add((Field)this.descriptionLabelField);
            this.add((Field)this.nameEditField);
            this.add((Field)this.sslCheckboxField);
            this.add((Field)this.portEditField);
            this.add((Field)this.useMdsCheckboxField);
        }

        private void mailServerWizardScreen_fieldChanged(Field field, int context) {
            if (field == this.sslCheckboxField) {
                if (AccountConfigWizard.this.accountType == 1) {
                    if (this.sslCheckboxField.getChecked()) {
                        this.portEditField.setText("995");
                    } else {
                        this.portEditField.setText("110");
                    }
                } else if (AccountConfigWizard.this.accountType == 0) {
                    if (this.sslCheckboxField.getChecked()) {
                        this.portEditField.setText("993");
                    } else {
                        this.portEditField.setText("143");
                    }
                }
            }
            if (this.nameEditField.getText().trim().length() > 0 && this.portEditField.getText().trim().length() > 0) {
                this.setInputValid(true);
            } else {
                this.setInputValid(false);
            }
        }

        public void gatherResults() {
            AccountConfigWizard.this.accountConfig.setServerName(this.nameEditField.getText());
            AccountConfigWizard.this.accountConfig.setServerSSL(this.sslCheckboxField.getChecked());
            AccountConfigWizard.this.accountConfig.setServerPort(Integer.parseInt(this.portEditField.getText()));
            AccountConfigWizard.this.accountConfig.setDeviceSide(!this.useMdsCheckboxField.getChecked());
        }
    };
    private WizardScreen authenticationWizardScreen = new WizardScreen(WizardScreen.resources.getString(128), 0){
        private LabelField descriptionLabelField;
        private BasicEditField userEditField;
        private PasswordEditField passEditField;
        private RichTextField commentsField;

        protected void initFields() {
            this.descriptionLabelField = new LabelField((Object)WizardScreen.resources.getString(129));
            this.userEditField = new BasicEditField(WizardScreen.resources.getString(25) + ' ', "");
            this.passEditField = new PasswordEditField(WizardScreen.resources.getString(26) + ' ', "");
            this.commentsField = new RichTextField(WizardScreen.resources.getString(130));
            this.commentsField.setFont(this.getFont().derive(2));
            this.add((Field)this.descriptionLabelField);
            this.add((Field)this.userEditField);
            this.add((Field)this.passEditField);
            this.add((Field)new LabelField());
            this.add((Field)this.commentsField);
            this.setInputValid(true);
        }

        public void gatherResults() {
            AccountConfigWizard.this.accountConfig.setServerUser(this.userEditField.getText());
            AccountConfigWizard.this.accountConfig.setServerPass(this.passEditField.getText());
        }
    };
    private WizardScreen outgoingServerWizardScreen = new WizardScreen(WizardScreen.resources.getString(131), 0){
        private FieldChangeListener fieldChangeListener;
        private ObjectChoiceField outgoingChoiceField;
        private BasicEditField nameEditField;
        private CheckboxField sslCheckboxField;
        private BasicEditField portEditField;
        private CheckboxField useMdsCheckboxField;

        protected void initFields() {
            MailSettings mailSettings = MailSettings.getInstance();
            int numOutgoing = mailSettings.getNumOutgoing();
            Object[] outgoingChoices = new Object[numOutgoing + 1];
            for (int i = 0; i < numOutgoing; ++i) {
                outgoingChoices[i] = mailSettings.getOutgoingConfig(i);
            }
            outgoingChoices[outgoingChoices.length - 1] = WizardScreen.resources.getString(132);
            this.fieldChangeListener = new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    this.outgoingServerWizardScreen_fieldChanged(field, context);
                }
            };
            this.outgoingChoiceField = new ObjectChoiceField(WizardScreen.resources.getString(133), outgoingChoices, 0);
            this.outgoingChoiceField.setChangeListener(this.fieldChangeListener);
            this.nameEditField = new BasicEditField(WizardScreen.resources.getString(23) + ' ', "");
            this.nameEditField.setChangeListener(this.fieldChangeListener);
            this.sslCheckboxField = new CheckboxField("SSL", false);
            this.sslCheckboxField.setChangeListener(this.fieldChangeListener);
            this.portEditField = new BasicEditField(WizardScreen.resources.getString(24) + ' ', Integer.toString(25));
            this.portEditField.setFilter(TextFilter.get((int)1));
            this.portEditField.setChangeListener(this.fieldChangeListener);
            this.useMdsCheckboxField = new CheckboxField(WizardScreen.resources.getString(27), true);
            this.add((Field)this.outgoingChoiceField);
            this.add((Field)this.nameEditField);
            this.add((Field)this.sslCheckboxField);
            this.add((Field)this.portEditField);
            this.add((Field)this.useMdsCheckboxField);
            this.populateOutgoingItems();
            this.validateData();
        }

        private void outgoingServerWizardScreen_fieldChanged(Field field, int context) {
            if (field == this.sslCheckboxField) {
                if (this.sslCheckboxField.getChecked()) {
                    this.portEditField.setText("465");
                } else {
                    this.portEditField.setText("25");
                }
            }
            if (field == this.outgoingChoiceField) {
                this.populateOutgoingItems();
            }
            this.validateData();
        }

        private void validateData() {
            if (this.nameEditField.getText().trim().length() > 0 && this.portEditField.getText().trim().length() > 0) {
                this.setInputValid(true);
            } else {
                this.setInputValid(false);
            }
        }

        private void populateOutgoingItems() {
            int index = this.outgoingChoiceField.getSelectedIndex();
            Object item = this.outgoingChoiceField.getChoice(index);
            if (item instanceof OutgoingConfig) {
                OutgoingConfig outgoingConfig = (OutgoingConfig)item;
                this.nameEditField.setText(outgoingConfig.getServerName());
                this.sslCheckboxField.setChecked(outgoingConfig.getServerSSL());
                this.portEditField.setText(Integer.toString(outgoingConfig.getServerPort()));
                this.useMdsCheckboxField.setChecked(!outgoingConfig.getDeviceSide());
                this.nameEditField.setEditable(false);
                this.sslCheckboxField.setEditable(false);
                this.portEditField.setEditable(false);
                this.useMdsCheckboxField.setEditable(false);
            } else {
                this.nameEditField.setText("");
                this.sslCheckboxField.setChecked(false);
                this.portEditField.setText("25");
                this.useMdsCheckboxField.setChecked(true);
                this.nameEditField.setEditable(true);
                this.sslCheckboxField.setEditable(true);
                this.portEditField.setEditable(true);
                this.useMdsCheckboxField.setEditable(true);
            }
        }

        protected void onPageFlip() {
            int index = this.outgoingChoiceField.getSelectedIndex();
            Object item = this.outgoingChoiceField.getChoice(index);
            if (item instanceof OutgoingConfig) {
                AccountConfigWizard.this.outgoingAuthenticationWizardScreen.setEnabled(false);
            } else {
                AccountConfigWizard.this.outgoingAuthenticationWizardScreen.setEnabled(true);
            }
        }

        public void gatherResults() {
            int index = this.outgoingChoiceField.getSelectedIndex();
            Object item = this.outgoingChoiceField.getChoice(index);
            if (item instanceof OutgoingConfig) {
                AccountConfigWizard.this.outgoingConfig = (OutgoingConfig)item;
                AccountConfigWizard.this.outgoingCreated = false;
            } else {
                AccountConfigWizard.this.outgoingConfig.setAcctName(AccountConfigWizard.this.accountConfig.getAcctName());
                AccountConfigWizard.this.outgoingConfig.setServerName(this.nameEditField.getText());
                AccountConfigWizard.this.outgoingConfig.setServerSSL(this.sslCheckboxField.getChecked());
                AccountConfigWizard.this.outgoingConfig.setServerPort(Integer.parseInt(this.portEditField.getText()));
                AccountConfigWizard.this.outgoingConfig.setDeviceSide(!this.useMdsCheckboxField.getChecked());
                AccountConfigWizard.this.outgoingCreated = true;
            }
        }
    };
    private WizardScreen outgoingAuthenticationWizardScreen = new WizardScreen(WizardScreen.resources.getString(134), 0){
        private FieldChangeListener fieldChangeListener;
        private LabelField descriptionLabelField;
        private ObjectChoiceField authChoiceField;
        private BasicEditField userEditField;
        private PasswordEditField passEditField;
        private LabelField commentsSpacerLabel;
        private RichTextField commentsField;
        private boolean authMode;

        protected void initFields() {
            this.fieldChangeListener = new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    this.outgoingAuthenticationWizardScreen_fieldChanged(field, context);
                }
            };
            this.descriptionLabelField = new LabelField((Object)WizardScreen.resources.getString(135));
            Object[] authTypes = new String[]{WizardScreen.resources.getString(63), "PLAIN", "LOGIN", "CRAM-MD5"};
            this.authChoiceField = new ObjectChoiceField(WizardScreen.resources.getString(62) + ' ', authTypes, 0);
            this.authChoiceField.setChangeListener(this.fieldChangeListener);
            this.userEditField = new BasicEditField(WizardScreen.resources.getString(25) + ' ', "");
            this.passEditField = new PasswordEditField(WizardScreen.resources.getString(26) + ' ', "");
            this.commentsSpacerLabel = new LabelField();
            this.commentsField = new RichTextField(WizardScreen.resources.getString(136));
            this.commentsField.setFont(this.getFont().derive(2));
            this.add((Field)this.descriptionLabelField);
            this.add((Field)this.authChoiceField);
            this.setInputValid(true);
        }

        private void outgoingAuthenticationWizardScreen_fieldChanged(Field field, int context) {
            if (field == this.authChoiceField) {
                if (this.authChoiceField.getSelectedIndex() == 0 && this.authMode) {
                    this.authMode = false;
                    this.delete((Field)this.userEditField);
                    this.delete((Field)this.passEditField);
                    this.delete((Field)this.commentsSpacerLabel);
                    this.delete((Field)this.commentsField);
                } else if (!this.authMode) {
                    this.authMode = true;
                    this.add((Field)this.userEditField);
                    this.add((Field)this.passEditField);
                    this.add((Field)this.commentsSpacerLabel);
                    this.add((Field)this.commentsField);
                }
            }
        }

        public void gatherResults() {
            int index = this.authChoiceField.getSelectedIndex();
            AccountConfigWizard.this.outgoingConfig.setUseAuth(index);
            if (index > 0) {
                AccountConfigWizard.this.outgoingConfig.setServerUser(this.userEditField.getText());
                AccountConfigWizard.this.outgoingConfig.setServerPass(this.passEditField.getText());
            } else {
                AccountConfigWizard.this.outgoingConfig.setServerUser("");
                AccountConfigWizard.this.outgoingConfig.setServerPass("");
            }
        }
    };
    private WizardScreen finalWizardScreen = new WizardScreen(WizardScreen.resources.getString(137), 2){
        private ButtonField testButton;

        protected void initFields() {
            this.testButton = new ButtonField("        ", 0x300000000L);
            this.testButton.setEditable(false);
            this.add((Field)new LabelField());
            this.add((Field)this.testButton);
            this.setInputValid(true);
        }

        public void onPageEnter() {
            AccountConfigWizard.this.identityConfig = new IdentityConfig();
            if (AccountConfigWizard.this.accountType == 0) {
                AccountConfigWizard.this.accountConfig = new ImapConfig();
            } else if (AccountConfigWizard.this.accountType == 1) {
                AccountConfigWizard.this.accountConfig = new PopConfig();
            }
            AccountConfigWizard.this.outgoingConfig = new OutgoingConfig();
            AccountConfigWizard.this.gatherResults();
            AccountConfigWizard.this.accountConfig.setIdentityConfig(AccountConfigWizard.this.identityConfig);
            AccountConfigWizard.this.accountConfig.setOutgoingConfig(AccountConfigWizard.this.outgoingConfig);
        }
    };

    public AccountConfigWizard() {
        this.addWizardScreen(this.newAccountWizardScreen);
        this.addWizardScreen(this.accountTypeWizardScreen);
        this.addWizardScreen(this.accountNameWizardScreen);
        this.addWizardScreen(this.mailServerWizardScreen);
        this.addWizardScreen(this.authenticationWizardScreen);
        this.addWizardScreen(this.outgoingServerWizardScreen);
        this.addWizardScreen(this.outgoingAuthenticationWizardScreen);
        this.addWizardScreen(this.finalWizardScreen);
    }

    protected void onWizardFinished() {
        MailSettings mailSettings = MailSettings.getInstance();
        if (this.identityCreated) {
            mailSettings.addIdentityConfig(this.identityConfig);
        }
        if (this.outgoingCreated) {
            mailSettings.addOutgoingConfig(this.outgoingConfig);
        }
        mailSettings.addAccountConfig(this.accountConfig);
        mailSettings.saveSettings();
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }
}

