/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.container.VerticalFieldManager;
import org.logicprobe.LogicMail.util.StringParser;

public class BrowserFieldManager
extends VerticalFieldManager {
    public static final int ACTION_SEND_EMAIL = 1;
    private String selectedToken;

    protected void makeMenu(Menu menu, int instance) {
        int size = menu.getSize();
        for (int i = 0; i < size; ++i) {
            String address;
            MenuItem item = menu.getItem(i);
            if (item instanceof EmailMenuItem) continue;
            String itemText = item.toString();
            if (itemText == null) {
                menu.deleteItem(i);
                i = 0;
                size = menu.getSize();
            }
            if ((address = BrowserFieldManager.getEmailItem(itemText)) == null) continue;
            EmailMenuItem emailMenuItem = new EmailMenuItem(item.toString(), item.getOrdinal(), item.getPriority(), address);
            menu.add((MenuItem)emailMenuItem);
            menu.deleteItem(i);
            i = 0;
            size = menu.getSize();
            menu.setDefault((MenuItem)emailMenuItem);
        }
        super.makeMenu(menu, instance);
    }

    private static String getEmailItem(String itemText) {
        String[] elements = StringParser.parseTokenString(itemText, " ");
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].indexOf(64) == -1) continue;
            return elements[i].trim();
        }
        return null;
    }

    public String getSelectedToken() {
        return this.selectedToken;
    }

    private class EmailMenuItem
    extends MenuItem {
        private String address;

        public EmailMenuItem(String text, int ordinal, int priority, String address) {
            super(text, ordinal, priority);
            this.address = address;
        }

        public void run() {
            BrowserFieldManager.this.selectedToken = this.address;
            BrowserFieldManager.this.fieldChangeNotify(-2147483647);
        }
    }
}

