/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import javax.microedition.pim.Contact;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import net.rim.blackberry.api.pdap.BlackBerryContactGroup;
import net.rim.blackberry.api.pdap.BlackBerryContactList;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.ContextMenu;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EditField;
import org.logicprobe.LogicMail.ui.EmailAddressPropertiesDialog;
import org.logicprobe.LogicMail.util.StringParser;

public class EmailAddressBookEditField
extends EditField {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    public static final int ADDRESS_TO = 1;
    public static final int ADDRESS_CC = 2;
    public static final int ADDRESS_BCC = 3;
    private static final int MODE_ADDRESS = 1;
    private static final int MODE_NAME = 2;
    private static final char[] invalidChars = new char[]{'<', '>', '\"', '{', '}', '|', '\\', '^', '[', ']', '`'};
    private String name;
    private String address;
    private int addressMode;
    private int addressType;
    private MenuItem addressPropertiesMenuItem = new MenuItem(resources.getString(70), 200000, 10){

        public void run() {
            EmailAddressBookEditField.this.addressProperties();
        }
    };
    private MenuItem addressBookMenuItem = new MenuItem(resources.getString(138), 200010, 10){

        public void run() {
            EmailAddressBookEditField.this.addressBookChooser();
        }
    };

    public EmailAddressBookEditField(int addressType, String initialValue) {
        super("", "");
        this.setAddressType(addressType);
        this.setText(initialValue);
    }

    public void setAddressType(int addressType) {
        switch (addressType) {
            case 1: {
                this.setLabel(resources.getString(80) + ' ');
                break;
            }
            case 2: {
                this.setLabel(resources.getString(81) + ' ');
                break;
            }
            case 3: {
                this.setLabel(resources.getString(147) + ' ');
                break;
            }
            default: {
                this.setLabel(resources.getString(80) + ' ');
                addressType = 1;
            }
        }
        this.addressType = addressType;
    }

    public int getAddressType() {
        return this.addressType;
    }

    private void setAddressMode(int addressMode) {
        this.addressMode = addressMode;
        switch (addressMode) {
            case 1: {
                super.setText(this.address);
                super.setEditable(true);
                break;
            }
            case 2: {
                super.setText(this.name);
                super.setEditable(false);
            }
        }
        this.invalidate();
    }

    public String getText() {
        return StringParser.mergeRecipient(this.name, this.address);
    }

    public void setText(String text) {
        String[] recipient = StringParser.parseRecipient(text);
        this.name = recipient[0];
        this.address = recipient[1];
        if (this.address.length() == 0) {
            this.setAddressMode(1);
            return;
        }
        if (this.name != null) {
            this.setAddressMode(2);
        } else {
            this.setAddressMode(1);
        }
    }

    protected void makeContextMenu(ContextMenu contextMenu) {
        if (this.addressMode == 2) {
            contextMenu.addItem(this.addressPropertiesMenuItem);
        }
        contextMenu.addItem(this.addressBookMenuItem);
    }

    protected boolean keyChar(char key, int status, int time) {
        boolean result = false;
        if (this.addressMode == 2 && status == 0) {
            switch (key) {
                case '\b': 
                case '\u007f': {
                    this.name = null;
                    this.address = "";
                    this.setAddressMode(1);
                    this.setFocus();
                    result = true;
                }
            }
        } else {
            block3 : switch (key) {
                case ' ': {
                    if (this.address.indexOf(64) == -1) {
                        result = super.keyChar('@', status, time);
                        break;
                    }
                    result = super.keyChar('.', status, time);
                    break;
                }
                default: {
                    for (int i = 0; i < invalidChars.length; ++i) {
                        if (key != invalidChars[i]) continue;
                        result = true;
                        break block3;
                    }
                }
            }
        }
        if (!result) {
            result = super.keyChar(key, status, time);
        }
        return result;
    }

    protected void fieldChangeNotify(int context) {
        if (this.addressMode == 1) {
            this.address = super.getText();
        }
        super.fieldChangeNotify(context);
    }

    private void addressProperties() {
        String localName = this.name;
        String localAddress = this.address;
        EmailAddressPropertiesDialog dialog = new EmailAddressPropertiesDialog(localName, localAddress);
        if (!(dialog.doModal() != 0 || localName.equals(dialog.getName()) && localAddress.equals(dialog.getAddress()))) {
            localName = dialog.getName();
            localAddress = dialog.getAddress();
            this.name = localName.length() > 0 ? localName : null;
            this.address = localAddress;
            if (this.name != null) {
                this.setAddressMode(2);
            } else {
                this.setAddressMode(1);
            }
        }
    }

    private void addressBookChooser() {
        Contact contact = null;
        try {
            BlackBerryContactList list = (BlackBerryContactList)PIM.getInstance().openPIMList(1, 3);
            PIMItem item = list.choose();
            if (item instanceof Contact) {
                contact = (Contact)item;
            } else if (item instanceof BlackBerryContactGroup) {
                BlackBerryContactGroup contactGroup = (BlackBerryContactGroup)item;
                this.addContactGroup(contactGroup);
            }
        }
        catch (PIMException e) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to open contact list:\r\n" + e.toString()).getBytes(), (int)2);
            return;
        }
        if (contact != null) {
            String[] values = contact.getStringArray(106, 0);
            String contactName = values[1] + ' ' + values[0];
            int count = contact.countValues(103);
            Object[] contactEmail = new String[count];
            for (int i = 0; i < count; ++i) {
                contactEmail[i] = contact.getString(103, i);
            }
            if (count > 1) {
                Dialog addressDialog = new Dialog(resources.getString(139), contactEmail, null, 0, Bitmap.getPredefinedBitmap((int)1));
                int choice = addressDialog.doModal();
                if (choice != -1) {
                    this.address = contactEmail[choice];
                    this.name = contactName;
                    this.setAddressMode(2);
                }
            } else if (count == 1) {
                this.address = contactEmail[0];
                this.name = contactName;
                this.setAddressMode(2);
            } else {
                Dialog.alert((String)resources.getString(140));
            }
        }
    }

    private void addContactGroup(BlackBerryContactGroup contactGroup) {
        Dialog.alert((String)resources.getString(141));
    }
}

