/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.ListFieldCallback;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.util.IntVector;

public class FolderSelectionDialog
extends Dialog {
    private static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private RichTextField dialogLabelField;
    private ListField folderListField;
    private static String ROOT_URL = "file:///";
    private static String PREV_FOLDER = "..";
    private static String PATH_SEPARATOR = "/";
    private static final int TYPE_ROOT = 0;
    private static final int TYPE_FOLDER = 1;
    private static final int TYPE_OPTION_SELECT = 2;
    private String dialogTitleBase;
    private String folderUrl;
    private Vector folderList;
    private IntVector elementTypeList;
    private Bitmap rootBitmap = Bitmap.getBitmapResource((String)"fs_root.png");
    private Bitmap folderBitmap = Bitmap.getBitmapResource((String)"folder.png");
    private Bitmap optionSelectBitmap = Bitmap.getBitmapResource((String)"fs_save.png");
    private ListFieldCallback folderListFieldCallback = new ListFieldCallback(){

        public void drawListRow(ListField listField, Graphics graphics, int index, int y, int width) {
            int rowHeight = FolderSelectionDialog.this.folderListField.getRowHeight();
            int fontHeight = graphics.getFont().getHeight();
            String elementName = FolderSelectionDialog.this.folderList.elementAt(index).toString();
            int elementType = FolderSelectionDialog.this.elementTypeList.elementAt(index);
            Bitmap icon = elementType == 2 ? FolderSelectionDialog.this.optionSelectBitmap : (elementType == 0 ? FolderSelectionDialog.this.rootBitmap : FolderSelectionDialog.this.folderBitmap);
            int iconSide = icon.getWidth();
            graphics.drawBitmap(rowHeight / 2 - iconSide / 2, y + (fontHeight / 2 - iconSide / 2), iconSide, iconSide, icon, 0, 0);
            int indent = iconSide + iconSide / 2;
            graphics.drawText(elementName, indent, y, 64, width - indent);
        }

        public Object get(ListField listField, int index) {
            return FolderSelectionDialog.this.folderList.elementAt(index);
        }

        public int getPreferredWidth(ListField listField) {
            return 0;
        }

        public int indexOfList(ListField listField, String prefix, int start) {
            return 0;
        }
    };

    public FolderSelectionDialog() {
        super("", null, null, 0, null, 0x100000000000L);
        this.dialogTitleBase = resources.getString(155) + '\n';
        this.dialogLabelField = this.getLabel();
        this.folderUrl = ROOT_URL;
        this.folderList = new Vector();
        this.elementTypeList = new IntVector();
        this.setEscapeEnabled(true);
        this.initFields();
        this.populateFolderList();
    }

    private void initFields() {
        this.folderListField = new ListField();
        this.folderListField.setCallback(this.folderListFieldCallback);
        this.add((Field)this.folderListField);
    }

    public void setFolderUrl(String folderUrl) {
        this.folderUrl = folderUrl;
        if (!this.populateFolderList()) {
            this.folderUrl = ROOT_URL;
            this.populateFolderList();
        }
    }

    public String getFolderUrl() {
        return this.folderUrl;
    }

    private boolean populateFolderList() {
        boolean result;
        this.folderList.removeAllElements();
        this.elementTypeList.removeAllElements();
        this.folderListField.setSize(0);
        this.dialogLabelField.setText(this.dialogTitleBase + this.folderUrl.substring(ROOT_URL.length() - 1));
        if (this.folderUrl.equals(ROOT_URL)) {
            Enumeration e = FileSystemRegistry.listRoots();
            while (e.hasMoreElements()) {
                String root = (String)e.nextElement();
                this.folderList.addElement(root);
                this.elementTypeList.addElement(0);
            }
            result = true;
        } else {
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)this.folderUrl);
                if (fileConnection.canWrite()) {
                    this.folderList.addElement(resources.getString(154));
                    this.elementTypeList.addElement(2);
                }
                this.folderList.addElement(PREV_FOLDER);
                this.elementTypeList.addElement(1);
                Enumeration e = fileConnection.list();
                while (e.hasMoreElements()) {
                    String file = (String)e.nextElement();
                    if (!file.endsWith(PATH_SEPARATOR)) continue;
                    this.folderList.addElement(file);
                    this.elementTypeList.addElement(1);
                }
                result = true;
            }
            catch (IOException e) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to open: " + this.folderUrl).getBytes(), (int)2);
                if (this.folderList.size() == 0) {
                    this.folderList.addElement(PREV_FOLDER);
                    this.elementTypeList.addElement(1);
                }
                result = false;
            }
        }
        this.folderListField.setSize(this.folderList.size());
        return result;
    }

    private void selectFolder() {
        int index = this.folderListField.getSelectedIndex();
        String selectedItem = (String)this.folderList.elementAt(index);
        int selectedType = this.elementTypeList.elementAt(index);
        if (selectedType == 2) {
            this.select(0);
        } else {
            if (selectedItem.equals(PREV_FOLDER)) {
                this.folderUrl = this.folderUrl.substring(0, this.folderUrl.lastIndexOf(47, this.folderUrl.length() - 2) + 1);
                if (this.folderUrl.length() < ROOT_URL.length()) {
                    this.folderUrl = ROOT_URL;
                }
            } else {
                this.folderUrl = this.folderUrl + selectedItem;
            }
            this.populateFolderList();
        }
    }

    protected boolean trackwheelUnclick(int status, int time) {
        this.selectFolder();
        return true;
    }

    protected boolean keyChar(char key, int status, int time) {
        if (key == '\n') {
            this.selectFolder();
            return true;
        }
        return super.keyChar(key, status, time);
    }
}

