/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Hashtable;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.MailHomeListener;
import org.logicprobe.LogicMail.ui.MailHomeView;
import org.logicprobe.LogicMail.ui.NodeIcons;

public class MailHomeScreen
extends BaseScreen
implements MailHomeView {
    private MailHomeListener listener;
    private TreeField treeField;
    private MenuItem selectFolderItem;
    private MenuItem refreshStatusItem;
    private MenuItem refreshFoldersItem;
    private MenuItem compositionItem;
    private MenuItem disconnectItem;
    private Hashtable nodeIdMap;

    public MailHomeScreen() {
        super(null, BaseScreen.resources.getString(64));
        this.initFields();
        this.initMenuItems();
        this.nodeIdMap = new Hashtable();
    }

    private void initFields() {
        this.treeField = new TreeField(new TreeFieldCallback(){

            public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
                MailHomeScreen.this.treeField_DrawTreeItem(treeField, graphics, node, y, width, indent);
            }
        }, 0x40000000000000L);
        this.treeField.setEmptyString(BaseScreen.resources.getString(65), 0);
        this.treeField.setDefaultExpanded(true);
        this.treeField.setIndentWidth(20);
        this.add((Field)this.treeField);
    }

    private void initMenuItems() {
        this.selectFolderItem = new ContextMenuItem(1, BaseScreen.resources, 66, 100, 8);
        this.refreshStatusItem = new ContextMenuItem(2, BaseScreen.resources, 68, 110, 10);
        this.refreshFoldersItem = new ContextMenuItem(4, BaseScreen.resources, 67, 111, 10);
        this.compositionItem = new ContextMenuItem(8, BaseScreen.resources, 73, 200000, 9);
        this.disconnectItem = new ContextMenuItem(16, BaseScreen.resources, 69, 200000, 9);
    }

    public void setMailHomeListener(MailHomeListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateMailTree(MailHomeView.TreeNode rootNode) {
        Object object = Application.getEventLock();
        synchronized (object) {
            this.treeField.deleteAll();
            this.nodeIdMap.clear();
            int firstNode = -1;
            MailHomeView.TreeNode[] nodes = rootNode.children;
            if (nodes != null) {
                for (int i = nodes.length - 1; i >= 0; --i) {
                    int id = this.treeField.addChildNode(0, (Object)nodes[i]);
                    this.nodeIdMap.put(nodes[i], new Integer(id));
                    if (i == 0) {
                        firstNode = id;
                    }
                    this.populateMailTreeChildren(id, nodes[i]);
                }
            }
            if (firstNode != -1) {
                this.treeField.setCurrentNode(firstNode);
            }
        }
    }

    private void populateMailTreeChildren(int parent, MailHomeView.TreeNode node) {
        if (node.children != null) {
            for (int i = node.children.length - 1; i >= 0; --i) {
                int id = this.treeField.addChildNode(parent, (Object)node.children[i]);
                this.nodeIdMap.put(node.children[i], new Integer(id));
                this.populateMailTreeChildren(id, node.children[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMailTreeNode(MailHomeView.TreeNode node) {
        Integer nodeInt = (Integer)this.nodeIdMap.get(node);
        if (nodeInt != null) {
            Object object = Application.getEventLock();
            synchronized (object) {
                this.treeField.invalidateNode(nodeInt.intValue());
            }
        }
    }

    public boolean onClose() {
        this.tryShutdownApplication();
        return false;
    }

    protected void onVisibilityChange(boolean visible) {
        super.onVisibilityChange(visible);
        if (this.listener != null) {
            this.listener.handleVisibilityChange(visible);
        }
    }

    protected void makeMenu(Menu menu, int instance) {
        if (this.listener != null) {
            int menuItems = this.listener.getContextMenuItems((MailHomeView.TreeNode)this.treeField.getCookie(this.treeField.getCurrentNode()));
            if ((menuItems & 1) != 0) {
                menu.add(this.selectFolderItem);
            }
            if ((menuItems & 2) != 0) {
                menu.add(this.refreshStatusItem);
            }
            if ((menuItems & 4) != 0) {
                menu.add(this.refreshFoldersItem);
            }
            if ((menuItems & 8) != 0) {
                menu.add(this.compositionItem);
            }
            if ((menuItems & 0x10) != 0) {
                menu.add(this.disconnectItem);
            }
        }
        super.makeMenu(menu, instance);
    }

    protected boolean navigationClick(int status, int time) {
        this.selectFolderItem.run();
        return true;
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': {
                this.selectFolderItem.run();
                retval = true;
                break;
            }
            case ' ': {
                this.toggleSelectedNode();
                retval = true;
            }
        }
        return retval;
    }

    private void toggleSelectedNode() {
        int curNode = this.treeField.getCurrentNode();
        if (curNode == -1) {
            return;
        }
        if (this.treeField.getFirstChild(curNode) == -1) {
            return;
        }
        this.treeField.setExpanded(curNode, !this.treeField.getExpanded(curNode));
    }

    private void treeField_DrawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        MailHomeView.TreeNode treeNode = (MailHomeView.TreeNode)treeField.getCookie(node);
        int rowHeight = treeField.getRowHeight();
        int fontHeight = graphics.getFont().getHeight();
        Bitmap icon = NodeIcons.getIcon(treeNode.node);
        graphics.drawBitmap(indent + (rowHeight / 2 - icon.getWidth() / 2), y + (fontHeight / 2 - icon.getWidth() / 2), icon.getWidth(), icon.getHeight(), icon, 0, 0);
        Font origFont = graphics.getFont();
        StringBuffer buf = new StringBuffer();
        buf.append(treeNode.node.toString());
        if (treeNode.type == 1) {
            graphics.setFont(origFont.derive(1));
        } else if (treeNode.type == 2) {
            int unseenCount;
            MailboxNode mailboxNode = (MailboxNode)treeNode.node;
            if (!mailboxNode.isSelectable()) {
                graphics.setFont(origFont.derive(2));
            }
            if ((unseenCount = mailboxNode.getUnseenMessageCount()) > 0) {
                buf.append(" (");
                buf.append(unseenCount);
                buf.append(")");
                graphics.setFont(origFont.derive(1));
            } else {
                graphics.setFont(origFont.derive(0));
            }
        }
        graphics.drawText(buf.toString(), indent + rowHeight, y, 64, width);
    }

    private class ContextMenuItem
    extends MenuItem {
        private int menuItemId;

        public ContextMenuItem(int menuItemId, ResourceBundle bundle, int id, int ordinal, int priority) {
            super(bundle, id, ordinal, priority);
            this.menuItemId = menuItemId;
        }

        public void run() {
            int nodeId = MailHomeScreen.this.treeField.getCurrentNode();
            if (MailHomeScreen.this.listener != null && nodeId != -1) {
                MailHomeScreen.this.listener.handleContextMenuItem(this.menuItemId, (MailHomeView.TreeNode)MailHomeScreen.this.treeField.getCookie(nodeId));
            }
        }
    }
}

