/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;

public class MailboxSeparatorField
extends Field {
    private String text;

    public MailboxSeparatorField(String text, long style) {
        super(style);
        this.text = text;
    }

    public MailboxSeparatorField(long style) {
        this("", style);
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public int getPreferredHeight() {
        return Font.getDefault().getHeight();
    }

    protected void layout(int width, int height) {
        this.setExtent(width, this.getPreferredHeight());
    }

    protected void onUnfocus() {
        super.invalidate();
        super.onUnfocus();
    }

    protected void paint(Graphics graphics) {
        boolean isFocus = this.isFocus();
        int width = this.getWidth();
        int height = this.getHeight();
        int originalColor = graphics.getColor();
        int textWidth = Font.getDefault().getAdvance(this.text);
        int textX = width / 2 - textWidth / 2;
        if (textX <= 0) {
            textX = 0;
            textWidth = width;
        }
        if (!isFocus) {
            for (int i = 0; i < height; ++i) {
                int color = 255 - i;
                graphics.setColor(color * 65536 + color * 256 + color);
                graphics.drawLine(0, i, width, i);
            }
        }
        graphics.setColor(0xA9A9A9);
        graphics.drawLine(0, height - 1, width, height - 1);
        graphics.setColor(originalColor);
        graphics.drawText(this.text, textX, 0, 64, textWidth);
    }
}

