/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.NullField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.component.Status;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import net.rim.device.api.ui.container.VerticalFieldManager;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.message.ContentPart;
import org.logicprobe.LogicMail.message.MimeMessageContent;
import org.logicprobe.LogicMail.message.MimeMessagePart;
import org.logicprobe.LogicMail.message.MimeMessagePartTransformer;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.Address;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.BorderedFieldManager;
import org.logicprobe.LogicMail.ui.BrowserFieldManager;
import org.logicprobe.LogicMail.ui.FileSaveDialog;
import org.logicprobe.LogicMail.ui.MailboxSelectionDialog;
import org.logicprobe.LogicMail.ui.MessageFieldFactory;
import org.logicprobe.LogicMail.ui.MessageIcons;
import org.logicprobe.LogicMail.ui.MessagePropertiesScreen;
import org.logicprobe.LogicMail.ui.NavigationController;
import org.logicprobe.LogicMail.util.UnicodeNormalizer;

public class MessageScreen
extends BaseScreen {
    private BorderedFieldManager addressFieldManager;
    private BorderedFieldManager subjectFieldManager;
    private TreeField attachmentsTreeField;
    private VerticalFieldManager messageFieldManager;
    private AccountConfig accountConfig;
    private MessageNode messageNode;
    private boolean isSentFolder;
    private boolean messageRendered;
    private UnicodeNormalizer unicodeNormalizer;
    private MessageNodeListener messageNodeListener = new MessageNodeListener(){

        public void messageStatusChanged(MessageNodeEvent e) {
            MessageScreen.this.messageNode_MessageStatusChanged(e);
        }
    };
    private FieldChangeListener fieldChangeListener = new FieldChangeListener(){

        public void fieldChanged(Field field, int context) {
            MessageScreen.this.message_FieldChanged(field, context);
        }
    };
    private MenuItem saveAttachmentItem = new MenuItem(BaseScreen.resources, 156, 100, 10){

        public void run() {
            int node = MessageScreen.this.attachmentsTreeField.getCurrentNode();
            if (node != -1 && MessageScreen.this.attachmentsTreeField.getCookie(node) instanceof ContentPart) {
                MessageScreen.this.saveAttachment((ContentPart)MessageScreen.this.attachmentsTreeField.getCookie(node));
            }
        }
    };
    private MenuItem propsItem = new MenuItem(BaseScreen.resources, 70, 105, 10){

        public void run() {
            MessagePropertiesScreen screen = new MessagePropertiesScreen(MessageScreen.this.messageNode);
            UiApplication.getUiApplication().pushScreen((Screen)screen);
        }
    };
    private MenuItem replyItem = new MenuItem(BaseScreen.resources, 85, 110, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                MessageScreen.this.getNavigationController().displayCompositionReply(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, false);
            }
        }
    };
    private MenuItem replyAllItem = new MenuItem(BaseScreen.resources, 86, 115, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                MessageScreen.this.getNavigationController().displayCompositionReply(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, true);
            }
        }
    };
    private MenuItem forwardItem = new MenuItem(BaseScreen.resources, 87, 120, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                MessageScreen.this.getNavigationController().displayCompositionForward(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode);
            }
        }
    };
    private MenuItem copyToItem = new MenuItem(BaseScreen.resources, 92, 125, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
                MailboxSelectionDialog dialog = new MailboxSelectionDialog(BaseScreen.resources.getString(94), accountNodes);
                dialog.setSelectedMailboxNode(MessageScreen.this.messageNode.getParent());
                dialog.addUnselectableNode(MessageScreen.this.messageNode.getParent());
                dialog.doModal();
                MailboxNode selectedMailbox = dialog.getSelectedMailboxNode();
                if (selectedMailbox != null && selectedMailbox != MessageScreen.this.messageNode.getParent()) {
                    selectedMailbox.appendMessage(MessageScreen.this.messageNode);
                }
            }
        }
    };
    private MenuItem moveToItem = new MenuItem(BaseScreen.resources, 93, 130, 10){

        public void run() {
            if (MessageScreen.this.messageNode.hasMessageContent()) {
                AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
                MailboxSelectionDialog dialog = new MailboxSelectionDialog(BaseScreen.resources.getString(95), accountNodes);
                dialog.setSelectedMailboxNode(MessageScreen.this.messageNode.getParent());
                dialog.addUnselectableNode(MessageScreen.this.messageNode.getParent());
                dialog.doModal();
                MailboxNode selectedMailbox = dialog.getSelectedMailboxNode();
                if (selectedMailbox != null && selectedMailbox != MessageScreen.this.messageNode.getParent()) {
                    selectedMailbox.appendMessage(MessageScreen.this.messageNode);
                }
            }
        }
    };
    private MenuItem compositionItem = new MenuItem(BaseScreen.resources, 73, 150, 10){

        public void run() {
            MessageScreen.this.getNavigationController().displayComposition(MessageScreen.this.messageNode.getParent().getParentAccount());
        }
    };
    private MenuItem closeItem = new MenuItem(BaseScreen.resources, 3, 200000, 10){

        public void run() {
            MessageScreen.this.onClose();
        }
    };

    public MessageScreen(NavigationController navigationController, MessageNode messageNode) {
        super(navigationController, 0x100000000000L);
        int mailboxType;
        this.messageNode = messageNode;
        this.accountConfig = messageNode.getParent().getParentAccount().getAccountConfig();
        if (MailSettings.getInstance().getGlobalConfig().getUnicodeNormalization()) {
            this.unicodeNormalizer = UnicodeNormalizer.getInstance();
        }
        this.isSentFolder = (mailboxType = messageNode.getParent().getType()) == 4 || mailboxType == 2;
        this.initFields();
    }

    private void initFields() {
        String subject;
        this.addressFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_NONE);
        this.subjectFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_LINE);
        this.messageFieldManager = new VerticalFieldManager();
        if (this.isSentFolder) {
            Address[] to = this.messageNode.getTo();
            if (to != null && to.length > 0) {
                this.addressFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(80) + " " + this.normalize(to[0].toString())));
                if (to.length > 1) {
                    for (int i = 1; i < to.length; ++i) {
                        if (to[i] == null) continue;
                        this.addressFieldManager.add((Field)new RichTextField("    " + this.normalize(to[i].toString())));
                    }
                }
            }
        } else {
            Address[] from = this.messageNode.getFrom();
            if (from != null && from.length > 0) {
                this.addressFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(78) + " " + this.normalize(from[0].toString())));
                if (from.length > 1) {
                    for (int i = 1; i < from.length; ++i) {
                        if (from[i] == null) continue;
                        this.addressFieldManager.add((Field)new RichTextField("      " + this.normalize(from[i].toString())));
                    }
                }
            }
        }
        if ((subject = this.messageNode.getSubject()) != null) {
            this.subjectFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(76) + " " + this.normalize(subject)));
        }
        this.add((Field)this.addressFieldManager);
        this.add((Field)this.subjectFieldManager);
        this.add((Field)this.messageFieldManager);
    }

    protected void onDisplay() {
        super.onDisplay();
        this.messageNode.addMessageNodeListener(this.messageNodeListener);
        if (!this.messageNode.hasMessageContent()) {
            if (!this.messageNode.refreshMessage()) {
                this.renderMessage();
            }
        } else if (!this.messageRendered) {
            this.renderMessage();
        }
    }

    protected void onUndisplay() {
        this.messageNode.removeMessageNodeListener(this.messageNodeListener);
        super.onUndisplay();
    }

    protected void makeMenu(Menu menu, int instance) {
        int node;
        if (this.getFieldWithFocus() == this.messageFieldManager && this.messageFieldManager.getFieldWithFocus() == this.attachmentsTreeField && (node = this.attachmentsTreeField.getCurrentNode()) != -1 && this.attachmentsTreeField.getCookie(node) instanceof MimeMessagePart) {
            menu.add(this.saveAttachmentItem);
        }
        menu.add(this.propsItem);
        menu.addSeparator();
        if (this.accountConfig != null && this.accountConfig.getOutgoingConfig() != null) {
            menu.add(this.replyItem);
            if (this.accountConfig.getIdentityConfig() != null) {
                menu.add(this.replyAllItem);
            }
            menu.add(this.forwardItem);
            menu.add(this.compositionItem);
        }
        menu.add(this.copyToItem);
        menu.add(this.moveToItem);
        menu.addSeparator();
        menu.add(this.closeItem);
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': 
            case ' ': {
                if (this.getFieldWithFocus() == this.messageFieldManager && this.messageFieldManager.getFieldWithFocus() == this.attachmentsTreeField) {
                    int node = this.attachmentsTreeField.getCurrentNode();
                    if (node == -1) break;
                    if (this.attachmentsTreeField.getCookie(node) instanceof ContentPart) {
                        this.saveAttachment((ContentPart)this.attachmentsTreeField.getCookie(node));
                        retval = true;
                        break;
                    }
                    if (this.attachmentsTreeField.getFirstChild(node) == -1) break;
                    this.attachmentsTreeField.setExpanded(node, !this.attachmentsTreeField.getExpanded(node));
                    retval = true;
                    break;
                }
                if (status == 0) {
                    this.scroll(512);
                    retval = true;
                    break;
                }
                if (status != 1) break;
                this.scroll(256);
                retval = true;
            }
        }
        return retval;
    }

    private void messageNode_MessageStatusChanged(MessageNodeEvent e) {
        if (e.getType() == 1) {
            this.renderMessage();
        }
    }

    private void renderMessage() {
        int i;
        Vector<Object> messageFields = new Vector<Object>();
        MimeMessagePart[] attachmentParts = this.messageNode.getAttachmentParts();
        if (attachmentParts.length > 0) {
            this.attachmentsTreeField = new TreeField(new TreeFieldCallback(){

                public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
                    MessageScreen.this.attachmentsTreeField_DrawTreeItem(treeField, graphics, node, y, width, indent);
                }
            }, 0x40000000000000L);
            this.attachmentsTreeField.setDefaultExpanded(false);
            int id = this.attachmentsTreeField.addChildNode(0, (Object)BaseScreen.resources.getString(149));
            for (i = attachmentParts.length - 1; i >= 0; --i) {
                this.attachmentsTreeField.addChildNode(id, (Object)attachmentParts[i]);
            }
            messageFields.addElement(this.attachmentsTreeField);
        }
        MimeMessagePart[] displayableParts = MimeMessagePartTransformer.getDisplayableParts(this.messageNode.getMessageStructure());
        for (i = 0; i < displayableParts.length; ++i) {
            MimeMessageContent content = this.messageNode.getMessageContent(displayableParts[i]);
            if (content == null) continue;
            Field field = MessageFieldFactory.createMessageField(this.messageNode, content);
            messageFields.addElement(field);
        }
        if (messageFields.size() == 0) {
            messageFields.addElement(new RichTextField(BaseScreen.resources.getString(88)));
        }
        this.drawMessageFields(messageFields);
        this.messageRendered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMessageFields(Vector messageFields) {
        if (messageFields == null) {
            return;
        }
        int size = messageFields.size();
        Object object = Application.getEventLock();
        synchronized (object) {
            int i;
            this.messageFieldManager.deleteAll();
            for (i = 0; i < size; ++i) {
                if (messageFields.elementAt(i) != null) {
                    this.messageFieldManager.add((Field)messageFields.elementAt(i));
                }
                if (i == size - 1) continue;
                this.messageFieldManager.add((Field)new SeparatorField());
            }
            this.messageFieldManager.add((Field)new NullField(0x40000000000000L));
            for (i = 0; i < size; ++i) {
                Field field = (Field)messageFields.elementAt(i);
                if (field == null) continue;
                MessageFieldFactory.handleRenderedField(field);
                field.setChangeListener(this.fieldChangeListener);
            }
        }
    }

    private void saveAttachment(ContentPart contentPart) {
        MimeMessageContent content = this.messageNode.getMessageContent(contentPart);
        FileSaveDialog dialog = new FileSaveDialog(contentPart.getName());
        if (dialog.doModal() != -1) {
            if (content != null) {
                new SaveAttachmentThread(content, dialog.getFileUrl()).start();
                Status.show((String)BaseScreen.resources.getString(159));
            } else {
                Status.show((String)"Attachment has not been downloaded from the server");
            }
        }
    }

    private void attachmentsTreeField_DrawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        Object cookie = this.attachmentsTreeField.getCookie(node);
        if (cookie instanceof ContentPart) {
            Bitmap icon;
            int partSize;
            ContentPart messagePart = (ContentPart)cookie;
            StringBuffer buf = new StringBuffer();
            buf.append(messagePart.getName());
            if (buf.length() == 0) {
                buf.append(messagePart.getMimeType());
                buf.append('/');
                buf.append(messagePart.getMimeSubtype());
            }
            if ((partSize = messagePart.getSize()) > 0) {
                buf.append(" (");
                if (partSize < 1024) {
                    buf.append(partSize);
                    buf.append('B');
                } else {
                    buf.append(partSize /= 1024);
                    buf.append("kB");
                }
                buf.append(')');
            }
            if ((icon = MessageIcons.getIcon(messagePart)) != null) {
                int rowHeight = treeField.getRowHeight();
                int fontHeight = graphics.getFont().getHeight();
                graphics.drawBitmap(indent + (rowHeight / 2 - icon.getWidth() / 2), y + (fontHeight / 2 - icon.getWidth() / 2), icon.getWidth(), icon.getHeight(), icon, 0, 0);
                indent += rowHeight;
            }
            Font originalFont = graphics.getFont();
            Font displayFont = this.messageNode.getMessageContent(messagePart) != null ? originalFont.derive(1) : originalFont;
            graphics.setFont(displayFont);
            graphics.drawText(buf.toString(), indent, y, 64, width);
            graphics.setFont(originalFont);
        } else {
            graphics.drawText(cookie.toString(), indent, y, 64, width);
        }
    }

    private void message_FieldChanged(Field field, int context) {
        if (field instanceof BrowserFieldManager && (context & 1) != 0) {
            String address = ((BrowserFieldManager)field).getSelectedToken();
            this.getNavigationController().displayComposition(this.messageNode.getParent().getParentAccount(), address);
        }
    }

    private String normalize(String input) {
        if (this.unicodeNormalizer == null) {
            return input;
        }
        return this.unicodeNormalizer.normalize(input);
    }

    private static class SaveAttachmentThread
    extends Thread {
        private MimeMessageContent content;
        private String fileUrl;

        public SaveAttachmentThread(MimeMessageContent content, String fileUrl) {
            this.content = content;
            this.fileUrl = fileUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean success = false;
            byte[] rawData = this.content.getRawData();
            if (rawData != null) {
                try {
                    FileConnection fileConnection = (FileConnection)Connector.open((String)this.fileUrl);
                    fileConnection.create();
                    DataOutputStream outputStream = fileConnection.openDataOutputStream();
                    ((OutputStream)outputStream).write(rawData);
                    outputStream.close();
                    fileConnection.close();
                    success = true;
                }
                catch (IOException e) {
                    EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to save: " + this.fileUrl).getBytes(), (int)2);
                    success = false;
                }
            } else {
                success = false;
            }
            if (!success) {
                Object object = Application.getEventLock();
                synchronized (object) {
                    Status.show((String)BaseScreen.resources.getString(160));
                }
            }
        }
    }
}

