/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.system.Bitmap;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.model.NodeVisitor;

public class NodeIcons {
    private static NodeIcons instance = new NodeIcons();
    private NodeIconVisitor visitor = new NodeIconVisitor();
    private Bitmap localAccountIcon = Bitmap.getBitmapResource((String)"account_local.png");
    private Bitmap networkAccountIcon0 = Bitmap.getBitmapResource((String)"account_network_offline.png");
    private Bitmap networkAccountIcon1 = Bitmap.getBitmapResource((String)"account_network_online.png");
    private Bitmap folderIcon = Bitmap.getBitmapResource((String)"folder.png");
    private Bitmap folderNewIcon = Bitmap.getBitmapResource((String)"folder_new.png");
    private Bitmap inboxFolderIcon = Bitmap.getBitmapResource((String)"folder_inbox.png");
    private Bitmap inboxNewFolderIcon = Bitmap.getBitmapResource((String)"folder_inbox_new.png");
    private Bitmap outboxFolderIcon = Bitmap.getBitmapResource((String)"folder_outbox.png");
    private Bitmap draftsFolderIcon = Bitmap.getBitmapResource((String)"folder_drafts.png");
    private Bitmap sentFolderIcon = Bitmap.getBitmapResource((String)"folder_sent.png");
    private Bitmap trashFolderIcon = Bitmap.getBitmapResource((String)"folder_trash.png");
    private Bitmap trashFullFolderIcon = Bitmap.getBitmapResource((String)"folder_trash_full.png");
    private Bitmap openedMessageIcon = Bitmap.getBitmapResource((String)"mail_opened.png");
    private Bitmap unopenedMessageIcon = Bitmap.getBitmapResource((String)"mail_unopened.png");
    private Bitmap repliedMessageIcon = Bitmap.getBitmapResource((String)"mail_replied.png");
    private Bitmap flaggedMessageIcon = Bitmap.getBitmapResource((String)"mail_flagged.png");
    private Bitmap draftMessageIcon = Bitmap.getBitmapResource((String)"mail_draft.png");
    private Bitmap deletedMessageIcon = Bitmap.getBitmapResource((String)"mail_deleted.png");
    private Bitmap unknownMessageIcon = Bitmap.getBitmapResource((String)"mail_unknown.png");
    private Bitmap junkMessageIcon = Bitmap.getBitmapResource((String)"mail_junk.png");
    public static final int ICON_FOLDER = 0;

    private NodeIcons() {
    }

    public static Bitmap getIcon(Node node) {
        return instance.getIconImpl(node);
    }

    public static Bitmap getIcon(int type) {
        return instance.getIconImpl(type);
    }

    private Bitmap getIconImpl(Node node) {
        this.visitor.clearIcon();
        node.accept(this.visitor);
        return this.visitor.getIcon();
    }

    private Bitmap getIconImpl(int type) {
        Bitmap icon;
        switch (type) {
            case 0: {
                icon = this.folderIcon;
                break;
            }
            default: {
                icon = null;
            }
        }
        return icon;
    }

    private class NodeIconVisitor
    implements NodeVisitor {
        private Bitmap icon;

        private NodeIconVisitor() {
        }

        public void visit(MailRootNode node) {
        }

        public void visit(AccountNode node) {
            switch (node.getStatus()) {
                case 0: {
                    this.icon = NodeIcons.this.localAccountIcon;
                    break;
                }
                case 1: {
                    this.icon = NodeIcons.this.networkAccountIcon0;
                    break;
                }
                case 2: {
                    this.icon = NodeIcons.this.networkAccountIcon1;
                }
            }
        }

        public void visit(MailboxNode node) {
            switch (node.getType()) {
                case 1: {
                    if (node.getUnseenMessageCount() > 0) {
                        this.icon = NodeIcons.this.inboxNewFolderIcon;
                        break;
                    }
                    this.icon = NodeIcons.this.inboxFolderIcon;
                    break;
                }
                case 3: {
                    this.icon = NodeIcons.this.draftsFolderIcon;
                    break;
                }
                case 4: {
                    this.icon = NodeIcons.this.sentFolderIcon;
                    break;
                }
                case 5: {
                    if (node.getMessageCount() > 0) {
                        this.icon = NodeIcons.this.trashFullFolderIcon;
                        break;
                    }
                    this.icon = NodeIcons.this.trashFolderIcon;
                    break;
                }
                case 2: {
                    this.icon = NodeIcons.this.outboxFolderIcon;
                    break;
                }
                default: {
                    this.icon = node.getUnseenMessageCount() > 0 ? NodeIcons.this.folderNewIcon : NodeIcons.this.folderIcon;
                }
            }
        }

        public void visit(MessageNode node) {
            int flags = node.getFlags();
            this.icon = (flags & 8) != 0 ? NodeIcons.this.deletedMessageIcon : ((flags & 0x40) != 0 ? NodeIcons.this.junkMessageIcon : ((flags & 2) != 0 ? NodeIcons.this.repliedMessageIcon : ((flags & 4) != 0 ? NodeIcons.this.flaggedMessageIcon : ((flags & 0x10) != 0 ? NodeIcons.this.draftMessageIcon : ((flags & 0x20) != 0 ? NodeIcons.this.unopenedMessageIcon : ((flags & 1) != 0 ? NodeIcons.this.openedMessageIcon : NodeIcons.this.unknownMessageIcon))))));
        }

        public void clearIcon() {
            this.icon = null;
        }

        public Bitmap getIcon() {
            return this.icon;
        }
    }
}

