/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.PasswordEditField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.text.TextFilter;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.ui.AbstractConfigScreen;

public class OutgoingConfigScreen
extends AbstractConfigScreen {
    private BasicEditField acctNameField;
    private BasicEditField serverNameField;
    private CheckboxField serverSslField;
    private BasicEditField serverPortField;
    private ObjectChoiceField useAuthField;
    private BasicEditField serverUserField;
    private PasswordEditField serverPassField;
    private CheckboxField useMdsField;
    private ButtonField saveButton;
    private LabelField statusLabel;
    private boolean acctSaved;
    private OutgoingConfig outgoingConfig;

    public OutgoingConfigScreen(OutgoingConfig outgoingConfig) {
        super("LogicMail - " + AbstractConfigScreen.resources.getString(61));
        this.outgoingConfig = outgoingConfig;
        this.acctSaved = false;
        this.initFields();
        if (outgoingConfig.getUseAuth() == 0) {
            this.serverUserField.setEditable(false);
            this.serverPassField.setEditable(false);
            this.serverUserField.setText("");
            this.serverPassField.setText("");
        }
    }

    private void initFields() {
        this.acctNameField = new BasicEditField(AbstractConfigScreen.resources.getString(22) + " ", this.outgoingConfig.getAcctName());
        this.serverNameField = new BasicEditField(AbstractConfigScreen.resources.getString(23) + " ", this.outgoingConfig.getServerName());
        this.serverSslField = new CheckboxField("SSL", this.outgoingConfig.getServerSSL());
        this.serverSslField.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                OutgoingConfigScreen.this.serverSslField_FieldChanged(field, context);
            }
        });
        this.serverPortField = new BasicEditField(AbstractConfigScreen.resources.getString(24) + " ", Integer.toString(this.outgoingConfig.getServerPort()));
        this.serverPortField.setFilter(TextFilter.get((int)1));
        Object[] authTypes = new String[]{AbstractConfigScreen.resources.getString(63), "PLAIN", "LOGIN", "CRAM-MD5"};
        this.useAuthField = new ObjectChoiceField(AbstractConfigScreen.resources.getString(62) + " ", authTypes, this.outgoingConfig.getUseAuth());
        this.useAuthField.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                OutgoingConfigScreen.this.useAuthField_FieldChanged(field, context);
            }
        });
        this.serverUserField = new BasicEditField(AbstractConfigScreen.resources.getString(25) + " ", this.outgoingConfig.getServerUser());
        this.serverPassField = new PasswordEditField(AbstractConfigScreen.resources.getString(26) + " ", this.outgoingConfig.getServerPass());
        this.useMdsField = new CheckboxField(AbstractConfigScreen.resources.getString(27), !this.outgoingConfig.getDeviceSide());
        this.saveButton = new ButtonField(AbstractConfigScreen.resources.getString(28), 0x300000000L);
        this.saveButton.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                OutgoingConfigScreen.this.saveButton_FieldChanged(field, context);
            }
        });
        this.statusLabel = new LabelField();
        this.add((Field)this.acctNameField);
        this.add((Field)new SeparatorField());
        this.add((Field)this.serverNameField);
        this.add((Field)this.serverSslField);
        this.add((Field)this.serverPortField);
        this.add((Field)this.useAuthField);
        this.add((Field)this.serverUserField);
        this.add((Field)this.serverPassField);
        this.add((Field)this.useMdsField);
        this.add((Field)new LabelField(null, 0x80000000000000L));
        this.add((Field)this.saveButton);
        this.setStatus((Field)this.statusLabel);
    }

    private void serverSslField_FieldChanged(Field field, int context) {
        if (this.serverSslField.getChecked()) {
            this.serverPortField.setText("465");
        } else {
            this.serverPortField.setText("25");
        }
    }

    private void useAuthField_FieldChanged(Field field, int context) {
        if (this.useAuthField.getSelectedIndex() > 0) {
            this.serverUserField.setEditable(true);
            this.serverPassField.setEditable(true);
            this.serverUserField.setText(this.outgoingConfig.getServerUser());
            this.serverPassField.setText(this.outgoingConfig.getServerPass());
        } else {
            this.serverUserField.setEditable(false);
            this.serverPassField.setEditable(false);
            this.serverUserField.setText("");
            this.serverPassField.setText("");
        }
    }

    private void saveButton_FieldChanged(Field field, int context) {
        field.setDirty(false);
        this.onClose();
    }

    protected boolean onSavePrompt() {
        if (this.acctNameField.getText().length() > 0 && this.serverNameField.getText().length() > 0 && this.serverPortField.getText().length() > 0) {
            return super.onSavePrompt();
        }
        int result = Dialog.ask((String)AbstractConfigScreen.resources.getString(36), (Object[])new String[]{AbstractConfigScreen.resources.getString(37), AbstractConfigScreen.resources.getString(38)}, (int)0);
        return result == 0;
    }

    public void save() {
        this.outgoingConfig.setAcctName(this.acctNameField.getText());
        this.outgoingConfig.setServerName(this.serverNameField.getText());
        this.outgoingConfig.setServerSSL(this.serverSslField.getChecked());
        this.outgoingConfig.setServerPort(Integer.parseInt(this.serverPortField.getText()));
        this.outgoingConfig.setServerUser(this.serverUserField.getText());
        this.outgoingConfig.setServerPass(this.serverPassField.getText());
        this.outgoingConfig.setDeviceSide(!this.useMdsField.getChecked());
        this.outgoingConfig.setUseAuth(this.useAuthField.getSelectedIndex());
        if (this.useAuthField.getSelectedIndex() > 0) {
            this.outgoingConfig.setServerUser(this.serverUserField.getText());
            this.outgoingConfig.setServerPass(this.serverPassField.getText());
        }
        this.acctSaved = true;
    }

    public boolean acctSaved() {
        return this.acctSaved;
    }
}

