/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.StreamConnection;
import net.rim.device.api.crypto.tls.tls10.TLS10Connection;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.util.DataBuffer;
import net.rim.device.cldc.io.ssl.TLSException;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.MailSettings;

public class Connection {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static Vector openConnections = new Vector();
    private String serverName;
    private int serverPort;
    private boolean useSSL;
    private boolean deviceSide;
    private StreamConnection socket;
    private String localAddress;
    private GlobalConfig globalConfig;
    protected InputStream input;
    protected OutputStream output;
    private boolean useWiFi;
    private int fakeAvailable = -1;
    private int bytesSent = 0;
    private int bytesReceived = 0;
    private byte[] buffer = new byte[128];
    DataBuffer resultBuffer = new DataBuffer();

    public Connection(String serverName, int serverPort, boolean useSSL, boolean deviceSide) {
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.useSSL = useSSL;
        this.deviceSide = deviceSide;
        this.input = null;
        this.output = null;
        this.socket = null;
        this.globalConfig = MailSettings.getInstance().getGlobalConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() throws IOException {
        String msg;
        if (this.input != null || this.output != null || this.socket != null) {
            this.close();
        }
        Vector vector = openConnections;
        synchronized (vector) {
            if (!openConnections.contains(this)) {
                openConnections.addElement(this);
            }
        }
        String protocolStr = this.useSSL ? "ssl" : "socket";
        String paramStr = this.deviceSide ? ";deviceside=true" : "";
        this.useWiFi = false;
        if (this.globalConfig.getWifiMode() == 1) {
            UiApplication.getUiApplication().invokeAndWait(new Runnable(){

                public void run() {
                    Connection.this.useWiFi = Dialog.ask((int)3, (String)"Connect through WiFi?") == 4;
                }
            });
        } else if (this.globalConfig.getWifiMode() == 2) {
            this.useWiFi = true;
        }
        if (this.useWiFi) {
            paramStr = paramStr + ";interface=wifi";
        }
        String connectStr = protocolStr + "://" + this.serverName + ":" + this.serverPort + paramStr;
        if (EventLogger.getMinimumLevel() >= 4) {
            msg = "Opening connection:\r\n" + connectStr + "\r\n";
            EventLogger.logEvent((long)7765914274915215232L, (byte[])msg.getBytes(), (int)4);
        }
        this.socket = (StreamConnection)Connector.open((String)connectStr, (int)3, (boolean)true);
        this.input = this.socket.openDataInputStream();
        this.output = this.socket.openDataOutputStream();
        this.localAddress = ((SocketConnection)this.socket).getLocalAddress();
        this.bytesSent = 0;
        this.bytesReceived = 0;
        if (EventLogger.getMinimumLevel() >= 4) {
            msg = "Connection established:\r\nSocket: " + this.socket.getClass().toString() + "\r\n" + "Local address: " + this.localAddress + "\r\n";
            EventLogger.logEvent((long)7765914274915215232L, (byte[])msg.getBytes(), (int)4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (Exception exp) {
            this.input = null;
        }
        try {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
        }
        catch (Exception exp) {
            this.output = null;
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exp) {
            this.socket = null;
        }
        Vector vector = openConnections;
        synchronized (vector) {
            if (openConnections.contains(this)) {
                openConnections.removeElement(this);
            }
        }
        EventLogger.logEvent((long)7765914274915215232L, (byte[])"Connection closed".getBytes(), (int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOpenConnections() {
        boolean result;
        Vector vector = openConnections;
        synchronized (vector) {
            result = !openConnections.isEmpty();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConnections() {
        Vector vector = openConnections;
        synchronized (vector) {
            int size = openConnections.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ((Connection)openConnections.elementAt(i)).close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            openConnections.removeAllElements();
        }
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public int getBytesReceived() {
        return this.bytesReceived;
    }

    public synchronized void send(String s) throws IOException {
        byte[] bytes = s.getBytes();
        int length = bytes.length;
        if (s.length() == 0) {
            if (this.globalConfig.getConnDebug()) {
                EventLogger.logEvent((long)7765914274915215232L, (byte[])"[SEND]".getBytes(), (int)5);
            }
            this.output.write(CRLF, 0, 2);
            this.bytesSent += 2;
        } else {
            int i = 0;
            while (i < length) {
                int j;
                for (j = i; j < length && bytes[j] != 10 && bytes[j] != 13; ++j) {
                }
                if (this.globalConfig.getConnDebug()) {
                    EventLogger.logEvent((long)7765914274915215232L, (byte[])("[SEND] " + s.substring(i, j)).getBytes(), (int)5);
                }
                byte[] buf = (s.substring(i, j) + "\r\n").getBytes();
                this.output.write(buf);
                this.bytesSent += buf.length;
                if (j < length - 1 && bytes[j] == 13 && bytes[j + 1] == 10) {
                    ++j;
                }
                i = j + 1;
            }
        }
        this.output.flush();
    }

    public synchronized void sendCommand(String s) throws IOException {
        if (this.globalConfig.getConnDebug()) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("[SEND CMD] " + s).getBytes(), (int)5);
        }
        if (s == null) {
            this.output.write(CRLF, 0, 2);
            this.bytesSent += 2;
        } else {
            byte[] buf = (s + "\r\n").getBytes();
            this.output.write(buf);
            this.bytesSent += buf.length;
        }
        this.output.flush();
    }

    public synchronized void sendRaw(String s) throws IOException {
        byte[] buf = s.getBytes();
        if (this.globalConfig.getConnDebug()) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("[SEND RAW]\r\n" + s).getBytes(), (int)5);
        }
        this.output.write(buf, 0, buf.length);
        this.bytesSent += buf.length;
        this.output.flush();
    }

    public int available() throws IOException {
        if (this.fakeAvailable == -1) {
            return this.input.available();
        }
        return this.fakeAvailable;
    }

    public synchronized String receive() throws IOException {
        boolean stop = false;
        this.resultBuffer.reset();
        int actualAvailable = this.input.available();
        int readBytes = 0;
        while (!stop) {
            int count = 0;
            while (true) {
                int actual;
                if ((actual = this.input.read(this.buffer, count, 1)) == -1) {
                    EventLogger.logEvent((long)7765914274915215232L, (byte[])"Unable to read from socket, closing connection".getBytes(), (int)4);
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw new IOException("Connection closed");
                }
                if (actual == 0) {
                    try {
                        Thread.yield();
                    }
                    catch (Exception e) {}
                    continue;
                }
                this.bytesReceived += actual;
                byte b = this.buffer[count];
                ++readBytes;
                if (b == 13) continue;
                if (b == 10) {
                    stop = true;
                    break;
                }
                if (++count == this.buffer.length) break;
            }
            this.resultBuffer.write(this.buffer, 0, count);
        }
        String result = new String(this.resultBuffer.toArray());
        if (this.globalConfig.getConnDebug()) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("[RECV] " + result).getBytes(), (int)5);
        }
        this.fakeAvailable = actualAvailable > readBytes ? actualAvailable - readBytes : -1;
        return result;
    }

    public void startTLS() throws IOException {
        if (this.socket instanceof TLS10Connection) {
            return;
        }
        try {
            TLS10Connection tlsSocket = new TLS10Connection((StreamConnection)new StreamConnectionWrapper(this.socket, (DataInputStream)this.input, (DataOutputStream)this.output), this.serverName + ':' + this.serverPort, true);
            this.socket = tlsSocket;
            this.input = this.socket.openDataInputStream();
            this.output = this.socket.openDataOutputStream();
        }
        catch (IOException e) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to switch to TLS mode: " + e.getMessage()).getBytes(), (int)2);
            throw new IOException("Unable to switch to TLS mode");
        }
        catch (TLSException e) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to switch to TLS mode: " + e.getMessage()).getBytes(), (int)2);
            throw new IOException("Unable to switch to TLS mode");
        }
    }

    private static class StreamConnectionWrapper
    implements StreamConnection {
        private StreamConnection stream;
        private DataInputStream dataInputStream;
        private DataOutputStream dataOutputStream;

        public StreamConnectionWrapper(StreamConnection stream, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
            this.stream = stream;
            this.dataInputStream = dataInputStream;
            this.dataOutputStream = dataOutputStream;
        }

        public DataInputStream openDataInputStream() throws IOException {
            return this.dataInputStream;
        }

        public InputStream openInputStream() throws IOException {
            return this.dataInputStream;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public DataOutputStream openDataOutputStream() throws IOException {
            return this.dataOutputStream;
        }

        public OutputStream openOutputStream() throws IOException {
            return this.dataOutputStream;
        }
    }
}

