/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class SerializableVector
extends Vector
implements Serializable {
    private static final int TYPE_NULL = 0;
    private static final int TYPE_BOOLEAN = 1;
    private static final int TYPE_BYTE = 2;
    private static final int TYPE_CHAR = 3;
    private static final int TYPE_STRING = 4;
    private static final int TYPE_DOUBLE = 5;
    private static final int TYPE_FLOAT = 6;
    private static final int TYPE_INT = 7;
    private static final int TYPE_LONG = 8;
    private static final int TYPE_SHORT = 9;
    private static final int MAX_ITEMS = 1000;
    private long uniqueId = UniqueIdGenerator.getInstance().getUniqueId();

    public SerializableVector() {
    }

    public SerializableVector(int initialCapacity) {
        super(initialCapacity);
    }

    private static void writeObject(DataOutputStream output, Object item) throws IOException {
        if (item instanceof Boolean) {
            output.write(1);
            output.writeBoolean((Boolean)item);
        } else if (item instanceof Byte) {
            output.write(2);
            output.writeByte(((Byte)item).byteValue());
        } else if (item instanceof Character) {
            output.write(3);
            output.writeChar(((Character)item).charValue());
        } else if (item instanceof String) {
            output.write(4);
            output.writeUTF((String)item);
        } else if (item instanceof Double) {
            output.write(5);
            output.writeDouble((Double)item);
        } else if (item instanceof Float) {
            output.write(6);
            output.writeFloat(((Float)item).floatValue());
        } else if (item instanceof Integer) {
            output.write(7);
            output.writeInt((Integer)item);
        } else if (item instanceof Long) {
            output.write(8);
            output.writeLong((Long)item);
        } else if (item instanceof Short) {
            output.write(9);
            output.writeShort(((Short)item).shortValue());
        } else {
            output.write(0);
            output.write(0);
        }
    }

    private static Object readObject(DataInputStream input) throws IOException {
        int type = input.read();
        switch (type) {
            case 1: {
                return new Boolean(input.readBoolean());
            }
            case 2: {
                return new Byte(input.readByte());
            }
            case 3: {
                return new Character(input.readChar());
            }
            case 4: {
                return input.readUTF();
            }
            case 5: {
                return new Double(input.readDouble());
            }
            case 6: {
                return new Float(input.readFloat());
            }
            case 7: {
                return new Integer(input.readInt());
            }
            case 8: {
                return new Long(input.readLong());
            }
            case 9: {
                return new Short(input.readShort());
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        int size = this.size();
        output.writeInt(size);
        for (int i = 0; i < size; ++i) {
            SerializableVector.writeObject(output, this.elementAt(i));
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.removeAllElements();
        this.uniqueId = input.readLong();
        int size = input.readInt();
        if (size > 1000) {
            throw new IOException();
        }
        for (int i = 0; i < size; ++i) {
            this.addElement(SerializableVector.readObject(input));
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }
}

